/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.settings;

import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cluster.IClusterService;
import com.tandbergtv.workflow.core.settings.ISettingsProvider;
import com.tandbergtv.workflow.core.settings.SettingsPluginLoader;
import com.tandbergtv.workflow.settings.NeptuneSettingsCache;
import java.io.Serializable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class NeptuneSettingsLoaderService
implements Service {
    private static final long DEFAULT_DELAY = 5L;
    private static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.SECONDS;
    private static final long DEFAULT_REFRESH_INTERVAL = 900L;
    private static final Logger LOGGER = Logger.getLogger(NeptuneSettingsLoaderService.class);
    private ScheduledExecutorService scheduledExecutorService;
    private ISettingsProvider settingsProvider;
    private NeptuneSettingsCache neptuneSettingsCache;
    private String[] paths = new String[]{"com.ericsson.cms.email"};
    private long delay = 5L;
    private long interval = 900L;
    private TimeUnit unit = DEFAULT_TIME_UNIT;
    private IClusterService clusterService;

    public NeptuneSettingsLoaderService() {
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    }

    public void start() {
        if (this.getNeptuneSettingsCache() == null) {
            throw new IllegalStateException("NeptuneSettingsCache is not ready for use");
        }
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (!NeptuneSettingsLoaderService.this.getClusterService().isMaster()) {
                    LOGGER.info((Object)"Not a master node, skip Neptune Setting loading");
                    return;
                }
                if (NeptuneSettingsLoaderService.this.getSettingsProvider() == null) {
                    LOGGER.warn((Object)"NeptuneSettingsProvider is not properly setup, cannot get settings");
                    return;
                }
                for (String path : NeptuneSettingsLoaderService.this.paths) {
                    try {
                        String oldValue = (String)NeptuneSettingsLoaderService.this.getNeptuneSettingsCache().get((Serializable)((Object)path));
                        String newValue = NeptuneSettingsLoaderService.this.getSettingsProvider().getPropertiesAsJSON(path);
                        if (oldValue != null && StringUtils.equals((String)oldValue, (String)newValue)) continue;
                        NeptuneSettingsLoaderService.this.getNeptuneSettingsCache().add((Serializable)((Object)path), newValue);
                        LOGGER.info((Object)("setting[" + path + "] updated with value[" + newValue + "]"));
                    }
                    catch (Exception e) {
                        LOGGER.warn((Object)("refreshing Neptune setting[" + path + "] fail"), (Throwable)e);
                    }
                }
            }
        }, this.delay, this.interval, this.unit);
    }

    public void stop() {
        this.scheduledExecutorService.shutdown();
    }

    public String getServiceName() {
        return NeptuneSettingsLoaderService.class.getName();
    }

    protected void setSettingsProvider(ISettingsProvider settingsProvider) {
        this.settingsProvider = settingsProvider;
    }

    protected ISettingsProvider getSettingsProvider() {
        if (this.settingsProvider == null) {
            SettingsPluginLoader settingsPluginLoader = new SettingsPluginLoader();
            this.settingsProvider = settingsPluginLoader.createSettingsProvider();
        }
        return this.settingsProvider;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public void setUnit(TimeUnit unit) {
        this.unit = unit;
    }

    public void setSettingPaths(String[] paths) {
        this.paths = paths;
    }

    private NeptuneSettingsCache getNeptuneSettingsCache() {
        if (this.neptuneSettingsCache == null) {
            this.neptuneSettingsCache = (NeptuneSettingsCache)ServiceRegistry.getDefault().lookup("WFS:NeptuneSettingsCache");
        }
        return this.neptuneSettingsCache;
    }

    protected void setNeptuneSettingsCache(NeptuneSettingsCache neptuneSettingsCache) {
        this.neptuneSettingsCache = neptuneSettingsCache;
    }

    private IClusterService getClusterService() {
        if (this.clusterService == null) {
            this.clusterService = (IClusterService)ServiceRegistry.getDefault().lookup(IClusterService.class);
        }
        return this.clusterService;
    }

    protected void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }
}

