/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.contrib.ssl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthSSLX509TrustManager
implements X509TrustManager {
    private X509TrustManager defaultTrustManager = null;
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$commons$httpclient$contrib$ssl$AuthSSLX509TrustManager == null ? (class$org$apache$commons$httpclient$contrib$ssl$AuthSSLX509TrustManager = AuthSSLX509TrustManager.class$("org.apache.commons.httpclient.contrib.ssl.AuthSSLX509TrustManager")) : class$org$apache$commons$httpclient$contrib$ssl$AuthSSLX509TrustManager));
    static /* synthetic */ Class class$org$apache$commons$httpclient$contrib$ssl$AuthSSLX509TrustManager;

    public AuthSSLX509TrustManager(X509TrustManager x509TrustManager) {
        if (x509TrustManager == null) {
            throw new IllegalArgumentException("Trust manager may not be null");
        }
        this.defaultTrustManager = x509TrustManager;
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        if (LOG.isInfoEnabled() && x509CertificateArray != null) {
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                X509Certificate x509Certificate = x509CertificateArray[i];
                LOG.info((Object)(" Client certificate " + (i + 1) + ":"));
                LOG.info((Object)("  Subject DN: " + x509Certificate.getSubjectDN()));
                LOG.info((Object)("  Signature Algorithm: " + x509Certificate.getSigAlgName()));
                LOG.info((Object)("  Valid from: " + x509Certificate.getNotBefore()));
                LOG.info((Object)("  Valid until: " + x509Certificate.getNotAfter()));
                LOG.info((Object)("  Issuer: " + x509Certificate.getIssuerDN()));
            }
        }
        this.defaultTrustManager.checkClientTrusted(x509CertificateArray, string);
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        if (LOG.isInfoEnabled() && x509CertificateArray != null) {
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                X509Certificate x509Certificate = x509CertificateArray[i];
                LOG.info((Object)(" Server certificate " + (i + 1) + ":"));
                LOG.info((Object)("  Subject DN: " + x509Certificate.getSubjectDN()));
                LOG.info((Object)("  Signature Algorithm: " + x509Certificate.getSigAlgName()));
                LOG.info((Object)("  Valid from: " + x509Certificate.getNotBefore()));
                LOG.info((Object)("  Valid until: " + x509Certificate.getNotAfter()));
                LOG.info((Object)("  Issuer: " + x509Certificate.getIssuerDN()));
            }
        }
        this.defaultTrustManager.checkServerTrusted(x509CertificateArray, string);
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.defaultTrustManager.getAcceptedIssuers();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

