/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.transaction.locking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.transaction.locking.GenericLock;
import org.apache.commons.transaction.locking.LockException;
import org.apache.commons.transaction.locking.LockManager;
import org.apache.commons.transaction.locking.LockManager2;
import org.apache.commons.transaction.locking.MultiLevelLock;
import org.apache.commons.transaction.util.LoggerFacade;

public class GenericLockManager
implements LockManager,
LockManager2 {
    public static final long DEFAULT_TIMEOUT = 30000L;
    public static final long DEFAULT_CHECK_THRESHHOLD = 500L;
    protected Map globalOwners = Collections.synchronizedMap(new HashMap());
    protected Map globalLocks = new HashMap();
    protected Map effectiveGlobalTimeouts = Collections.synchronizedMap(new HashMap());
    protected Set timedOutOwners = Collections.synchronizedSet(new HashSet());
    protected int maxLockLevel = -1;
    protected LoggerFacade logger;
    protected long globalTimeoutMSecs;
    protected long checkThreshhold;

    public GenericLockManager(int maxLockLevel, LoggerFacade logger, long timeoutMSecs, long checkThreshholdMSecs) throws IllegalArgumentException {
        if (maxLockLevel < 1) {
            throw new IllegalArgumentException("The maximum lock level must be at least 1 (" + maxLockLevel + " was specified)");
        }
        this.maxLockLevel = maxLockLevel;
        this.logger = logger.createLogger("Locking");
        this.globalTimeoutMSecs = timeoutMSecs;
        this.checkThreshhold = checkThreshholdMSecs;
    }

    public GenericLockManager(int maxLockLevel, LoggerFacade logger, long timeoutMSecs) throws IllegalArgumentException {
        this(maxLockLevel, logger, timeoutMSecs, 500L);
    }

    public GenericLockManager(int maxLockLevel, LoggerFacade logger) throws IllegalArgumentException {
        this(maxLockLevel, logger, 30000L);
    }

    public void startGlobalTimeout(Object ownerId, long timeoutMSecs) {
        long now = System.currentTimeMillis();
        long timeout = now + timeoutMSecs;
        this.effectiveGlobalTimeouts.put(ownerId, new Long(timeout));
    }

    public boolean tryLock(Object ownerId, Object resourceId, int targetLockLevel, boolean reentrant) {
        this.timeoutCheck(ownerId);
        GenericLock lock = (GenericLock)this.atomicGetOrCreateLock(resourceId);
        boolean acquired = lock.tryLock(ownerId, targetLockLevel, reentrant ? 1 : 0, false);
        if (acquired) {
            this.addOwner(ownerId, lock);
        }
        return acquired;
    }

    public boolean checkLock(Object ownerId, Object resourceId, int targetLockLevel, boolean reentrant) {
        this.timeoutCheck(ownerId);
        boolean possible = true;
        GenericLock lock = (GenericLock)this.getLock(resourceId);
        if (lock != null) {
            possible = lock.test(ownerId, targetLockLevel, reentrant ? 1 : 0);
        }
        return possible;
    }

    public boolean hasLock(Object ownerId, Object resourceId, int lockLevel) {
        this.timeoutCheck(ownerId);
        boolean owned = false;
        GenericLock lock = (GenericLock)this.getLock(resourceId);
        if (lock != null) {
            owned = lock.has(ownerId, lockLevel);
        }
        return owned;
    }

    public void lock(Object ownerId, Object resourceId, int targetLockLevel, boolean reentrant) throws LockException {
        this.lock(ownerId, resourceId, targetLockLevel, reentrant, this.globalTimeoutMSecs);
    }

    public void lock(Object ownerId, Object resourceId, int targetLockLevel, boolean reentrant, long timeoutMSecs) throws LockException {
        this.lock(ownerId, resourceId, targetLockLevel, reentrant ? 1 : 0, false, timeoutMSecs);
    }

    public void lock(Object ownerId, Object resourceId, int targetLockLevel, int compatibility, boolean preferred, long timeoutMSecs) throws LockException {
        this.timeoutCheck(ownerId);
        GenericLock lock = (GenericLock)this.atomicGetOrCreateLock(resourceId);
        this.doLock(lock, ownerId, resourceId, targetLockLevel, compatibility, preferred, timeoutMSecs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLock(GenericLock lock, Object ownerId, Object resourceId, int targetLockLevel, int compatibility, boolean preferred, long timeoutMSecs) {
        long now = System.currentTimeMillis();
        long waitEnd = now + timeoutMSecs;
        this.timeoutCheck(ownerId);
        GenericLock.LockOwner lockWaiter = new GenericLock.LockOwner(ownerId, targetLockLevel, compatibility, preferred);
        boolean acquired = false;
        try {
            if (this.checkThreshhold != -1L && timeoutMSecs > this.checkThreshhold) {
                acquired = lock.acquire(ownerId, targetLockLevel, true, compatibility, preferred, this.checkThreshhold);
                timeoutMSecs -= this.checkThreshhold;
            } else {
                acquired = lock.acquire(ownerId, targetLockLevel, false, compatibility, preferred, this.checkThreshhold);
            }
            if (acquired) {
                this.addOwner(ownerId, lock);
                return;
            }
        }
        catch (InterruptedException e) {
            throw new LockException("Interrupted", 1, resourceId);
        }
        try {
            lock.registerWaiter(lockWaiter);
            boolean deadlock = this.wouldDeadlock(ownerId, new HashSet());
            if (deadlock) {
                throw new LockException("Lock would cause deadlock", 3, resourceId);
            }
            now = System.currentTimeMillis();
            while (!acquired && waitEnd > now) {
                this.releaseTimedOutOwners();
                Set conflicts = lock.getConflictingOwners(ownerId, targetLockLevel, compatibility);
                long nextConflictTimeout = this.getNextGlobalConflictTimeout(conflicts);
                if (nextConflictTimeout != -1L && nextConflictTimeout < waitEnd) {
                    timeoutMSecs = nextConflictTimeout - now;
                    timeoutMSecs += timeoutMSecs / 10L;
                } else {
                    timeoutMSecs = waitEnd - now;
                }
                GenericLock genericLock = lock;
                synchronized (genericLock) {
                    acquired = lock.acquire(ownerId, targetLockLevel, true, compatibility, preferred, timeoutMSecs);
                    lock.registerWaiter(lockWaiter);
                }
                now = System.currentTimeMillis();
            }
            if (!acquired) {
                throw new LockException("Lock wait timed out", 2, resourceId);
            }
            this.addOwner(ownerId, lock);
        }
        catch (InterruptedException e) {
            throw new LockException("Interrupted", 1, resourceId);
        }
        finally {
            lock.unregisterWaiter(lockWaiter);
        }
    }

    public int getLevel(Object ownerId, Object resourceId) {
        this.timeoutCheck(ownerId);
        GenericLock lock = (GenericLock)this.getLock(resourceId);
        if (lock != null) {
            return lock.getLockLevel(ownerId);
        }
        return 0;
    }

    public boolean release(Object ownerId, Object resourceId) {
        this.timeoutCheck(ownerId);
        boolean released = false;
        GenericLock lock = (GenericLock)this.getLock(resourceId);
        if (lock != null) {
            released = lock.release(ownerId);
            this.removeOwner(ownerId, lock);
        }
        return released;
    }

    public void releaseAll(Object ownerId) {
        this.releaseAllNoTimeOutReset(ownerId);
        this.timedOutOwners.remove(ownerId);
        this.effectiveGlobalTimeouts.remove(ownerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseAllNoTimeOutReset(Object ownerId) {
        Set locks = (Set)this.globalOwners.get(ownerId);
        if (locks != null) {
            ArrayList locksCopy;
            Set set = locks;
            synchronized (set) {
                locksCopy = new ArrayList(locks);
            }
            Iterator it = locksCopy.iterator();
            while (it.hasNext()) {
                GenericLock lock = (GenericLock)it.next();
                lock.release(ownerId);
                locks.remove(lock);
            }
        }
    }

    public Set getAll(Object ownerId) {
        Set locks = (Set)this.globalOwners.get(ownerId);
        if (locks == null) {
            return new HashSet();
        }
        return locks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addOwner(Object ownerId, GenericLock lock) {
        Map map = this.globalOwners;
        synchronized (map) {
            Set<GenericLock> locks = (Set<GenericLock>)this.globalOwners.get(ownerId);
            if (locks == null) {
                locks = Collections.synchronizedSet(new HashSet());
                this.globalOwners.put(ownerId, locks);
            }
            locks.add(lock);
        }
    }

    protected void removeOwner(Object ownerId, GenericLock lock) {
        Set locks = (Set)this.globalOwners.get(ownerId);
        if (locks != null) {
            locks.remove(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean wouldDeadlock(Object ownerId, Set path) {
        path.add(ownerId);
        Set locks = (Set)this.globalOwners.get(ownerId);
        if (locks != null) {
            ArrayList locksCopy;
            Set set = locks;
            synchronized (set) {
                locksCopy = new ArrayList(locks);
            }
            Iterator i = locksCopy.iterator();
            while (i.hasNext()) {
                GenericLock mylock = (GenericLock)i.next();
                Collection conflicts = mylock.getConflictingWaiters(ownerId);
                if (conflicts == null) continue;
                Iterator j = conflicts.iterator();
                while (j.hasNext()) {
                    Object waitingOwnerId = j.next();
                    if (path.contains(waitingOwnerId)) {
                        return true;
                    }
                    if (!this.wouldDeadlock(waitingOwnerId, path)) continue;
                    return true;
                }
            }
        }
        path.remove(ownerId);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean releaseTimedOutOwners() {
        boolean released = false;
        Map map = this.effectiveGlobalTimeouts;
        synchronized (map) {
            Iterator it = this.effectiveGlobalTimeouts.entrySet().iterator();
            while (it.hasNext()) {
                long now;
                Map.Entry entry = it.next();
                Object ownerId = entry.getKey();
                long timeout = (Long)entry.getValue();
                if (timeout >= (now = System.currentTimeMillis())) continue;
                this.releaseAllNoTimeOutReset(ownerId);
                this.timedOutOwners.add(ownerId);
                released = true;
            }
        }
        return released;
    }

    protected boolean timeOut(Object ownerId) {
        Long timeout = (Long)this.effectiveGlobalTimeouts.get(ownerId);
        long now = System.currentTimeMillis();
        if (timeout != null && timeout < now) {
            this.releaseAll(ownerId);
            this.timedOutOwners.add(ownerId);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getNextGlobalConflictTimeout(Set conflicts) {
        long minTimeout = -1L;
        long now = System.currentTimeMillis();
        if (conflicts != null) {
            Map map = this.effectiveGlobalTimeouts;
            synchronized (map) {
                Iterator it = this.effectiveGlobalTimeouts.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    Object ownerId = entry.getKey();
                    if (!conflicts.contains(ownerId)) continue;
                    long timeout = (Long)entry.getValue();
                    if (minTimeout != -1L && timeout >= minTimeout) continue;
                    minTimeout = timeout;
                }
            }
        }
        return minTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiLevelLock getLock(Object resourceId) {
        Map map = this.globalLocks;
        synchronized (map) {
            return (MultiLevelLock)this.globalLocks.get(resourceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiLevelLock atomicGetOrCreateLock(Object resourceId) {
        Map map = this.globalLocks;
        synchronized (map) {
            MultiLevelLock lock = this.getLock(resourceId);
            if (lock == null) {
                lock = this.createLock(resourceId);
            }
            return lock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLock(MultiLevelLock lock) {
        Map map = this.globalLocks;
        synchronized (map) {
            this.globalLocks.remove(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getLocks() {
        Map map = this.globalLocks;
        synchronized (map) {
            return this.globalLocks.values();
        }
    }

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer(1000);
        Iterator it = this.globalLocks.values().iterator();
        while (it.hasNext()) {
            GenericLock lock = (GenericLock)it.next();
            buf.append(lock.toString()).append('\n');
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GenericLock createLock(Object resourceId) {
        Map map = this.globalLocks;
        synchronized (map) {
            GenericLock lock = new GenericLock(resourceId, this.maxLockLevel, this.logger);
            this.globalLocks.put(resourceId, lock);
            return lock;
        }
    }

    protected void timeoutCheck(Object ownerId) throws LockException {
        this.timeOut(ownerId);
        if (this.timedOutOwners.contains(ownerId)) {
            throw new LockException("All locks of owner " + ownerId + " have globally timed out." + " You will not be able to to continue with this owner until you call releaseAll.", 2, null);
        }
    }
}

