/*
 * Decompiled with CFR 0.152.
 */
package com.edb.util;

import com.edb.jdbc2.Struct;
import com.edb.util.StructUtils;
import java.util.ArrayList;
import java.util.List;

public class StructParser {
    private static String getQuotesChars(int level) {
        if (level <= 0) {
            return "";
        }
        String src = "";
        int iterations = (int)Math.pow(2.0, level - 1);
        for (int i = 1; i <= iterations; ++i) {
            src = src + "\"";
        }
        return src;
    }

    private static String escapeQuotes(String text, String escapeQuotes) {
        if ((text = text.replaceAll(escapeQuotes, "\"")).startsWith("\"") && text.endsWith("\"")) {
            text = text.substring(1);
            text = text.substring(0, text.length() - 1);
            text = text.replaceAll("\"\"", "\"");
        }
        return text;
    }

    public static List parse(String txt) {
        return StructParser.parse(txt, 1).getAttributesInternal();
    }

    public static Struct parse(String txt, int level) {
        ArrayList<Object> list = new ArrayList<Object>();
        Struct struct = new Struct(list, "row");
        String quotesChars = StructParser.getQuotesChars(level);
        String outerQuotes = StructParser.getQuotesChars(level - 1);
        if (!txt.startsWith(outerQuotes + "(") && !txt.endsWith(outerQuotes + ")")) {
            throw new RuntimeException("Not a valid construct for a Row");
        }
        txt = txt.substring(outerQuotes.length() + 1);
        txt = txt.substring(0, txt.length() - outerQuotes.length() - 1);
        boolean inQuotes = false;
        String currentToken = "";
        for (int i = 0; i < txt.length(); ++i) {
            if (txt.startsWith(quotesChars, i)) {
                inQuotes = !inQuotes;
                currentToken = currentToken + quotesChars;
                i += quotesChars.length() - 1;
                continue;
            }
            if (txt.charAt(i) == ',') {
                if (inQuotes) {
                    currentToken = currentToken + ",";
                    continue;
                }
                if (currentToken.length() > 0 && currentToken.startsWith(quotesChars + "(") && currentToken.endsWith(")" + quotesChars)) {
                    list.add(StructParser.parse(currentToken, level + 1));
                } else {
                    list.add(StructUtils.adjustLevel(currentToken, 2003));
                }
                currentToken = "";
                continue;
            }
            currentToken = currentToken + txt.charAt(i);
        }
        if (currentToken.length() > 0 && currentToken.startsWith(quotesChars + "(") && currentToken.endsWith(")" + quotesChars)) {
            list.add(StructParser.parse(currentToken, level + 1));
        } else {
            list.add(StructUtils.adjustLevel(currentToken, 2003));
        }
        return struct;
    }
}

