/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bytes;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.GatheringByteChannel;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;

public interface BytesReference {
    public byte get(int var1);

    public int length();

    public BytesReference slice(int var1, int var2);

    public StreamInput streamInput();

    public void writeTo(OutputStream var1) throws IOException;

    public void writeTo(GatheringByteChannel var1) throws IOException;

    public byte[] toBytes();

    public BytesArray toBytesArray();

    public BytesArray copyBytesArray();

    public ChannelBuffer toChannelBuffer();

    public boolean hasArray();

    public byte[] array();

    public int arrayOffset();

    public String toUtf8();

    public BytesRef toBytesRef();

    public BytesRef copyBytesRef();

    public static class Helper {
        public static boolean bytesEqual(BytesReference a, BytesReference b) {
            if (a == b) {
                return true;
            }
            if (a.length() != b.length()) {
                return false;
            }
            if (!a.hasArray()) {
                a = a.toBytesArray();
            }
            if (!b.hasArray()) {
                b = b.toBytesArray();
            }
            int bUpTo = b.arrayOffset();
            byte[] aArray = a.array();
            byte[] bArray = b.array();
            int end = a.arrayOffset() + a.length();
            int aUpTo = a.arrayOffset();
            while (aUpTo < end) {
                if (aArray[aUpTo] != bArray[bUpTo]) {
                    return false;
                }
                ++aUpTo;
                ++bUpTo;
            }
            return true;
        }

        public static int bytesHashCode(BytesReference a) {
            if (!a.hasArray()) {
                a = a.toBytesArray();
            }
            int result = 0;
            int end = a.arrayOffset() + a.length();
            for (int i = a.arrayOffset(); i < end; ++i) {
                result = 31 * result + a.array()[i];
            }
            return result;
        }
    }
}

