/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.util;

import org.elasticsearch.common.mvel2.Operator;
import org.elasticsearch.common.mvel2.ast.ASTNode;
import org.elasticsearch.common.mvel2.ast.EndOfStatement;
import org.elasticsearch.common.mvel2.ast.OperatorNode;
import org.elasticsearch.common.mvel2.util.ASTIterator;
import org.elasticsearch.common.mvel2.util.ASTLinkedList;
import org.elasticsearch.common.mvel2.util.CompatibilityStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTBinaryTree {
    private ASTNode root;
    private ASTBinaryTree left;
    private ASTBinaryTree right;

    public ASTBinaryTree(ASTNode node) {
        this.root = node;
    }

    public ASTBinaryTree append(ASTNode node) {
        if (this.comparePrecedence(this.root, node) >= 0) {
            ASTBinaryTree tree = new ASTBinaryTree(node);
            tree.left = this;
            return tree;
        }
        if (this.left == null) {
            throw new RuntimeException("Missing left node");
        }
        this.right = this.right == null ? new ASTBinaryTree(node) : this.right.append(node);
        return this;
    }

    public Class<?> getReturnType(boolean strongTyping) {
        if (!(this.root instanceof OperatorNode)) {
            return this.root.getEgressType();
        }
        if (this.left == null || this.right == null) {
            throw new RuntimeException("Malformed expression");
        }
        Class<?> leftType = this.left.getReturnType(strongTyping);
        Class<?> rightType = this.right.getReturnType(strongTyping);
        switch (((OperatorNode)this.root).getOperator()) {
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                return Boolean.class;
            }
            case 0: {
                if (leftType.equals(String.class) || rightType.equals(String.class)) {
                    return String.class;
                }
            }
            case 1: 
            case 2: 
            case 3: {
                if (strongTyping && !CompatibilityStrategy.areEqualityCompatible(leftType, rightType)) {
                    throw new RuntimeException("Associative operation requires compatible types. Found " + leftType + " and " + rightType);
                }
                return Double.class;
            }
            case 30: {
                if (strongTyping && !CompatibilityStrategy.areEqualityCompatible(leftType, rightType)) {
                    throw new RuntimeException("Associative operation requires compatible types. Found " + leftType + " and " + rightType);
                }
                return leftType;
            }
            case 18: 
            case 19: {
                if (strongTyping && !CompatibilityStrategy.areEqualityCompatible(leftType, rightType)) {
                    throw new RuntimeException("Comparison operation requires compatible types. Found " + leftType + " and " + rightType);
                }
                return Boolean.class;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                if (strongTyping && !CompatibilityStrategy.areComparisonCompatible(leftType, rightType)) {
                    throw new RuntimeException("Comparison operation requires compatible types. Found " + leftType + " and " + rightType);
                }
                return Boolean.class;
            }
            case 21: 
            case 22: {
                if (strongTyping) {
                    if (leftType != Boolean.class && leftType != Boolean.TYPE) {
                        throw new RuntimeException("Left side of logical operation is not of type boolean. Found " + leftType);
                    }
                    if (rightType != Boolean.class && rightType != Boolean.TYPE) {
                        throw new RuntimeException("Right side of logical operation is not of type boolean. Found " + rightType);
                    }
                }
                return Boolean.class;
            }
            case 29: {
                if (strongTyping && leftType != Boolean.class && leftType != Boolean.TYPE) {
                    throw new RuntimeException("Condition of ternary operator is not of type boolean. Found " + leftType);
                }
                return rightType;
            }
        }
        return this.root.getEgressType();
    }

    private int comparePrecedence(ASTNode node1, ASTNode node2) {
        if (!(node1 instanceof OperatorNode) && !(node2 instanceof OperatorNode)) {
            return 0;
        }
        if (node1 instanceof OperatorNode && node2 instanceof OperatorNode) {
            return Operator.PTABLE[((OperatorNode)node1).getOperator()] - Operator.PTABLE[((OperatorNode)node2).getOperator()];
        }
        return node1 instanceof OperatorNode ? -1 : 1;
    }

    public static ASTBinaryTree buildTree(ASTIterator input) {
        ASTLinkedList iter = new ASTLinkedList(input.firstNode());
        ASTBinaryTree tree = new ASTBinaryTree(iter.nextNode());
        while (iter.hasMoreNodes()) {
            ASTNode node = iter.nextNode();
            if (node instanceof EndOfStatement) {
                if (!iter.hasMoreNodes()) continue;
                tree = new ASTBinaryTree(iter.nextNode());
                continue;
            }
            tree = tree.append(node);
        }
        return tree;
    }
}

