/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermFilter;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredDocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.lucene.search.ApplyAcceptedDocsFilter;
import org.elasticsearch.common.lucene.search.NoopCollector;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.plain.ParentChildAtomicFieldData;
import org.elasticsearch.index.fielddata.plain.ParentChildIndexFieldData;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.search.child.ConstantScorer;
import org.elasticsearch.index.search.child.ParentIdsFilter;
import org.elasticsearch.search.internal.SearchContext;

public class ChildrenConstantScoreQuery
extends Query {
    private final ParentChildIndexFieldData parentChildIndexFieldData;
    private Query originalChildQuery;
    private final String parentType;
    private final String childType;
    private final Filter parentFilter;
    private final int shortCircuitParentDocSet;
    private final Filter nonNestedDocsFilter;
    private Query rewrittenChildQuery;
    private IndexReader rewriteIndexReader;

    public ChildrenConstantScoreQuery(ParentChildIndexFieldData parentChildIndexFieldData, Query childQuery, String parentType, String childType, Filter parentFilter, int shortCircuitParentDocSet, Filter nonNestedDocsFilter) {
        this.parentChildIndexFieldData = parentChildIndexFieldData;
        this.parentFilter = parentFilter;
        this.parentType = parentType;
        this.childType = childType;
        this.originalChildQuery = childQuery;
        this.shortCircuitParentDocSet = shortCircuitParentDocSet;
        this.nonNestedDocsFilter = nonNestedDocsFilter;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.rewrittenChildQuery == null) {
            this.rewrittenChildQuery = this.originalChildQuery.rewrite(reader);
            this.rewriteIndexReader = reader;
        }
        return this;
    }

    public void extractTerms(Set<Term> terms) {
        this.rewrittenChildQuery.extractTerms(terms);
    }

    public Query clone() {
        ChildrenConstantScoreQuery q = (ChildrenConstantScoreQuery)super.clone();
        q.originalChildQuery = this.originalChildQuery.clone();
        if (q.rewrittenChildQuery != null) {
            q.rewrittenChildQuery = this.rewrittenChildQuery.clone();
        }
        return q;
    }

    public Weight createWeight(IndexSearcher searcher) throws IOException {
        Query childQuery;
        SearchContext searchContext = SearchContext.current();
        BytesRefHash parentIds = new BytesRefHash(512L, searchContext.bigArrays());
        ParentIdCollector collector = new ParentIdCollector(this.parentType, this.parentChildIndexFieldData, parentIds);
        if (this.rewrittenChildQuery == null) {
            childQuery = this.rewrittenChildQuery = searcher.rewrite(this.originalChildQuery);
        } else {
            assert (this.rewriteIndexReader == searcher.getIndexReader()) : "not equal, rewriteIndexReader=" + this.rewriteIndexReader + " searcher.getIndexReader()=" + searcher.getIndexReader();
            childQuery = this.rewrittenChildQuery;
        }
        IndexSearcher indexSearcher = new IndexSearcher(searcher.getIndexReader());
        indexSearcher.setSimilarity(searcher.getSimilarity());
        indexSearcher.search(childQuery, (Collector)collector);
        long remaining = parentIds.size();
        if (remaining == 0L) {
            Releasables.release(parentIds);
            return Queries.newMatchNoDocsQuery().createWeight(searcher);
        }
        ParentIdsFilter shortCircuitFilter = null;
        if (remaining == 1L) {
            BytesRef id = parentIds.get(0L, new BytesRef());
            shortCircuitFilter = new TermFilter(new Term("_uid", Uid.createUidAsBytes(this.parentType, id)));
        } else if (remaining <= (long)this.shortCircuitParentDocSet) {
            shortCircuitFilter = new ParentIdsFilter(this.parentType, this.nonNestedDocsFilter, parentIds);
        }
        ParentWeight parentWeight = new ParentWeight(this.parentFilter, shortCircuitFilter, parentIds);
        searchContext.addReleasable(parentWeight);
        return parentWeight;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        ChildrenConstantScoreQuery that = (ChildrenConstantScoreQuery)((Object)obj);
        if (!this.originalChildQuery.equals((Object)that.originalChildQuery)) {
            return false;
        }
        if (!this.childType.equals(that.childType)) {
            return false;
        }
        if (this.shortCircuitParentDocSet != that.shortCircuitParentDocSet) {
            return false;
        }
        return this.getBoost() == that.getBoost();
    }

    public int hashCode() {
        int result = this.originalChildQuery.hashCode();
        result = 31 * result + this.childType.hashCode();
        result = 31 * result + this.shortCircuitParentDocSet;
        result = 31 * result + Float.floatToIntBits(this.getBoost());
        return result;
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("child_filter[").append(this.childType).append("/").append(this.parentType).append("](").append(this.originalChildQuery).append(')');
        return sb.toString();
    }

    private static final class ParentIdCollector
    extends NoopCollector {
        private final BytesRefHash parentIds;
        private final String parentType;
        private final ParentChildIndexFieldData indexFieldData;
        protected BytesValues.WithOrdinals values;
        private Ordinals.Docs ordinals;
        private FixedBitSet seenOrdinals;

        protected ParentIdCollector(String parentType, ParentChildIndexFieldData indexFieldData, BytesRefHash parentIds) {
            this.parentType = parentType;
            this.indexFieldData = indexFieldData;
            this.parentIds = parentIds;
        }

        @Override
        public void collect(int doc) throws IOException {
            int ord;
            if (this.values != null && !this.seenOrdinals.get(ord = (int)this.ordinals.getOrd(doc))) {
                BytesRef bytes = this.values.getValueByOrd(ord);
                int hash = this.values.currentValueHash();
                this.parentIds.add(bytes, hash);
                this.seenOrdinals.set(ord);
            }
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.values = ((ParentChildAtomicFieldData)this.indexFieldData.load(context)).getBytesValues(this.parentType);
            if (this.values != null) {
                this.ordinals = this.values.ordinals();
                int maxOrd = (int)this.ordinals.getMaxOrd();
                if (this.seenOrdinals == null || this.seenOrdinals.length() < maxOrd) {
                    this.seenOrdinals = new FixedBitSet(maxOrd);
                } else {
                    this.seenOrdinals.clear(0, maxOrd);
                }
            }
        }
    }

    private final class ParentWeight
    extends Weight
    implements Releasable {
        private final Filter parentFilter;
        private final Filter shortCircuitFilter;
        private final BytesRefHash parentIds;
        private long remaining;
        private float queryNorm;
        private float queryWeight;

        public ParentWeight(Filter parentFilter, Filter shortCircuitFilter, BytesRefHash parentIds) {
            this.parentFilter = new ApplyAcceptedDocsFilter(parentFilter);
            this.shortCircuitFilter = shortCircuitFilter;
            this.parentIds = parentIds;
            this.remaining = parentIds.size();
        }

        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            return new Explanation(ChildrenConstantScoreQuery.this.getBoost(), "not implemented yet...");
        }

        public Query getQuery() {
            return ChildrenConstantScoreQuery.this;
        }

        public float getValueForNormalization() throws IOException {
            this.queryWeight = ChildrenConstantScoreQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public void normalize(float norm, float topLevelBoost) {
            this.queryNorm = norm * topLevelBoost;
            this.queryWeight *= this.queryNorm;
        }

        public Scorer scorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
            if (this.remaining == 0L) {
                return null;
            }
            if (this.shortCircuitFilter != null) {
                DocIdSetIterator iterator;
                DocIdSet docIdSet = this.shortCircuitFilter.getDocIdSet(context, acceptDocs);
                if (!DocIdSets.isEmpty(docIdSet) && (iterator = docIdSet.iterator()) != null) {
                    return ConstantScorer.create(iterator, this, this.queryWeight);
                }
                return null;
            }
            DocIdSet parentDocIdSet = this.parentFilter.getDocIdSet(context, acceptDocs);
            if (!DocIdSets.isEmpty(parentDocIdSet)) {
                DocIdSetIterator innerIterator;
                BytesValues.WithOrdinals bytesValues = ((ParentChildAtomicFieldData)ChildrenConstantScoreQuery.this.parentChildIndexFieldData.load(context)).getBytesValues(ChildrenConstantScoreQuery.this.parentType);
                parentDocIdSet = BitsFilteredDocIdSet.wrap((DocIdSet)parentDocIdSet, (Bits)context.reader().getLiveDocs());
                if (bytesValues != null && (innerIterator = parentDocIdSet.iterator()) != null) {
                    ParentDocIdIterator parentDocIdIterator = new ParentDocIdIterator(innerIterator, this.parentIds, bytesValues);
                    return ConstantScorer.create((DocIdSetIterator)parentDocIdIterator, this, this.queryWeight);
                }
            }
            return null;
        }

        @Override
        public boolean release() throws ElasticsearchException {
            Releasables.release(this.parentIds);
            return true;
        }

        private final class ParentDocIdIterator
        extends FilteredDocIdSetIterator {
            private final BytesRefHash parentIds;
            private final BytesValues values;

            private ParentDocIdIterator(DocIdSetIterator innerIterator, BytesRefHash parentIds, BytesValues values) {
                super(innerIterator);
                this.parentIds = parentIds;
                this.values = values;
            }

            protected boolean match(int doc) {
                boolean match;
                if (ParentWeight.this.remaining == 0L) {
                    try {
                        this.advance(Integer.MAX_VALUE);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return false;
                }
                this.values.setDocument(doc);
                BytesRef parentId = this.values.nextValue();
                int hash = this.values.currentValueHash();
                boolean bl = match = this.parentIds.find(parentId, hash) >= 0L;
                if (match) {
                    ParentWeight.this.remaining--;
                }
                return match;
            }
        }
    }
}

