/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.cache.recycler.CacheRecycler;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.hppc.ObjectOpenHashSet;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.ConcurrentMapLong;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.internal.ParentFieldMapper;
import org.elasticsearch.index.query.TemplateQueryParser;
import org.elasticsearch.index.search.stats.StatsGroupsParseElement;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesLifecycle;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.warmer.IndicesWarmer;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchContextMissingException;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.dfs.CachedDfSource;
import org.elasticsearch.search.dfs.DfsPhase;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.fetch.FetchSearchRequest;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.search.fetch.ScrollQueryFetchSearchResult;
import org.elasticsearch.search.internal.DefaultSearchContext;
import org.elasticsearch.search.internal.InternalScrollSearchRequest;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.query.QueryPhase;
import org.elasticsearch.search.query.QueryPhaseExecutionException;
import org.elasticsearch.search.query.QuerySearchRequest;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.ScrollQuerySearchResult;
import org.elasticsearch.search.warmer.IndexWarmersMetaData;
import org.elasticsearch.threadpool.ThreadPool;

public class SearchService
extends AbstractLifecycleComponent<SearchService> {
    public static final String NORMS_LOADING_KEY = "index.norms.loading";
    private static final String DEFAUTL_KEEPALIVE_COMPONENENT_KEY = "default_keep_alive";
    public static final String DEFAUTL_KEEPALIVE_KEY = "search.default_keep_alive";
    private static final String KEEPALIVE_INTERVAL_COMPONENENT_KEY = "keep_alive_interval";
    public static final String KEEPALIVE_INTERVAL_KEY = "search.keep_alive_interval";
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final IndicesWarmer indicesWarmer;
    private final ScriptService scriptService;
    private final CacheRecycler cacheRecycler;
    private final PageCacheRecycler pageCacheRecycler;
    private final BigArrays bigArrays;
    private final DfsPhase dfsPhase;
    private final QueryPhase queryPhase;
    private final FetchPhase fetchPhase;
    private final long defaultKeepAlive;
    private final ScheduledFuture<?> keepAliveReaper;
    private final AtomicLong idGenerator = new AtomicLong();
    private final ConcurrentMapLong<SearchContext> activeContexts = ConcurrentCollections.newConcurrentMapLongWithAggressiveConcurrency();
    private final ImmutableMap<String, SearchParseElement> elementParsers;
    private static final int[] EMPTY_DOC_IDS = new int[0];

    @Inject
    public SearchService(Settings settings, ClusterService clusterService, IndicesService indicesService, IndicesLifecycle indicesLifecycle, IndicesWarmer indicesWarmer, ThreadPool threadPool, ScriptService scriptService, CacheRecycler cacheRecycler, PageCacheRecycler pageCacheRecycler, BigArrays bigArrays, DfsPhase dfsPhase, QueryPhase queryPhase, FetchPhase fetchPhase) {
        super(settings);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.indicesWarmer = indicesWarmer;
        this.scriptService = scriptService;
        this.cacheRecycler = cacheRecycler;
        this.pageCacheRecycler = pageCacheRecycler;
        this.bigArrays = bigArrays;
        this.dfsPhase = dfsPhase;
        this.queryPhase = queryPhase;
        this.fetchPhase = fetchPhase;
        TimeValue keepAliveInterval = this.componentSettings.getAsTime(KEEPALIVE_INTERVAL_COMPONENENT_KEY, TimeValue.timeValueMinutes(1L));
        this.defaultKeepAlive = this.componentSettings.getAsTime(DEFAUTL_KEEPALIVE_COMPONENENT_KEY, TimeValue.timeValueMinutes(5L)).millis();
        HashMap<String, ? extends SearchParseElement> elementParsers = new HashMap<String, SearchParseElement>();
        elementParsers.putAll(dfsPhase.parseElements());
        elementParsers.putAll(queryPhase.parseElements());
        elementParsers.putAll(fetchPhase.parseElements());
        elementParsers.put("stats", new StatsGroupsParseElement());
        this.elementParsers = ImmutableMap.copyOf(elementParsers);
        this.keepAliveReaper = threadPool.scheduleWithFixedDelay(new Reaper(), keepAliveInterval);
        this.indicesWarmer.addListener(new NormsWarmer());
        this.indicesWarmer.addListener(new FieldDataWarmer());
        this.indicesWarmer.addListener(new SearchWarmer());
    }

    @Override
    protected void doStart() throws ElasticsearchException {
    }

    @Override
    protected void doStop() throws ElasticsearchException {
        for (SearchContext context : this.activeContexts.values()) {
            this.freeContext(context);
        }
        this.activeContexts.clear();
    }

    @Override
    protected void doClose() throws ElasticsearchException {
        this.keepAliveReaper.cancel(false);
    }

    public DfsSearchResult executeDfsPhase(ShardSearchRequest request) throws ElasticsearchException {
        SearchContext context = this.createAndPutContext(request);
        try {
            this.contextProcessing(context);
            this.dfsPhase.execute(context);
            this.contextProcessedSuccessfully(context);
            DfsSearchResult dfsSearchResult = context.dfsResult();
            return dfsSearchResult;
        }
        catch (Throwable e) {
            this.logger.trace("Dfs phase failed", e, new Object[0]);
            this.freeContext(context);
            throw ExceptionsHelper.convertToRuntime(e);
        }
        finally {
            this.cleanContext(context);
        }
    }

    public QuerySearchResult executeScan(ShardSearchRequest request) throws ElasticsearchException {
        SearchContext context = this.createAndPutContext(request);
        assert (context.searchType() == SearchType.SCAN);
        context.searchType(SearchType.COUNT);
        assert (context.searchType() == SearchType.COUNT);
        try {
            if (context.scroll() == null) {
                throw new ElasticsearchException("Scroll must be provided when scanning...");
            }
            this.contextProcessing(context);
            this.queryPhase.execute(context);
            this.contextProcessedSuccessfully(context);
            QuerySearchResult querySearchResult = context.queryResult();
            return querySearchResult;
        }
        catch (Throwable e) {
            this.logger.trace("Scan phase failed", e, new Object[0]);
            this.freeContext(context);
            throw ExceptionsHelper.convertToRuntime(e);
        }
        finally {
            this.cleanContext(context);
        }
    }

    public ScrollQueryFetchSearchResult executeScan(InternalScrollSearchRequest request) throws ElasticsearchException {
        SearchContext context = this.findContext(request.id());
        this.contextProcessing(context);
        try {
            this.processScroll(request, context);
            if (context.searchType() == SearchType.COUNT) {
                context.searchType(SearchType.SCAN);
                context.from(0);
            }
            this.queryPhase.execute(context);
            this.shortcutDocIdsToLoadForScanning(context);
            this.fetchPhase.execute(context);
            if (context.scroll() == null || context.fetchResult().hits().hits().length < context.size()) {
                this.freeContext(request.id());
            } else {
                this.contextProcessedSuccessfully(context);
            }
            ScrollQueryFetchSearchResult scrollQueryFetchSearchResult = new ScrollQueryFetchSearchResult(new QueryFetchSearchResult(context.queryResult(), context.fetchResult()), context.shardTarget());
            return scrollQueryFetchSearchResult;
        }
        catch (Throwable e) {
            this.logger.trace("Scan phase failed", e, new Object[0]);
            this.freeContext(context);
            throw ExceptionsHelper.convertToRuntime(e);
        }
        finally {
            this.cleanContext(context);
        }
    }

    public QuerySearchResult executeQueryPhase(ShardSearchRequest request) throws ElasticsearchException {
        SearchContext context = this.createAndPutContext(request);
        try {
            context.indexShard().searchService().onPreQueryPhase(context);
            long time = System.nanoTime();
            this.contextProcessing(context);
            this.queryPhase.execute(context);
            if (context.searchType() == SearchType.COUNT) {
                this.freeContext(context.id());
            } else {
                this.contextProcessedSuccessfully(context);
            }
            context.indexShard().searchService().onQueryPhase(context, System.nanoTime() - time);
            QuerySearchResult querySearchResult = context.queryResult();
            return querySearchResult;
        }
        catch (Throwable e) {
            context.indexShard().searchService().onFailedQueryPhase(context);
            this.logger.trace("Query phase failed", e, new Object[0]);
            this.freeContext(context);
            throw ExceptionsHelper.convertToRuntime(e);
        }
        finally {
            this.cleanContext(context);
        }
    }

    public ScrollQuerySearchResult executeQueryPhase(InternalScrollSearchRequest request) throws ElasticsearchException {
        SearchContext context = this.findContext(request.id());
        try {
            context.indexShard().searchService().onPreQueryPhase(context);
            long time = System.nanoTime();
            this.contextProcessing(context);
            this.processScroll(request, context);
            this.queryPhase.execute(context);
            this.contextProcessedSuccessfully(context);
            context.indexShard().searchService().onQueryPhase(context, System.nanoTime() - time);
            ScrollQuerySearchResult scrollQuerySearchResult = new ScrollQuerySearchResult(context.queryResult(), context.shardTarget());
            return scrollQuerySearchResult;
        }
        catch (Throwable e) {
            context.indexShard().searchService().onFailedQueryPhase(context);
            this.logger.trace("Query phase failed", e, new Object[0]);
            this.freeContext(context);
            throw ExceptionsHelper.convertToRuntime(e);
        }
        finally {
            this.cleanContext(context);
        }
    }

    public QuerySearchResult executeQueryPhase(QuerySearchRequest request) throws ElasticsearchException {
        SearchContext context = this.findContext(request.id());
        this.contextProcessing(context);
        try {
            context.searcher().dfSource(new CachedDfSource(context.searcher().getIndexReader(), request.dfs(), context.similarityService().similarity()));
        }
        catch (Throwable e) {
            this.freeContext(context);
            this.cleanContext(context);
            throw new QueryPhaseExecutionException(context, "Failed to set aggregated df", e);
        }
        try {
            context.indexShard().searchService().onPreQueryPhase(context);
            long time = System.nanoTime();
            this.queryPhase.execute(context);
            this.contextProcessedSuccessfully(context);
            context.indexShard().searchService().onQueryPhase(context, System.nanoTime() - time);
            QuerySearchResult querySearchResult = context.queryResult();
            return querySearchResult;
        }
        catch (Throwable e) {
            context.indexShard().searchService().onFailedQueryPhase(context);
            this.logger.trace("Query phase failed", e, new Object[0]);
            this.freeContext(context);
            throw ExceptionsHelper.convertToRuntime(e);
        }
        finally {
            this.cleanContext(context);
        }
    }

    public QueryFetchSearchResult executeFetchPhase(ShardSearchRequest request) throws ElasticsearchException {
        SearchContext context = this.createAndPutContext(request);
        this.contextProcessing(context);
        try {
            context.indexShard().searchService().onPreQueryPhase(context);
            long time = System.nanoTime();
            try {
                this.queryPhase.execute(context);
            }
            catch (Throwable e) {
                context.indexShard().searchService().onFailedQueryPhase(context);
                throw ExceptionsHelper.convertToRuntime(e);
            }
            long time2 = System.nanoTime();
            context.indexShard().searchService().onQueryPhase(context, time2 - time);
            context.indexShard().searchService().onPreFetchPhase(context);
            try {
                this.shortcutDocIdsToLoad(context);
                this.fetchPhase.execute(context);
                if (context.scroll() == null) {
                    this.freeContext(context.id());
                } else {
                    this.contextProcessedSuccessfully(context);
                }
            }
            catch (Throwable e) {
                context.indexShard().searchService().onFailedFetchPhase(context);
                throw ExceptionsHelper.convertToRuntime(e);
            }
            context.indexShard().searchService().onFetchPhase(context, System.nanoTime() - time2);
            QueryFetchSearchResult queryFetchSearchResult = new QueryFetchSearchResult(context.queryResult(), context.fetchResult());
            return queryFetchSearchResult;
        }
        catch (Throwable e) {
            this.logger.trace("Fetch phase failed", e, new Object[0]);
            this.freeContext(context);
            throw ExceptionsHelper.convertToRuntime(e);
        }
        finally {
            this.cleanContext(context);
        }
    }

    public QueryFetchSearchResult executeFetchPhase(QuerySearchRequest request) throws ElasticsearchException {
        SearchContext context = this.findContext(request.id());
        this.contextProcessing(context);
        try {
            context.searcher().dfSource(new CachedDfSource(context.searcher().getIndexReader(), request.dfs(), context.similarityService().similarity()));
        }
        catch (Throwable e) {
            this.freeContext(context);
            this.cleanContext(context);
            throw new QueryPhaseExecutionException(context, "Failed to set aggregated df", e);
        }
        try {
            context.indexShard().searchService().onPreQueryPhase(context);
            long time = System.nanoTime();
            try {
                this.queryPhase.execute(context);
            }
            catch (Throwable e) {
                context.indexShard().searchService().onFailedQueryPhase(context);
                throw ExceptionsHelper.convertToRuntime(e);
            }
            long time2 = System.nanoTime();
            context.indexShard().searchService().onQueryPhase(context, time2 - time);
            context.indexShard().searchService().onPreFetchPhase(context);
            try {
                this.shortcutDocIdsToLoad(context);
                this.fetchPhase.execute(context);
                if (context.scroll() == null) {
                    this.freeContext(request.id());
                } else {
                    this.contextProcessedSuccessfully(context);
                }
            }
            catch (Throwable e) {
                context.indexShard().searchService().onFailedFetchPhase(context);
                throw ExceptionsHelper.convertToRuntime(e);
            }
            context.indexShard().searchService().onFetchPhase(context, System.nanoTime() - time2);
            QueryFetchSearchResult queryFetchSearchResult = new QueryFetchSearchResult(context.queryResult(), context.fetchResult());
            return queryFetchSearchResult;
        }
        catch (Throwable e) {
            this.logger.trace("Fetch phase failed", e, new Object[0]);
            this.freeContext(context);
            throw ExceptionsHelper.convertToRuntime(e);
        }
        finally {
            this.cleanContext(context);
        }
    }

    public ScrollQueryFetchSearchResult executeFetchPhase(InternalScrollSearchRequest request) throws ElasticsearchException {
        SearchContext context = this.findContext(request.id());
        this.contextProcessing(context);
        try {
            this.processScroll(request, context);
            context.indexShard().searchService().onPreQueryPhase(context);
            long time = System.nanoTime();
            try {
                this.queryPhase.execute(context);
            }
            catch (Throwable e) {
                context.indexShard().searchService().onFailedQueryPhase(context);
                throw ExceptionsHelper.convertToRuntime(e);
            }
            long time2 = System.nanoTime();
            context.indexShard().searchService().onQueryPhase(context, time2 - time);
            context.indexShard().searchService().onPreFetchPhase(context);
            try {
                this.shortcutDocIdsToLoad(context);
                this.fetchPhase.execute(context);
                if (context.scroll() == null) {
                    this.freeContext(request.id());
                } else {
                    this.contextProcessedSuccessfully(context);
                }
            }
            catch (Throwable e) {
                context.indexShard().searchService().onFailedFetchPhase(context);
                throw ExceptionsHelper.convertToRuntime(e);
            }
            context.indexShard().searchService().onFetchPhase(context, System.nanoTime() - time2);
            ScrollQueryFetchSearchResult scrollQueryFetchSearchResult = new ScrollQueryFetchSearchResult(new QueryFetchSearchResult(context.queryResult(), context.fetchResult()), context.shardTarget());
            return scrollQueryFetchSearchResult;
        }
        catch (Throwable e) {
            this.logger.trace("Fetch phase failed", e, new Object[0]);
            this.freeContext(context);
            throw ExceptionsHelper.convertToRuntime(e);
        }
        finally {
            this.cleanContext(context);
        }
    }

    public FetchSearchResult executeFetchPhase(FetchSearchRequest request) throws ElasticsearchException {
        SearchContext context = this.findContext(request.id());
        this.contextProcessing(context);
        try {
            context.docIdsToLoad(request.docIds(), 0, request.docIdsSize());
            context.indexShard().searchService().onPreFetchPhase(context);
            long time = System.nanoTime();
            this.fetchPhase.execute(context);
            if (context.scroll() == null) {
                this.freeContext(request.id());
            } else {
                this.contextProcessedSuccessfully(context);
            }
            context.indexShard().searchService().onFetchPhase(context, System.nanoTime() - time);
            FetchSearchResult fetchSearchResult = context.fetchResult();
            return fetchSearchResult;
        }
        catch (Throwable e) {
            context.indexShard().searchService().onFailedFetchPhase(context);
            this.logger.trace("Fetch phase failed", e, new Object[0]);
            this.freeContext(context);
            throw ExceptionsHelper.convertToRuntime(e);
        }
        finally {
            this.cleanContext(context);
        }
    }

    private SearchContext findContext(long id) throws SearchContextMissingException {
        SearchContext context = this.activeContexts.get(id);
        if (context == null) {
            throw new SearchContextMissingException(id);
        }
        SearchContext.setCurrent(context);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final SearchContext createAndPutContext(ShardSearchRequest request) throws ElasticsearchException {
        SearchContext context = this.createContext(request, null);
        boolean success = false;
        try {
            this.activeContexts.put(context.id(), context);
            context.indexShard().searchService().onNewContext(context);
            success = true;
            SearchContext searchContext = context;
            return searchContext;
        }
        finally {
            if (!success) {
                this.freeContext(context);
            }
        }
    }

    final SearchContext createContext(ShardSearchRequest request, @Nullable Engine.Searcher searcher) throws ElasticsearchException {
        IndexService indexService = this.indicesService.indexServiceSafe(request.index());
        IndexShard indexShard = indexService.shardSafe(request.shardId());
        SearchShardTarget shardTarget = new SearchShardTarget(this.clusterService.localNode().id(), request.index(), request.shardId());
        Engine.Searcher engineSearcher = searcher == null ? indexShard.acquireSearcher("search") : searcher;
        DefaultSearchContext context = new DefaultSearchContext(this.idGenerator.incrementAndGet(), request, shardTarget, engineSearcher, indexService, indexShard, this.scriptService, this.cacheRecycler, this.pageCacheRecycler, this.bigArrays);
        SearchContext.setCurrent(context);
        try {
            ((SearchContext)context).scroll(request.scroll());
            this.parseTemplate(request);
            this.parseSource(context, request.source());
            this.parseSource(context, request.extraSource());
            if (((SearchContext)context).from() == -1) {
                ((SearchContext)context).from(0);
            }
            if (((SearchContext)context).size() == -1) {
                ((SearchContext)context).size(10);
            }
            this.dfsPhase.preProcess(context);
            this.queryPhase.preProcess(context);
            this.fetchPhase.preProcess(context);
            long keepAlive = this.defaultKeepAlive;
            if (request.scroll() != null && request.scroll().keepAlive() != null) {
                keepAlive = request.scroll().keepAlive().millis();
            }
            ((SearchContext)context).keepAlive(keepAlive);
        }
        catch (Throwable e) {
            context.release();
            throw ExceptionsHelper.convertToRuntime(e);
        }
        return context;
    }

    public void freeContext(long id) {
        SearchContext context = this.activeContexts.remove(id);
        if (context == null) {
            return;
        }
        context.indexShard().searchService().onFreeContext(context);
        context.release();
    }

    private void freeContext(SearchContext context) {
        SearchContext removed = this.activeContexts.remove(context.id());
        if (removed != null) {
            removed.indexShard().searchService().onFreeContext(removed);
        }
        context.release();
    }

    public void freeAllScrollContexts() {
        for (SearchContext searchContext : this.activeContexts.values()) {
            if (searchContext.scroll() == null) continue;
            this.freeContext(searchContext);
        }
    }

    private void contextProcessing(SearchContext context) {
        context.accessed(-1L);
    }

    private void contextProcessedSuccessfully(SearchContext context) {
        context.accessed(this.threadPool.estimatedTimeInMillis());
    }

    private void cleanContext(SearchContext context) {
        SearchContext.removeCurrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseTemplate(ShardSearchRequest request) {
        if (Strings.hasLength(request.templateName())) {
            ExecutableScript executable = this.scriptService.executable("mustache", request.templateName(), request.templateParams());
            BytesReference processedQuery = (BytesReference)executable.run();
            request.source(processedQuery);
            return;
        }
        if (request.templateSource() == null) return;
        if (request.templateSource().length() == 0) {
            return;
        }
        XContentParser parser = null;
        try {
            parser = XContentFactory.xContent(request.templateSource()).createParser(request.templateSource());
            TemplateQueryParser.TemplateContext templateContext = TemplateQueryParser.parse(parser, "template", "params");
            if (!Strings.hasLength(templateContext.template())) {
                throw new ElasticsearchParseException("Template must have [template] field configured");
            }
            ExecutableScript executable = this.scriptService.executable("mustache", templateContext.template(), templateContext.params());
            BytesReference processedQuery = (BytesReference)executable.run();
            request.source(processedQuery);
        }
        catch (IOException e) {
            try {
                this.logger.error("Error trying to parse template: ", e, new Object[0]);
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{parser});
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{parser});
            return;
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{parser});
        return;
    }

    private void parseSource(SearchContext context, BytesReference source) throws SearchParseException {
        if (source == null || source.length() == 0) {
            return;
        }
        XContentParser parser = null;
        try {
            XContentParser.Token token;
            parser = XContentFactory.xContent(source).createParser(source);
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    String fieldName = parser.currentName();
                    parser.nextToken();
                    SearchParseElement element = this.elementParsers.get(fieldName);
                    if (element == null) {
                        throw new SearchParseException(context, "No parser for element [" + fieldName + "]");
                    }
                    element.parse(parser, context);
                    continue;
                }
                if (token != null) continue;
                break;
            }
        }
        catch (Throwable e) {
            String sSource = "_na_";
            try {
                sSource = XContentHelper.convertToJson(source, false);
            }
            catch (Throwable e1) {
                // empty catch block
            }
            throw new SearchParseException(context, "Failed to parse source [" + sSource + "]", e);
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    private void shortcutDocIdsToLoad(SearchContext context) {
        TopDocs topDocs = context.queryResult().topDocs();
        if (topDocs.scoreDocs.length < context.from()) {
            context.docIdsToLoad(EMPTY_DOC_IDS, 0, 0);
            return;
        }
        int totalSize = context.from() + context.size();
        int[] docIdsToLoad = new int[Math.min(topDocs.scoreDocs.length - context.from(), context.size())];
        int counter = 0;
        for (int i = context.from(); i < totalSize && i < topDocs.scoreDocs.length; ++i) {
            docIdsToLoad[counter] = topDocs.scoreDocs[i].doc;
            ++counter;
        }
        context.docIdsToLoad(docIdsToLoad, 0, counter);
    }

    private void shortcutDocIdsToLoadForScanning(SearchContext context) {
        TopDocs topDocs = context.queryResult().topDocs();
        if (topDocs.scoreDocs.length == 0) {
            context.docIdsToLoad(EMPTY_DOC_IDS, 0, 0);
            return;
        }
        int[] docIdsToLoad = new int[topDocs.scoreDocs.length];
        for (int i = 0; i < docIdsToLoad.length; ++i) {
            docIdsToLoad[i] = topDocs.scoreDocs[i].doc;
        }
        context.docIdsToLoad(docIdsToLoad, 0, docIdsToLoad.length);
    }

    private void processScroll(InternalScrollSearchRequest request, SearchContext context) {
        context.from(context.from() + context.size());
        context.scroll(request.scroll());
        if (request.scroll() != null && request.scroll().keepAlive() != null) {
            context.keepAlive(request.scroll().keepAlive().millis());
        }
    }

    class Reaper
    implements Runnable {
        Reaper() {
        }

        @Override
        public void run() {
            long time = SearchService.this.threadPool.estimatedTimeInMillis();
            for (SearchContext context : SearchService.this.activeContexts.values()) {
                long lastAccessTime = context.lastAccessTime();
                if (lastAccessTime == -1L || time - lastAccessTime <= context.keepAlive()) continue;
                SearchService.this.logger.debug("freeing search context [{}], time [{}], lastAccessTime [{}], keepAlive [{}]", context.id(), time, lastAccessTime, context.keepAlive());
                SearchService.this.freeContext(context);
            }
        }
    }

    class SearchWarmer
    extends IndicesWarmer.Listener {
        SearchWarmer() {
        }

        @Override
        public IndicesWarmer.Listener.TerminationHandle warm(final IndexShard indexShard, final IndexMetaData indexMetaData, final IndicesWarmer.WarmerContext warmerContext, ThreadPool threadPool) {
            IndexWarmersMetaData custom = (IndexWarmersMetaData)indexMetaData.custom("warmers");
            if (custom == null) {
                return IndicesWarmer.Listener.TerminationHandle.NO_WAIT;
            }
            Executor executor = threadPool.executor(this.executor());
            final CountDownLatch latch = new CountDownLatch(custom.entries().size());
            for (final IndexWarmersMetaData.Entry entry : custom.entries()) {
                executor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        SearchContext context = null;
                        try {
                            long now = System.nanoTime();
                            ShardSearchRequest request = new ShardSearchRequest(indexShard.shardId().index().name(), indexShard.shardId().id(), indexMetaData.numberOfShards(), SearchType.QUERY_THEN_FETCH).source(entry.source()).types(entry.types());
                            context = SearchService.this.createContext(request, warmerContext.newSearcher());
                            SearchService.this.queryPhase.execute(context);
                            long took = System.nanoTime() - now;
                            if (indexShard.warmerService().logger().isTraceEnabled()) {
                                indexShard.warmerService().logger().trace("warmed [{}], took [{}]", entry.name(), TimeValue.timeValueNanos(took));
                            }
                        }
                        catch (Throwable t) {
                            try {
                                indexShard.warmerService().logger().warn("warmer [{}] failed", t, entry.name());
                                return;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                try {
                                    if (context != null) {
                                        SearchService.this.freeContext(context);
                                        SearchService.this.cleanContext(context);
                                    }
                                }
                                finally {
                                    latch.countDown();
                                }
                            }
                        }
                        try {
                            if (context == null) return;
                            SearchService.this.freeContext(context);
                            SearchService.this.cleanContext(context);
                            return;
                        }
                        finally {
                            latch.countDown();
                        }
                    }
                });
            }
            return new IndicesWarmer.Listener.TerminationHandle(){

                @Override
                public void awaitTermination() throws InterruptedException {
                    latch.await();
                }
            };
        }
    }

    static class FieldDataWarmer
    extends IndicesWarmer.Listener {
        FieldDataWarmer() {
        }

        @Override
        public IndicesWarmer.Listener.TerminationHandle warm(final IndexShard indexShard, IndexMetaData indexMetaData, IndicesWarmer.WarmerContext context, ThreadPool threadPool) {
            MapperService mapperService = indexShard.mapperService();
            HashMap<String, FieldMapper> warmUp = new HashMap<String, FieldMapper>();
            for (DocumentMapper docMapper : mapperService) {
                for (FieldMapper fieldMapper : docMapper.mappers().mappers()) {
                    FieldDataType fieldDataType = fieldMapper.fieldDataType();
                    if (fieldDataType == null) continue;
                    String indexName = fieldMapper.names().indexName();
                    if (fieldMapper instanceof ParentFieldMapper) {
                        ParentFieldMapper parentFieldMapper = (ParentFieldMapper)fieldMapper;
                        if (!parentFieldMapper.active()) continue;
                        warmUp.put(indexName, parentFieldMapper);
                        continue;
                    }
                    if (fieldDataType.getLoading() == FieldMapper.Loading.EAGER || !warmUp.containsKey(indexName)) continue;
                    warmUp.put(indexName, fieldMapper);
                }
            }
            final IndexFieldDataService indexFieldDataService = indexShard.indexFieldDataService();
            Executor executor = threadPool.executor(this.executor());
            final CountDownLatch latch = new CountDownLatch(context.newSearcher().reader().leaves().size() * warmUp.size());
            for (final AtomicReaderContext ctx : context.newSearcher().reader().leaves()) {
                for (final FieldMapper fieldMapper : warmUp.values()) {
                    executor.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                long start = System.nanoTime();
                                indexFieldDataService.getForField(fieldMapper).load(ctx);
                                if (indexShard.warmerService().logger().isTraceEnabled()) {
                                    indexShard.warmerService().logger().trace("warmed fielddata for [{}], took [{}]", fieldMapper.names().name(), TimeValue.timeValueNanos(System.nanoTime() - start));
                                }
                            }
                            catch (Throwable t) {
                                indexShard.warmerService().logger().warn("failed to warm-up fielddata for [{}]", t, fieldMapper.names().name());
                            }
                            finally {
                                latch.countDown();
                            }
                        }
                    });
                }
            }
            return new IndicesWarmer.Listener.TerminationHandle(){

                @Override
                public void awaitTermination() throws InterruptedException {
                    latch.await();
                }
            };
        }
    }

    static class NormsWarmer
    extends IndicesWarmer.Listener {
        NormsWarmer() {
        }

        @Override
        public IndicesWarmer.Listener.TerminationHandle warm(final IndexShard indexShard, IndexMetaData indexMetaData, final IndicesWarmer.WarmerContext context, ThreadPool threadPool) {
            FieldMapper.Loading defaultLoading = FieldMapper.Loading.parse(indexMetaData.settings().get(SearchService.NORMS_LOADING_KEY), FieldMapper.Loading.LAZY);
            MapperService mapperService = indexShard.mapperService();
            final ObjectOpenHashSet<String> warmUp = new ObjectOpenHashSet<String>();
            for (DocumentMapper docMapper : mapperService) {
                for (FieldMapper fieldMapper : docMapper.mappers().mappers()) {
                    String indexName = fieldMapper.names().indexName();
                    if (!fieldMapper.fieldType().indexed() || fieldMapper.fieldType().omitNorms() || fieldMapper.normsLoading(defaultLoading) != FieldMapper.Loading.EAGER) continue;
                    warmUp.add(indexName);
                }
            }
            final CountDownLatch latch = new CountDownLatch(1);
            threadPool.executor(this.executor()).execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Iterator it = warmUp.iterator();
                        while (it.hasNext()) {
                            String indexName = (String)it.next().value;
                            long start = System.nanoTime();
                            for (AtomicReaderContext ctx : context.newSearcher().reader().leaves()) {
                                NumericDocValues values = ctx.reader().getNormValues(indexName);
                                if (values == null) continue;
                                values.get(0);
                            }
                            if (!indexShard.warmerService().logger().isTraceEnabled()) continue;
                            indexShard.warmerService().logger().trace("warmed norms for [{}], took [{}]", indexName, TimeValue.timeValueNanos(System.nanoTime() - start));
                        }
                    }
                    catch (Throwable t) {
                        indexShard.warmerService().logger().warn("failed to warm-up norms", t, new Object[0]);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
            return new IndicesWarmer.Listener.TerminationHandle(){

                @Override
                public void awaitTermination() throws InterruptedException {
                    latch.await();
                }
            };
        }
    }
}

