/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.mapping.get;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsResponse;
import org.elasticsearch.action.admin.indices.mapping.get.TransportGetFieldMappingsIndexAction;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportService;

public class TransportGetFieldMappingsAction
extends TransportAction<GetFieldMappingsRequest, GetFieldMappingsResponse> {
    private final ClusterService clusterService;
    private final TransportGetFieldMappingsIndexAction shardAction;
    private final String transportAction;

    @Inject
    public TransportGetFieldMappingsAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, TransportGetFieldMappingsIndexAction shardAction) {
        super(settings, threadPool);
        this.clusterService = clusterService;
        this.shardAction = shardAction;
        this.transportAction = "mappings/fields/get";
        transportService.registerHandler(this.transportAction, new TransportHandler());
    }

    @Override
    protected void doExecute(GetFieldMappingsRequest request, final ActionListener<GetFieldMappingsResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        String[] concreteIndices = clusterState.metaData().concreteIndices(request.indicesOptions(), request.indices());
        final AtomicInteger indexCounter = new AtomicInteger();
        final AtomicInteger completionCounter = new AtomicInteger(concreteIndices.length);
        final AtomicReferenceArray indexResponses = new AtomicReferenceArray(concreteIndices.length);
        if (concreteIndices == null || concreteIndices.length == 0) {
            listener.onResponse(new GetFieldMappingsResponse());
        } else {
            boolean probablySingleFieldRequest = concreteIndices.length == 1 && request.types().length == 1 && request.fields().length == 1;
            for (String index : concreteIndices) {
                GetFieldMappingsIndexRequest shardRequest = new GetFieldMappingsIndexRequest(request, index, probablySingleFieldRequest);
                shardRequest.listenerThreaded(false);
                this.shardAction.execute(shardRequest, new ActionListener<GetFieldMappingsResponse>(){

                    @Override
                    public void onResponse(GetFieldMappingsResponse result) {
                        indexResponses.set(indexCounter.getAndIncrement(), result);
                        if (completionCounter.decrementAndGet() == 0) {
                            listener.onResponse(TransportGetFieldMappingsAction.this.merge(indexResponses));
                        }
                    }

                    @Override
                    public void onFailure(Throwable e) {
                        int index = indexCounter.getAndIncrement();
                        indexResponses.set(index, e);
                        if (completionCounter.decrementAndGet() == 0) {
                            listener.onResponse(TransportGetFieldMappingsAction.this.merge(indexResponses));
                        }
                    }
                });
            }
        }
    }

    private GetFieldMappingsResponse merge(AtomicReferenceArray<Object> indexResponses) {
        MapBuilder<String, ImmutableMap<String, ImmutableMap<String, GetFieldMappingsResponse.FieldMappingMetaData>>> mergedResponses = MapBuilder.newMapBuilder();
        for (int i = 0; i < indexResponses.length(); ++i) {
            Object element = indexResponses.get(i);
            if (!(element instanceof GetFieldMappingsResponse)) continue;
            GetFieldMappingsResponse response = (GetFieldMappingsResponse)element;
            mergedResponses.putAll(response.mappings());
        }
        return new GetFieldMappingsResponse(mergedResponses.immutableMap());
    }

    private class TransportHandler
    extends BaseTransportRequestHandler<GetFieldMappingsRequest> {
        private TransportHandler() {
        }

        @Override
        public GetFieldMappingsRequest newInstance() {
            return new GetFieldMappingsRequest();
        }

        @Override
        public String executor() {
            return "same";
        }

        @Override
        public void messageReceived(final GetFieldMappingsRequest request, final TransportChannel channel) throws Exception {
            request.listenerThreaded(false);
            TransportGetFieldMappingsAction.this.execute(request, new ActionListener<GetFieldMappingsResponse>(){

                @Override
                public void onResponse(GetFieldMappingsResponse result) {
                    try {
                        channel.sendResponse(result);
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportGetFieldMappingsAction.this.logger.warn("Failed to send error response for action [" + TransportGetFieldMappingsAction.this.transportAction + "] and request [" + request + "]", e1, new Object[0]);
                    }
                }
            });
        }
    }
}

