/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.status;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.admin.indices.status.DocsStatus;
import org.elasticsearch.action.admin.indices.status.GatewayRecoveryStatus;
import org.elasticsearch.action.admin.indices.status.IndicesStatusRequest;
import org.elasticsearch.action.admin.indices.status.IndicesStatusResponse;
import org.elasticsearch.action.admin.indices.status.PeerRecoveryStatus;
import org.elasticsearch.action.admin.indices.status.ShardStatus;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationRequest;
import org.elasticsearch.action.support.broadcast.TransportBroadcastOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.gateway.IndexShardGatewayService;
import org.elasticsearch.index.service.InternalIndexService;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.service.InternalIndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.indices.recovery.RecoveryStatus;
import org.elasticsearch.indices.recovery.RecoveryTarget;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

@Deprecated
public class TransportIndicesStatusAction
extends TransportBroadcastOperationAction<IndicesStatusRequest, IndicesStatusResponse, IndexShardStatusRequest, ShardStatus> {
    private final IndicesService indicesService;
    private final RecoveryTarget peerRecoveryTarget;

    @Inject
    public TransportIndicesStatusAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService, RecoveryTarget peerRecoveryTarget) {
        super(settings, threadPool, clusterService, transportService);
        this.peerRecoveryTarget = peerRecoveryTarget;
        this.indicesService = indicesService;
    }

    @Override
    protected String executor() {
        return "management";
    }

    @Override
    protected String transportAction() {
        return "indices/status";
    }

    @Override
    protected IndicesStatusRequest newRequest() {
        return new IndicesStatusRequest();
    }

    @Override
    protected GroupShardsIterator shards(ClusterState state, IndicesStatusRequest request, String[] concreteIndices) {
        return state.routingTable().allAssignedShardsGrouped(concreteIndices, true);
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, IndicesStatusRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, IndicesStatusRequest countRequest, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA, concreteIndices);
    }

    @Override
    protected IndicesStatusResponse newResponse(IndicesStatusRequest request, AtomicReferenceArray shardsResponses, ClusterState clusterState) {
        int successfulShards = 0;
        int failedShards = 0;
        ArrayList<ShardOperationFailedException> shardFailures = null;
        ArrayList<ShardStatus> shards = Lists.newArrayList();
        for (int i = 0; i < shardsResponses.length(); ++i) {
            Object shardResponse = shardsResponses.get(i);
            if (shardResponse == null) continue;
            if (shardResponse instanceof BroadcastShardOperationFailedException) {
                ++failedShards;
                if (shardFailures == null) {
                    shardFailures = Lists.newArrayList();
                }
                shardFailures.add(new DefaultShardOperationFailedException((BroadcastShardOperationFailedException)shardResponse));
                continue;
            }
            shards.add((ShardStatus)shardResponse);
            ++successfulShards;
        }
        return new IndicesStatusResponse(shards.toArray(new ShardStatus[shards.size()]), clusterState, shardsResponses.length(), successfulShards, failedShards, shardFailures);
    }

    @Override
    protected IndexShardStatusRequest newShardRequest() {
        return new IndexShardStatusRequest();
    }

    @Override
    protected IndexShardStatusRequest newShardRequest(ShardRouting shard, IndicesStatusRequest request) {
        return new IndexShardStatusRequest(shard.index(), shard.id(), request);
    }

    @Override
    protected ShardStatus newShardResponse() {
        return new ShardStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ShardStatus shardOperation(IndexShardStatusRequest request) throws ElasticsearchException {
        InternalIndexService indexService = (InternalIndexService)this.indicesService.indexServiceSafe(request.index());
        InternalIndexShard indexShard = (InternalIndexShard)indexService.shardSafe(request.shardId());
        ShardStatus shardStatus = new ShardStatus(indexShard.routingEntry());
        shardStatus.state = indexShard.state();
        try {
            shardStatus.storeSize = indexShard.store().estimateSize();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (indexShard.state() == IndexShardState.STARTED) {
            shardStatus.translogId = indexShard.translog().currentId();
            shardStatus.translogOperations = indexShard.translog().estimatedNumberOfOperations();
            try (Engine.Searcher searcher = indexShard.acquireSearcher("indices_status");){
                shardStatus.docs = new DocsStatus();
                shardStatus.docs.numDocs = searcher.reader().numDocs();
                shardStatus.docs.maxDoc = searcher.reader().maxDoc();
                shardStatus.docs.deletedDocs = searcher.reader().numDeletedDocs();
            }
            shardStatus.mergeStats = indexShard.mergeScheduler().stats();
            shardStatus.refreshStats = indexShard.refreshStats();
            shardStatus.flushStats = indexShard.flushStats();
        }
        if (request.recovery) {
            IndexShardGatewayService gatewayService;
            RecoveryState gatewayRecoveryState;
            RecoveryStatus peerRecoveryStatus = indexShard.recoveryStatus();
            if (peerRecoveryStatus == null) {
                peerRecoveryStatus = this.peerRecoveryTarget.recoveryStatus(indexShard.shardId());
            }
            if (peerRecoveryStatus != null) {
                PeerRecoveryStatus.Stage stage;
                switch (peerRecoveryStatus.stage()) {
                    case INIT: {
                        stage = PeerRecoveryStatus.Stage.INIT;
                        break;
                    }
                    case INDEX: {
                        stage = PeerRecoveryStatus.Stage.INDEX;
                        break;
                    }
                    case TRANSLOG: {
                        stage = PeerRecoveryStatus.Stage.TRANSLOG;
                        break;
                    }
                    case FINALIZE: {
                        stage = PeerRecoveryStatus.Stage.FINALIZE;
                        break;
                    }
                    case DONE: {
                        stage = PeerRecoveryStatus.Stage.DONE;
                        break;
                    }
                    default: {
                        stage = PeerRecoveryStatus.Stage.INIT;
                    }
                }
                shardStatus.peerRecoveryStatus = new PeerRecoveryStatus(stage, peerRecoveryStatus.recoveryState().getTimer().startTime(), peerRecoveryStatus.recoveryState().getTimer().time(), peerRecoveryStatus.recoveryState().getIndex().totalByteCount(), peerRecoveryStatus.recoveryState().getIndex().reusedByteCount(), peerRecoveryStatus.recoveryState().getIndex().recoveredByteCount(), peerRecoveryStatus.recoveryState().getTranslog().currentTranslogOperations());
            }
            if ((gatewayRecoveryState = (gatewayService = indexService.shardInjector(request.shardId()).getInstance(IndexShardGatewayService.class)).recoveryState()) != null) {
                GatewayRecoveryStatus.Stage stage;
                switch (gatewayRecoveryState.getStage()) {
                    case INIT: {
                        stage = GatewayRecoveryStatus.Stage.INIT;
                        break;
                    }
                    case INDEX: {
                        stage = GatewayRecoveryStatus.Stage.INDEX;
                        break;
                    }
                    case TRANSLOG: {
                        stage = GatewayRecoveryStatus.Stage.TRANSLOG;
                        break;
                    }
                    case DONE: {
                        stage = GatewayRecoveryStatus.Stage.DONE;
                        break;
                    }
                    default: {
                        stage = GatewayRecoveryStatus.Stage.INIT;
                    }
                }
                shardStatus.gatewayRecoveryStatus = new GatewayRecoveryStatus(stage, gatewayRecoveryState.getTimer().startTime(), gatewayRecoveryState.getTimer().time(), gatewayRecoveryState.getIndex().totalByteCount(), gatewayRecoveryState.getIndex().reusedByteCount(), gatewayRecoveryState.getIndex().recoveredByteCount(), gatewayRecoveryState.getTranslog().currentTranslogOperations());
            }
        }
        return shardStatus;
    }

    public static class IndexShardStatusRequest
    extends BroadcastShardOperationRequest {
        boolean recovery;
        boolean snapshot;

        IndexShardStatusRequest() {
        }

        IndexShardStatusRequest(String index, int shardId, IndicesStatusRequest request) {
            super(index, shardId, request);
            this.recovery = request.recovery();
            this.snapshot = request.snapshot();
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.recovery = in.readBoolean();
            this.snapshot = in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.recovery);
            out.writeBoolean(this.snapshot);
        }
    }
}

