/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search.type;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.search.type.ParsedScrollId;
import org.elasticsearch.action.search.type.TransportSearchHelper;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.hppc.IntArrayList;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.action.SearchServiceListener;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.fetch.FetchSearchRequest;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.internal.InternalScrollSearchRequest;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.query.QuerySearchResult;

public class TransportSearchScrollQueryThenFetchAction
extends AbstractComponent {
    private final ClusterService clusterService;
    private final SearchServiceTransportAction searchService;
    private final SearchPhaseController searchPhaseController;

    @Inject
    public TransportSearchScrollQueryThenFetchAction(Settings settings, ClusterService clusterService, SearchServiceTransportAction searchService, SearchPhaseController searchPhaseController) {
        super(settings);
        this.clusterService = clusterService;
        this.searchService = searchService;
        this.searchPhaseController = searchPhaseController;
    }

    public void execute(SearchScrollRequest request, ParsedScrollId scrollId, ActionListener<SearchResponse> listener) {
        new AsyncAction(request, scrollId, listener).start();
    }

    private class AsyncAction {
        private final SearchScrollRequest request;
        private final ActionListener<SearchResponse> listener;
        private final ParsedScrollId scrollId;
        private final DiscoveryNodes nodes;
        private volatile AtomicArray<ShardSearchFailure> shardFailures;
        final AtomicArray<QuerySearchResult> queryResults;
        final AtomicArray<FetchSearchResult> fetchResults;
        private volatile ScoreDoc[] sortedShardList;
        private final AtomicInteger successfulOps;
        private final long startTime = System.currentTimeMillis();
        private volatile boolean useSlowScroll;

        private AsyncAction(SearchScrollRequest request, ParsedScrollId scrollId, ActionListener<SearchResponse> listener) {
            this.request = request;
            this.listener = listener;
            this.scrollId = scrollId;
            this.nodes = TransportSearchScrollQueryThenFetchAction.this.clusterService.state().nodes();
            this.successfulOps = new AtomicInteger(scrollId.getContext().length);
            this.queryResults = new AtomicArray(scrollId.getContext().length);
            this.fetchResults = new AtomicArray(scrollId.getContext().length);
        }

        protected final ShardSearchFailure[] buildShardFailures() {
            if (this.shardFailures == null) {
                return ShardSearchFailure.EMPTY_ARRAY;
            }
            List<AtomicArray.Entry<ShardSearchFailure>> entries = this.shardFailures.asList();
            ShardSearchFailure[] failures = new ShardSearchFailure[entries.size()];
            for (int i = 0; i < failures.length; ++i) {
                failures[i] = (ShardSearchFailure)entries.get((int)i).value;
            }
            return failures;
        }

        protected final void addShardFailure(int shardIndex, ShardSearchFailure failure) {
            if (this.shardFailures == null) {
                this.shardFailures = new AtomicArray(this.scrollId.getContext().length);
            }
            this.shardFailures.set(shardIndex, failure);
        }

        public void start() {
            if (this.scrollId.getContext().length == 0) {
                this.listener.onFailure(new SearchPhaseExecutionException("query", "no nodes to search on", null));
                return;
            }
            AtomicInteger counter = new AtomicInteger(this.scrollId.getContext().length);
            Tuple<String, Long>[] context = this.scrollId.getContext();
            for (int i = 0; i < context.length; ++i) {
                Tuple<String, Long> target = context[i];
                DiscoveryNode node = this.nodes.get(target.v1());
                if (node != null) {
                    if (node.getVersion().before(ParsedScrollId.SCROLL_SEARCH_AFTER_MINIMUM_VERSION)) {
                        this.useSlowScroll = true;
                    }
                    this.executeQueryPhase(i, counter, node, target.v2());
                    continue;
                }
                if (TransportSearchScrollQueryThenFetchAction.this.logger.isDebugEnabled()) {
                    TransportSearchScrollQueryThenFetchAction.this.logger.debug("Node [" + target.v1() + "] not available for scroll request [" + this.scrollId.getSource() + "]", new Object[0]);
                }
                this.successfulOps.decrementAndGet();
                if (counter.decrementAndGet() != 0) continue;
                try {
                    this.executeFetchPhase();
                    continue;
                }
                catch (Throwable e) {
                    this.listener.onFailure(new SearchPhaseExecutionException("query", "Fetch failed", e, null));
                    return;
                }
            }
        }

        private void executeQueryPhase(final int shardIndex, final AtomicInteger counter, DiscoveryNode node, final long searchId) {
            InternalScrollSearchRequest internalRequest = TransportSearchHelper.internalScrollSearchRequest(searchId, this.request);
            TransportSearchScrollQueryThenFetchAction.this.searchService.sendExecuteQuery(node, internalRequest, new SearchServiceListener<QuerySearchResult>(){

                @Override
                public void onResult(QuerySearchResult result) {
                    AsyncAction.this.queryResults.set(shardIndex, result);
                    if (counter.decrementAndGet() == 0) {
                        try {
                            AsyncAction.this.executeFetchPhase();
                        }
                        catch (Throwable e) {
                            this.onFailure(e);
                        }
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    AsyncAction.this.onQueryPhaseFailure(shardIndex, counter, searchId, t);
                }
            });
        }

        void onQueryPhaseFailure(int shardIndex, AtomicInteger counter, long searchId, Throwable t) {
            if (TransportSearchScrollQueryThenFetchAction.this.logger.isDebugEnabled()) {
                TransportSearchScrollQueryThenFetchAction.this.logger.debug("[{}] Failed to execute query phase", t, searchId);
            }
            this.addShardFailure(shardIndex, new ShardSearchFailure(t));
            this.successfulOps.decrementAndGet();
            if (counter.decrementAndGet() == 0) {
                if (this.successfulOps.get() == 0) {
                    this.listener.onFailure(new SearchPhaseExecutionException("query", "all shards failed", this.buildShardFailures()));
                } else {
                    try {
                        this.executeFetchPhase();
                    }
                    catch (Throwable e) {
                        this.listener.onFailure(new SearchPhaseExecutionException("query", "Fetch failed", e, null));
                    }
                }
            }
        }

        private void executeFetchPhase() throws Exception {
            this.sortedShardList = this.useSlowScroll ? TransportSearchScrollQueryThenFetchAction.this.searchPhaseController.sortDocs(this.queryResults) : TransportSearchScrollQueryThenFetchAction.this.searchPhaseController.sortDocsForScroll(this.queryResults);
            AtomicArray<IntArrayList> docIdsToLoad = new AtomicArray<IntArrayList>(this.queryResults.length());
            TransportSearchScrollQueryThenFetchAction.this.searchPhaseController.fillDocIdsToLoad(docIdsToLoad, this.sortedShardList);
            if (docIdsToLoad.asList().isEmpty()) {
                this.finishHim();
                return;
            }
            ScoreDoc[] lastEmittedDocPerShard = this.useSlowScroll ? new ScoreDoc[this.queryResults.length()] : TransportSearchScrollQueryThenFetchAction.this.searchPhaseController.getLastEmittedDocPerShard(this.sortedShardList, this.queryResults.length());
            final AtomicInteger counter = new AtomicInteger(docIdsToLoad.asList().size());
            for (final AtomicArray.Entry<IntArrayList> entry : docIdsToLoad.asList()) {
                IntArrayList docIds = (IntArrayList)entry.value;
                final QuerySearchResult querySearchResult = this.queryResults.get(entry.index);
                ScoreDoc lastEmittedDoc = lastEmittedDocPerShard[entry.index];
                FetchSearchRequest fetchSearchRequest = new FetchSearchRequest(this.request, querySearchResult.id(), docIds, lastEmittedDoc);
                DiscoveryNode node = this.nodes.get(querySearchResult.shardTarget().nodeId());
                TransportSearchScrollQueryThenFetchAction.this.searchService.sendExecuteFetch(node, fetchSearchRequest, new SearchServiceListener<FetchSearchResult>(){

                    @Override
                    public void onResult(FetchSearchResult result) {
                        result.shardTarget(querySearchResult.shardTarget());
                        AsyncAction.this.fetchResults.set(entry.index, result);
                        if (counter.decrementAndGet() == 0) {
                            AsyncAction.this.finishHim();
                        }
                    }

                    @Override
                    public void onFailure(Throwable t) {
                        if (TransportSearchScrollQueryThenFetchAction.this.logger.isDebugEnabled()) {
                            TransportSearchScrollQueryThenFetchAction.this.logger.debug("Failed to execute fetch phase", t, new Object[0]);
                        }
                        AsyncAction.this.successfulOps.decrementAndGet();
                        if (counter.decrementAndGet() == 0) {
                            AsyncAction.this.finishHim();
                        }
                    }
                });
            }
        }

        private void finishHim() {
            try {
                this.innerFinishHim();
            }
            catch (Throwable e) {
                this.listener.onFailure(new ReduceSearchPhaseException("fetch", "", e, this.buildShardFailures()));
            }
        }

        private void innerFinishHim() {
            InternalSearchResponse internalResponse = TransportSearchScrollQueryThenFetchAction.this.searchPhaseController.merge(this.sortedShardList, this.queryResults, this.fetchResults);
            String scrollId = null;
            if (this.request.scroll() != null) {
                scrollId = this.request.scrollId();
            }
            this.listener.onResponse(new SearchResponse(internalResponse, scrollId, this.scrollId.getContext().length, this.successfulOps.get(), System.currentTimeMillis() - this.startTime, this.buildShardFailures()));
        }
    }
}

