/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.PlainShardIterator;
import org.elasticsearch.cluster.routing.RestoreSource;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingTableValidation;
import org.elasticsearch.cluster.routing.RoutingValidationException;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Iterables;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndexMissingException;

public class RoutingTable
implements Iterable<IndexRoutingTable> {
    public static final RoutingTable EMPTY_ROUTING_TABLE = RoutingTable.builder().build();
    private final long version;
    private final ImmutableMap<String, IndexRoutingTable> indicesRouting;

    RoutingTable(long version, Map<String, IndexRoutingTable> indicesRouting) {
        this.version = version;
        this.indicesRouting = ImmutableMap.copyOf(indicesRouting);
    }

    public long version() {
        return this.version;
    }

    @Override
    public UnmodifiableIterator<IndexRoutingTable> iterator() {
        return ((ImmutableCollection)this.indicesRouting.values()).iterator();
    }

    public boolean hasIndex(String index) {
        return this.indicesRouting.containsKey(index);
    }

    public IndexRoutingTable index(String index) {
        return this.indicesRouting.get(index);
    }

    public Map<String, IndexRoutingTable> indicesRouting() {
        return this.indicesRouting;
    }

    public Map<String, IndexRoutingTable> getIndicesRouting() {
        return this.indicesRouting();
    }

    public RoutingNodes routingNodes(ClusterState state) {
        return new RoutingNodes(state);
    }

    public RoutingTable validateRaiseException(MetaData metaData) throws RoutingValidationException {
        RoutingTableValidation validation = this.validate(metaData);
        if (!validation.valid()) {
            throw new RoutingValidationException(validation);
        }
        return this;
    }

    public RoutingTableValidation validate(MetaData metaData) {
        RoutingTableValidation validation = new RoutingTableValidation();
        for (IndexRoutingTable indexRoutingTable : this) {
            indexRoutingTable.validate(validation, metaData);
        }
        return validation;
    }

    public List<ShardRouting> shardsWithState(ShardRoutingState ... states) {
        ArrayList<ShardRouting> shards = Lists.newArrayList();
        for (IndexRoutingTable indexRoutingTable : this) {
            shards.addAll(indexRoutingTable.shardsWithState(states));
        }
        return shards;
    }

    public List<ShardRouting> allShards(String ... indices) throws IndexMissingException {
        ArrayList<ShardRouting> shards = Lists.newArrayList();
        if (indices == null || indices.length == 0) {
            indices = ((ImmutableCollection)((Object)this.indicesRouting.keySet())).toArray(new String[((AbstractCollection)((Object)this.indicesRouting.keySet())).size()]);
        }
        for (String index : indices) {
            IndexRoutingTable indexRoutingTable = this.index(index);
            if (indexRoutingTable == null) {
                throw new IndexMissingException(new Index(index));
            }
            for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                for (ShardRouting shardRouting : indexShardRoutingTable) {
                    shards.add(shardRouting);
                }
            }
        }
        return shards;
    }

    public GroupShardsIterator allShardsGrouped(String ... indices) throws IndexMissingException {
        ArrayList<ShardIterator> set = new ArrayList<ShardIterator>();
        if (indices == null || indices.length == 0) {
            indices = ((ImmutableCollection)((Object)this.indicesRouting.keySet())).toArray(new String[((AbstractCollection)((Object)this.indicesRouting.keySet())).size()]);
        }
        for (String index : indices) {
            IndexRoutingTable indexRoutingTable = this.index(index);
            if (indexRoutingTable == null) continue;
            for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                for (ShardRouting shardRouting : indexShardRoutingTable) {
                    set.add(shardRouting.shardsIt());
                }
            }
        }
        return new GroupShardsIterator(set);
    }

    public GroupShardsIterator allActiveShardsGrouped(String[] indices, boolean includeEmpty) throws IndexMissingException {
        ArrayList<ShardIterator> set = new ArrayList<ShardIterator>();
        if (indices == null || indices.length == 0) {
            indices = ((ImmutableCollection)((Object)this.indicesRouting.keySet())).toArray(new String[((AbstractCollection)((Object)this.indicesRouting.keySet())).size()]);
        }
        for (String index : indices) {
            IndexRoutingTable indexRoutingTable = this.index(index);
            if (indexRoutingTable == null) continue;
            for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                for (ShardRouting shardRouting : indexShardRoutingTable) {
                    if (shardRouting.active()) {
                        set.add(shardRouting.shardsIt());
                        continue;
                    }
                    if (!includeEmpty) continue;
                    set.add(new PlainShardIterator(shardRouting.shardId(), ImmutableList.of()));
                }
            }
        }
        return new GroupShardsIterator(set);
    }

    public GroupShardsIterator allAssignedShardsGrouped(String[] indices, boolean includeEmpty) throws IndexMissingException {
        ArrayList<ShardIterator> set = new ArrayList<ShardIterator>();
        if (indices == null || indices.length == 0) {
            indices = ((ImmutableCollection)((Object)this.indicesRouting.keySet())).toArray(new String[((AbstractCollection)((Object)this.indicesRouting.keySet())).size()]);
        }
        for (String index : indices) {
            IndexRoutingTable indexRoutingTable = this.index(index);
            if (indexRoutingTable == null) continue;
            for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                for (ShardRouting shardRouting : indexShardRoutingTable) {
                    if (shardRouting.assignedToNode()) {
                        set.add(shardRouting.shardsIt());
                        continue;
                    }
                    if (!includeEmpty) continue;
                    set.add(new PlainShardIterator(shardRouting.shardId(), ImmutableList.of()));
                }
            }
        }
        return new GroupShardsIterator(set);
    }

    public GroupShardsIterator activePrimaryShardsGrouped(String[] indices, boolean includeEmpty) throws IndexMissingException {
        ArrayList<ShardIterator> set = new ArrayList<ShardIterator>();
        if (indices == null || indices.length == 0) {
            indices = ((ImmutableCollection)((Object)this.indicesRouting.keySet())).toArray(new String[((AbstractCollection)((Object)this.indicesRouting.keySet())).size()]);
        }
        for (String index : indices) {
            IndexRoutingTable indexRoutingTable = this.index(index);
            if (indexRoutingTable == null) {
                throw new IndexMissingException(new Index(index));
            }
            for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                ShardRouting primary = indexShardRoutingTable.primaryShard();
                if (primary.active()) {
                    set.add(primary.shardsIt());
                    continue;
                }
                if (!includeEmpty) continue;
                set.add(new PlainShardIterator(primary.shardId(), ImmutableList.of()));
            }
        }
        return new GroupShardsIterator(set);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RoutingTable routingTable) {
        return new Builder(routingTable);
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder("routing_table (version ").append(this.version).append("):\n");
        for (Map.Entry entry : this.indicesRouting.entrySet()) {
            sb.append(((IndexRoutingTable)entry.getValue()).prettyPrint()).append('\n');
        }
        return sb.toString();
    }

    public static class Builder {
        private long version;
        private final Map<String, IndexRoutingTable> indicesRouting = Maps.newHashMap();

        public Builder() {
        }

        public Builder(RoutingTable routingTable) {
            this.version = routingTable.version;
            for (IndexRoutingTable indexRoutingTable : routingTable) {
                this.indicesRouting.put(indexRoutingTable.index(), indexRoutingTable);
            }
        }

        public Builder updateNodes(RoutingNodes routingNodes) {
            this.version = routingNodes.routingTable().version();
            HashMap<String, IndexRoutingTable.Builder> indexRoutingTableBuilders = Maps.newHashMap();
            for (RoutingNode routingNode : routingNodes) {
                for (MutableShardRouting shardRoutingEntry : routingNode) {
                    if (shardRoutingEntry.state() == ShardRoutingState.INITIALIZING && shardRoutingEntry.relocatingNodeId() != null) continue;
                    String index = shardRoutingEntry.index();
                    IndexRoutingTable.Builder indexBuilder = (IndexRoutingTable.Builder)indexRoutingTableBuilders.get(index);
                    if (indexBuilder == null) {
                        indexBuilder = new IndexRoutingTable.Builder(index);
                        indexRoutingTableBuilders.put(index, indexBuilder);
                    }
                    IndexShardRoutingTable refData = routingNodes.routingTable().index(shardRoutingEntry.index()).shard(shardRoutingEntry.id());
                    indexBuilder.addShard(refData, shardRoutingEntry);
                }
            }
            for (MutableShardRouting shardRoutingEntry : Iterables.concat(routingNodes.unassigned(), routingNodes.ignoredUnassigned())) {
                String index = shardRoutingEntry.index();
                IndexRoutingTable.Builder indexBuilder = (IndexRoutingTable.Builder)indexRoutingTableBuilders.get(index);
                if (indexBuilder == null) {
                    indexBuilder = new IndexRoutingTable.Builder(index);
                    indexRoutingTableBuilders.put(index, indexBuilder);
                }
                IndexShardRoutingTable refData = routingNodes.routingTable().index(shardRoutingEntry.index()).shard(shardRoutingEntry.id());
                indexBuilder.addShard(refData, shardRoutingEntry);
            }
            for (ShardId shardId : routingNodes.getShardsToClearPostAllocationFlag()) {
                IndexRoutingTable.Builder indexRoutingBuilder = (IndexRoutingTable.Builder)indexRoutingTableBuilders.get(shardId.index().name());
                if (indexRoutingBuilder == null) continue;
                indexRoutingBuilder.clearPostAllocationFlag(shardId);
            }
            for (IndexRoutingTable.Builder indexBuilder : indexRoutingTableBuilders.values()) {
                this.add(indexBuilder);
            }
            return this;
        }

        public Builder updateNumberOfReplicas(int numberOfReplicas, String ... indices) throws IndexMissingException {
            if (indices == null || indices.length == 0) {
                indices = this.indicesRouting.keySet().toArray(new String[this.indicesRouting.keySet().size()]);
            }
            for (String index : indices) {
                int delta;
                IndexRoutingTable indexRoutingTable = this.indicesRouting.get(index);
                if (indexRoutingTable == null) continue;
                int currentNumberOfReplicas = indexRoutingTable.shards().get(0).size() - 1;
                IndexRoutingTable.Builder builder = new IndexRoutingTable.Builder(index);
                for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                    builder.addIndexShard(indexShardRoutingTable);
                }
                if (currentNumberOfReplicas < numberOfReplicas) {
                    for (int i = 0; i < numberOfReplicas - currentNumberOfReplicas; ++i) {
                        builder.addReplica();
                    }
                } else if (currentNumberOfReplicas > numberOfReplicas && (delta = currentNumberOfReplicas - numberOfReplicas) > 0) {
                    for (int i = 0; i < delta; ++i) {
                        builder.removeReplica();
                    }
                }
                this.indicesRouting.put(index, builder.build());
            }
            return this;
        }

        public Builder addAsNew(IndexMetaData indexMetaData) {
            if (indexMetaData.state() == IndexMetaData.State.OPEN) {
                IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(indexMetaData.index()).initializeAsNew(indexMetaData);
                this.add(indexRoutingBuilder);
            }
            return this;
        }

        public Builder addAsRecovery(IndexMetaData indexMetaData) {
            if (indexMetaData.state() == IndexMetaData.State.OPEN) {
                IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(indexMetaData.index()).initializeAsRecovery(indexMetaData);
                this.add(indexRoutingBuilder);
            }
            return this;
        }

        public Builder addAsRestore(IndexMetaData indexMetaData, RestoreSource restoreSource) {
            IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(indexMetaData.index()).initializeAsRestore(indexMetaData, restoreSource);
            this.add(indexRoutingBuilder);
            return this;
        }

        public Builder addAsNewRestore(IndexMetaData indexMetaData, RestoreSource restoreSource) {
            IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(indexMetaData.index()).initializeAsNewRestore(indexMetaData, restoreSource);
            this.add(indexRoutingBuilder);
            return this;
        }

        public Builder add(IndexRoutingTable indexRoutingTable) {
            indexRoutingTable.validate();
            this.indicesRouting.put(indexRoutingTable.index(), indexRoutingTable);
            return this;
        }

        public Builder add(IndexRoutingTable.Builder indexRoutingTableBuilder) {
            this.add(indexRoutingTableBuilder.build());
            return this;
        }

        public Builder remove(String index) {
            this.indicesRouting.remove(index);
            return this;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public RoutingTable build() {
            for (IndexRoutingTable indexRoutingTable : this.indicesRouting.values()) {
                this.indicesRouting.put(indexRoutingTable.index(), indexRoutingTable.normalizeVersions());
            }
            return new RoutingTable(this.version, this.indicesRouting);
        }

        public static RoutingTable readFrom(StreamInput in) throws IOException {
            Builder builder = new Builder();
            builder.version = in.readLong();
            int size = in.readVInt();
            for (int i = 0; i < size; ++i) {
                IndexRoutingTable index = IndexRoutingTable.Builder.readFrom(in);
                builder.add(index);
            }
            return builder.build();
        }

        public static void writeTo(RoutingTable table, StreamOutput out) throws IOException {
            out.writeLong(table.version);
            out.writeVInt(table.indicesRouting.size());
            for (IndexRoutingTable index : table.indicesRouting.values()) {
                IndexRoutingTable.Builder.writeTo(index, out);
            }
        }
    }
}

