/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.common.blobstore.ImmutableBlobContainer;

public class BlobStores {
    public static void syncWriteBlob(ImmutableBlobContainer blobContainer, String blobName, InputStream is, long sizeInBytes) throws IOException {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference failure = new AtomicReference();
        blobContainer.writeBlob(blobName, is, sizeInBytes, new ImmutableBlobContainer.WriterListener(){

            @Override
            public void onCompleted() {
                latch.countDown();
            }

            @Override
            public void onFailure(Throwable t) {
                failure.set(t);
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted while waiting to write [" + blobName + "]");
        }
        if (failure.get() != null) {
            if (failure.get() instanceof IOException) {
                throw (IOException)failure.get();
            }
            throw new IOException("Failed to get [" + blobName + "]", (Throwable)failure.get());
        }
    }
}

