/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.docset;

import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.OpenBitSetIterator;
import org.elasticsearch.common.Nullable;

public class DocIdSets {
    protected static final DocIdSet EMPTY_DOCIDSET = new DocIdSet(){

        public DocIdSetIterator iterator() {
            return DocIdSetIterator.empty();
        }

        public boolean isCacheable() {
            return true;
        }

        public Bits bits() {
            return null;
        }
    };

    public static long sizeInBytes(DocIdSet docIdSet) {
        if (docIdSet instanceof FixedBitSet) {
            return ((FixedBitSet)docIdSet).getBits().length * 8 + 16;
        }
        return 1L;
    }

    public static boolean isEmpty(@Nullable DocIdSet set) {
        return set == null || set == EMPTY_DOCIDSET;
    }

    public static boolean isFastIterator(DocIdSet set) {
        return set instanceof FixedBitSet;
    }

    public static boolean isFastIterator(DocIdSetIterator iterator) {
        return iterator instanceof OpenBitSetIterator;
    }

    public static DocIdSet toCacheable(AtomicReader reader, @Nullable DocIdSet set) throws IOException {
        if (set == null || set == EMPTY_DOCIDSET) {
            return EMPTY_DOCIDSET;
        }
        DocIdSetIterator it = set.iterator();
        if (it == null) {
            return EMPTY_DOCIDSET;
        }
        int doc = it.nextDoc();
        if (doc == Integer.MAX_VALUE) {
            return EMPTY_DOCIDSET;
        }
        if (set instanceof FixedBitSet) {
            return set;
        }
        FixedBitSet fixedBitSet = new FixedBitSet(reader.maxDoc());
        do {
            fixedBitSet.set(doc);
        } while ((doc = it.nextDoc()) != Integer.MAX_VALUE);
        return fixedBitSet;
    }

    public static Bits toSafeBits(AtomicReader reader, @Nullable DocIdSet set) throws IOException {
        if (set == null) {
            return new Bits.MatchNoBits(reader.maxDoc());
        }
        Bits bits = set.bits();
        if (bits != null) {
            return bits;
        }
        DocIdSetIterator iterator = set.iterator();
        if (iterator == null) {
            return new Bits.MatchNoBits(reader.maxDoc());
        }
        return DocIdSets.toFixedBitSet(iterator, reader.maxDoc());
    }

    public static FixedBitSet toFixedBitSet(DocIdSetIterator iterator, int numBits) throws IOException {
        int doc;
        FixedBitSet set = new FixedBitSet(numBits);
        while ((doc = iterator.nextDoc()) != Integer.MAX_VALUE) {
            set.set(doc);
        }
        return set;
    }
}

