/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.lang.reflect.Field;
import java.nio.ByteOrder;
import org.apache.lucene.util.BytesRef;
import sun.misc.Unsafe;

public final class UnsafeUtils
extends Enum<UnsafeUtils> {
    private static final Unsafe UNSAFE;
    private static final long BYTE_ARRAY_OFFSET;
    private static final int BYTE_ARRAY_SCALE;
    private static final /* synthetic */ UnsafeUtils[] $VALUES;

    public static UnsafeUtils[] values() {
        return (UnsafeUtils[])$VALUES.clone();
    }

    public static UnsafeUtils valueOf(String name) {
        return Enum.valueOf(UnsafeUtils.class, name);
    }

    private static long readLong(byte[] src, int offset) {
        return UNSAFE.getLong(src, BYTE_ARRAY_OFFSET + (long)offset);
    }

    private static int readInt(byte[] src, int offset) {
        return UNSAFE.getInt(src, BYTE_ARRAY_OFFSET + (long)offset);
    }

    private static short readShort(byte[] src, int offset) {
        return UNSAFE.getShort(src, BYTE_ARRAY_OFFSET + (long)offset);
    }

    private static byte readByte(byte[] src, int offset) {
        return UNSAFE.getByte(src, BYTE_ARRAY_OFFSET + (long)(BYTE_ARRAY_SCALE * offset));
    }

    public static boolean equals(BytesRef b1, BytesRef b2) {
        if (b1.length != b2.length) {
            return false;
        }
        return UnsafeUtils.equals(b1.bytes, b1.offset, b2.bytes, b2.offset, b1.length);
    }

    public static boolean equals(byte[] b1, int offset1, byte[] b2, int offset2, int length) {
        int o1 = offset1;
        int o2 = offset2;
        int len = length;
        while (len >= 8) {
            if (UnsafeUtils.readLong(b1, o1) != UnsafeUtils.readLong(b2, o2)) {
                return false;
            }
            len -= 8;
            o1 += 8;
            o2 += 8;
        }
        if (len >= 4) {
            if (UnsafeUtils.readInt(b1, o1) != UnsafeUtils.readInt(b2, o2)) {
                return false;
            }
            len -= 4;
            o1 += 4;
            o2 += 4;
        }
        if (len >= 2) {
            if (UnsafeUtils.readShort(b1, o1) != UnsafeUtils.readShort(b2, o2)) {
                return false;
            }
            len -= 2;
            o1 += 2;
            o2 += 2;
        }
        if (len == 1) {
            if (UnsafeUtils.readByte(b1, o1) != UnsafeUtils.readByte(b2, o2)) {
                return false;
            }
        } else assert (len == 0);
        return true;
    }

    public static long readLongLE(byte[] src, int offset) {
        long value = UnsafeUtils.readLong(src, offset);
        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            value = Long.reverseBytes(value);
        }
        return value;
    }

    public static int readIntLE(byte[] src, int offset) {
        int value = UnsafeUtils.readInt(src, offset);
        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            value = Integer.reverseBytes(value);
        }
        return value;
    }

    static {
        $VALUES = new UnsafeUtils[0];
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            UNSAFE = (Unsafe)theUnsafe.get(null);
            BYTE_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
            BYTE_ARRAY_SCALE = UNSAFE.arrayIndexScale(byte[].class);
        }
        catch (IllegalAccessException e) {
            throw new ExceptionInInitializerError("Cannot access Unsafe");
        }
        catch (NoSuchFieldException e) {
            throw new ExceptionInInitializerError("Cannot access Unsafe");
        }
        catch (SecurityException e) {
            throw new ExceptionInInitializerError("Cannot access Unsafe");
        }
    }
}

