/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.elasticsearch.common.hppc.ObjectLongOpenHashMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.fielddata.FieldDataStats;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.RamUsage;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;

public class ShardFieldData
extends AbstractIndexShardComponent
implements IndexFieldDataCache.Listener {
    final CounterMetric evictionsMetric = new CounterMetric();
    final CounterMetric totalMetric = new CounterMetric();
    final ConcurrentMap<String, CounterMetric> perFieldTotals = ConcurrentCollections.newConcurrentMap();

    @Inject
    public ShardFieldData(ShardId shardId, @IndexSettings Settings indexSettings) {
        super(shardId, indexSettings);
    }

    public FieldDataStats stats(String ... fields) {
        ObjectLongOpenHashMap<String> fieldTotals = null;
        if (fields != null && fields.length > 0) {
            fieldTotals = new ObjectLongOpenHashMap<String>();
            for (Map.Entry entry : this.perFieldTotals.entrySet()) {
                for (String field : fields) {
                    if (!Regex.simpleMatch(field, (String)entry.getKey())) continue;
                    fieldTotals.put((String)entry.getKey(), ((CounterMetric)entry.getValue()).count());
                }
            }
        }
        long memorySize = this.totalMetric.count();
        if (this.perFieldTotals.containsKey("_parent")) {
            memorySize -= ((CounterMetric)this.perFieldTotals.get("_parent")).count();
        }
        return new FieldDataStats(memorySize, this.evictionsMetric.count(), fieldTotals);
    }

    @Override
    public void onLoad(FieldMapper.Names fieldNames, FieldDataType fieldDataType, RamUsage ramUsage) {
        this.totalMetric.inc(ramUsage.getMemorySizeInBytes());
        String keyFieldName = fieldNames.indexName();
        CounterMetric total = (CounterMetric)this.perFieldTotals.get(keyFieldName);
        if (total != null) {
            total.inc(ramUsage.getMemorySizeInBytes());
        } else {
            total = new CounterMetric();
            total.inc(ramUsage.getMemorySizeInBytes());
            CounterMetric prev = this.perFieldTotals.putIfAbsent(keyFieldName, total);
            if (prev != null) {
                prev.inc(ramUsage.getMemorySizeInBytes());
            }
        }
    }

    @Override
    public void onUnload(FieldMapper.Names fieldNames, FieldDataType fieldDataType, boolean wasEvicted, long sizeInBytes) {
        if (wasEvicted) {
            this.evictionsMetric.inc();
        }
        if (sizeInBytes != -1L) {
            this.totalMetric.dec(sizeInBytes);
            String keyFieldName = fieldNames.indexName();
            CounterMetric total = (CounterMetric)this.perFieldTotals.get(keyFieldName);
            if (total != null) {
                total.dec(sizeInBytes);
            }
        }
    }
}

