/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalsIndexFieldData;
import org.elasticsearch.index.fielddata.ordinals.InternalGlobalOrdinalsBuilder;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.plain.AtomicFieldDataWithOrdinalsTermsEnum;
import org.elasticsearch.index.mapper.FieldMapper;

final class InternalGlobalOrdinalsIndexFieldData
extends GlobalOrdinalsIndexFieldData {
    private final Atomic[] atomicReaders;

    InternalGlobalOrdinalsIndexFieldData(Index index, Settings settings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, AtomicFieldData.WithOrdinals[] segmentAfd, LongValues globalOrdToFirstSegment, LongValues globalOrdToFirstSegmentDelta, InternalGlobalOrdinalsBuilder.OrdinalMappingSource[] segmentOrdToGlobalOrds, long memorySizeInBytes) {
        super(index, settings, fieldNames, fieldDataType, memorySizeInBytes);
        this.atomicReaders = new Atomic[segmentAfd.length];
        for (int i = 0; i < segmentAfd.length; ++i) {
            this.atomicReaders[i] = new Atomic(segmentAfd[i], globalOrdToFirstSegment, globalOrdToFirstSegmentDelta, segmentOrdToGlobalOrds[i]);
        }
    }

    @Override
    public AtomicFieldData.WithOrdinals load(AtomicReaderContext context) {
        return this.atomicReaders[context.ord];
    }

    private final class Atomic
    implements AtomicFieldData.WithOrdinals {
        private final AtomicFieldData.WithOrdinals afd;
        private final InternalGlobalOrdinalsBuilder.OrdinalMappingSource segmentOrdToGlobalOrdLookup;
        private final LongValues globalOrdToFirstSegment;
        private final LongValues globalOrdToFirstSegmentDelta;

        private Atomic(AtomicFieldData.WithOrdinals afd, LongValues globalOrdToFirstSegment, LongValues globalOrdToFirstSegmentDelta, InternalGlobalOrdinalsBuilder.OrdinalMappingSource segmentOrdToGlobalOrdLookup) {
            this.afd = afd;
            this.segmentOrdToGlobalOrdLookup = segmentOrdToGlobalOrdLookup;
            this.globalOrdToFirstSegment = globalOrdToFirstSegment;
            this.globalOrdToFirstSegmentDelta = globalOrdToFirstSegmentDelta;
        }

        @Override
        public BytesValues.WithOrdinals getBytesValues(boolean needsHashes) {
            BytesValues.WithOrdinals values = this.afd.getBytesValues(false);
            Ordinals.Docs segmentOrdinals = values.ordinals();
            Ordinals.Docs globalOrdinals = this.segmentOrdToGlobalOrdLookup != null ? this.segmentOrdToGlobalOrdLookup.globalOrdinals(segmentOrdinals) : segmentOrdinals;
            final BytesValues.WithOrdinals[] bytesValues = new BytesValues.WithOrdinals[InternalGlobalOrdinalsIndexFieldData.this.atomicReaders.length];
            for (int i = 0; i < bytesValues.length; ++i) {
                bytesValues[i] = ((InternalGlobalOrdinalsIndexFieldData)InternalGlobalOrdinalsIndexFieldData.this).atomicReaders[i].afd.getBytesValues(false);
            }
            return new BytesValues.WithOrdinals(globalOrdinals){
                int readerIndex;

                @Override
                public BytesRef getValueByOrd(long globalOrd) {
                    long segmentOrd = globalOrd - Atomic.this.globalOrdToFirstSegmentDelta.get(globalOrd);
                    this.readerIndex = (int)Atomic.this.globalOrdToFirstSegment.get(globalOrd);
                    return bytesValues[this.readerIndex].getValueByOrd(segmentOrd);
                }

                @Override
                public BytesRef copyShared() {
                    return bytesValues[this.readerIndex].copyShared();
                }

                @Override
                public int currentValueHash() {
                    return bytesValues[this.readerIndex].currentValueHash();
                }
            };
        }

        @Override
        public boolean isMultiValued() {
            return this.afd.isMultiValued();
        }

        @Override
        public long getNumberUniqueValues() {
            return this.afd.getNumberUniqueValues();
        }

        @Override
        public long getMemorySizeInBytes() {
            return this.afd.getMemorySizeInBytes();
        }

        @Override
        public ScriptDocValues getScriptValues() {
            throw new UnsupportedOperationException("Script values not supported on global ordinals");
        }

        @Override
        public TermsEnum getTermsEnum() {
            return new AtomicFieldDataWithOrdinalsTermsEnum(this);
        }

        @Override
        public void close() {
        }
    }
}

