/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.mapping.delete;

import org.elasticsearch.action.admin.indices.mapping.delete.DeleteMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.delete.DeleteMappingResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.support.AcknowledgedRestListener;

public class RestDeleteMappingAction
extends BaseRestHandler {
    @Inject
    public RestDeleteMappingAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.DELETE, "/{index}/{type}/_mapping", this);
        controller.registerHandler(RestRequest.Method.DELETE, "/{index}/{type}", this);
        controller.registerHandler(RestRequest.Method.DELETE, "/{index}/_mapping/{type}", this);
        controller.registerHandler(RestRequest.Method.DELETE, "/{index}/{type}/_mappings", this);
        controller.registerHandler(RestRequest.Method.DELETE, "/{index}/_mappings/{type}", this);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel) {
        DeleteMappingRequest deleteMappingRequest = Requests.deleteMappingRequest(Strings.splitStringByCommaToArray(request.param("index")));
        deleteMappingRequest.listenerThreaded(false);
        deleteMappingRequest.types(Strings.splitStringByCommaToArray(request.param("type")));
        deleteMappingRequest.timeout(request.paramAsTime("timeout", deleteMappingRequest.timeout()));
        deleteMappingRequest.masterNodeTimeout(request.paramAsTime("master_timeout", deleteMappingRequest.masterNodeTimeout()));
        deleteMappingRequest.indicesOptions(IndicesOptions.fromRequest(request, deleteMappingRequest.indicesOptions()));
        this.client.admin().indices().deleteMapping(deleteMappingRequest, new AcknowledgedRestListener<DeleteMappingResponse>(channel));
    }
}

