/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.main;

import org.apache.lucene.util.Constants;
import org.elasticsearch.Build;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestResponseListener;

public class RestMainAction
extends BaseRestHandler {
    private final Version version;

    @Inject
    public RestMainAction(Settings settings, Version version, Client client, RestController controller) {
        super(settings, client);
        this.version = version;
        controller.registerHandler(RestRequest.Method.GET, "/", this);
        controller.registerHandler(RestRequest.Method.HEAD, "/", this);
    }

    @Override
    public void handleRequest(final RestRequest request, RestChannel channel) {
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
        clusterStateRequest.listenerThreaded(false);
        clusterStateRequest.masterNodeTimeout(TimeValue.timeValueMillis(0L));
        clusterStateRequest.local(true);
        clusterStateRequest.clear().blocks(true);
        this.client.admin().cluster().state(clusterStateRequest, (ActionListener<ClusterStateResponse>)new RestResponseListener<ClusterStateResponse>(channel){

            @Override
            public RestResponse buildResponse(ClusterStateResponse response) throws Exception {
                RestStatus status = RestStatus.OK;
                if (response.getState().blocks().hasGlobalBlock(RestStatus.SERVICE_UNAVAILABLE)) {
                    status = RestStatus.SERVICE_UNAVAILABLE;
                }
                if (request.method() == RestRequest.Method.HEAD) {
                    return new BytesRestResponse(status);
                }
                XContentBuilder builder = this.channel.newBuilder();
                if (!request.hasParam("pretty")) {
                    builder.prettyPrint().lfAtEnd();
                }
                builder.startObject();
                builder.field("status", status.getStatus());
                if (RestMainAction.this.settings.get("name") != null) {
                    builder.field("name", RestMainAction.this.settings.get("name"));
                }
                builder.startObject("version").field("number", RestMainAction.this.version.number()).field("build_hash", Build.CURRENT.hash()).field("build_timestamp", Build.CURRENT.timestamp()).field("build_snapshot", (Object)((RestMainAction)RestMainAction.this).version.snapshot).field("lucene_version", Constants.LUCENE_MAIN_VERSION).endObject();
                builder.field("tagline", "You Know, for Search");
                builder.endObject();
                return new BytesRestResponse(status, builder);
            }
        });
    }
}

