/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.search;

import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestStatusToXContentListener;
import org.elasticsearch.search.Scroll;

public class RestSearchScrollAction
extends BaseRestHandler {
    @Inject
    public RestSearchScrollAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_search/scroll", this);
        controller.registerHandler(RestRequest.Method.POST, "/_search/scroll", this);
        controller.registerHandler(RestRequest.Method.GET, "/_search/scroll/{scroll_id}", this);
        controller.registerHandler(RestRequest.Method.POST, "/_search/scroll/{scroll_id}", this);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel) {
        String scrollId = request.param("scroll_id");
        if (scrollId == null) {
            scrollId = RestActions.getRestContent(request).toUtf8();
        }
        SearchScrollRequest searchScrollRequest = new SearchScrollRequest(scrollId);
        searchScrollRequest.listenerThreaded(false);
        String scroll = request.param("scroll");
        if (scroll != null) {
            searchScrollRequest.scroll(new Scroll(TimeValue.parseTimeValue(scroll, null)));
        }
        this.client.searchScroll(searchScrollRequest, new RestStatusToXContentListener<SearchResponse>(channel));
    }
}

