/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.util.List;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.multibindings.Multibinder;
import org.elasticsearch.search.aggregations.AggregationParseElement;
import org.elasticsearch.search.aggregations.AggregationPhase;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorParsers;
import org.elasticsearch.search.aggregations.bucket.filter.FilterParser;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoHashGridParser;
import org.elasticsearch.search.aggregations.bucket.global.GlobalParser;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramParser;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramParser;
import org.elasticsearch.search.aggregations.bucket.missing.MissingParser;
import org.elasticsearch.search.aggregations.bucket.nested.NestedParser;
import org.elasticsearch.search.aggregations.bucket.nested.ReverseNestedParser;
import org.elasticsearch.search.aggregations.bucket.range.RangeParser;
import org.elasticsearch.search.aggregations.bucket.range.date.DateRangeParser;
import org.elasticsearch.search.aggregations.bucket.range.geodistance.GeoDistanceParser;
import org.elasticsearch.search.aggregations.bucket.range.ipv4.IpRangeParser;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantTermsParser;
import org.elasticsearch.search.aggregations.bucket.terms.TermsParser;
import org.elasticsearch.search.aggregations.metrics.avg.AvgParser;
import org.elasticsearch.search.aggregations.metrics.cardinality.CardinalityParser;
import org.elasticsearch.search.aggregations.metrics.max.MaxParser;
import org.elasticsearch.search.aggregations.metrics.min.MinParser;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesParser;
import org.elasticsearch.search.aggregations.metrics.stats.StatsParser;
import org.elasticsearch.search.aggregations.metrics.stats.extended.ExtendedStatsParser;
import org.elasticsearch.search.aggregations.metrics.sum.SumParser;
import org.elasticsearch.search.aggregations.metrics.valuecount.ValueCountParser;

public class AggregationModule
extends AbstractModule {
    private List<Class<? extends Aggregator.Parser>> parsers = Lists.newArrayList();

    public AggregationModule() {
        this.parsers.add(AvgParser.class);
        this.parsers.add(SumParser.class);
        this.parsers.add(MinParser.class);
        this.parsers.add(MaxParser.class);
        this.parsers.add(StatsParser.class);
        this.parsers.add(ExtendedStatsParser.class);
        this.parsers.add(ValueCountParser.class);
        this.parsers.add(PercentilesParser.class);
        this.parsers.add(CardinalityParser.class);
        this.parsers.add(GlobalParser.class);
        this.parsers.add(MissingParser.class);
        this.parsers.add(FilterParser.class);
        this.parsers.add(TermsParser.class);
        this.parsers.add(SignificantTermsParser.class);
        this.parsers.add(RangeParser.class);
        this.parsers.add(DateRangeParser.class);
        this.parsers.add(IpRangeParser.class);
        this.parsers.add(HistogramParser.class);
        this.parsers.add(DateHistogramParser.class);
        this.parsers.add(GeoDistanceParser.class);
        this.parsers.add(GeoHashGridParser.class);
        this.parsers.add(NestedParser.class);
        this.parsers.add(ReverseNestedParser.class);
    }

    public void addAggregatorParser(Class<? extends Aggregator.Parser> parser) {
        this.parsers.add(parser);
    }

    @Override
    protected void configure() {
        Multibinder<Aggregator.Parser> multibinder = Multibinder.newSetBinder(this.binder(), Aggregator.Parser.class);
        for (Class<? extends Aggregator.Parser> parser : this.parsers) {
            multibinder.addBinding().to(parser);
        }
        this.bind(AggregatorParsers.class).asEagerSingleton();
        this.bind(AggregationParseElement.class).asEagerSingleton();
        this.bind(AggregationPhase.class).asEagerSingleton();
    }
}

