/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import java.io.IOException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class FieldSortBuilder
extends SortBuilder {
    private final String fieldName;
    private SortOrder order;
    private Object missing;
    private Boolean ignoreUnmapped;
    private String sortMode;
    private FilterBuilder nestedFilter;
    private String nestedPath;

    public FieldSortBuilder(String fieldName) {
        if (fieldName == null) {
            throw new ElasticsearchIllegalArgumentException("fieldName must not be null");
        }
        this.fieldName = fieldName;
    }

    @Override
    public FieldSortBuilder order(SortOrder order) {
        this.order = order;
        return this;
    }

    @Override
    public FieldSortBuilder missing(Object missing) {
        this.missing = missing;
        return this;
    }

    public FieldSortBuilder ignoreUnmapped(boolean ignoreUnmapped) {
        this.ignoreUnmapped = ignoreUnmapped;
        return this;
    }

    public FieldSortBuilder sortMode(String sortMode) {
        this.sortMode = sortMode;
        return this;
    }

    public FieldSortBuilder setNestedFilter(FilterBuilder nestedFilter) {
        this.nestedFilter = nestedFilter;
        return this;
    }

    public FieldSortBuilder setNestedPath(String nestedPath) {
        this.nestedPath = nestedPath;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.fieldName);
        if (this.order != null) {
            builder.field("order", this.order.toString());
        }
        if (this.missing != null) {
            builder.field("missing", this.missing);
        }
        if (this.ignoreUnmapped != null) {
            builder.field("ignore_unmapped", (Object)this.ignoreUnmapped);
        }
        if (this.sortMode != null) {
            builder.field("mode", this.sortMode);
        }
        if (this.nestedFilter != null) {
            builder.field("nested_filter", this.nestedFilter, params);
        }
        if (this.nestedPath != null) {
            builder.field("nested_path", this.nestedPath);
        }
        builder.endObject();
        return builder;
    }
}

