/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.single.custom;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.single.custom.SingleCustomOperationRequest;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public abstract class TransportSingleCustomOperationAction<Request extends SingleCustomOperationRequest, Response extends ActionResponse>
extends TransportAction<Request, Response> {
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    final String transportShardAction;
    final String executor;

    protected TransportSingleCustomOperationAction(Settings settings, String actionName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters) {
        super(settings, actionName, threadPool, actionFilters);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.transportShardAction = actionName + "[s]";
        this.executor = this.executor();
        transportService.registerHandler(this.transportShardAction, new ShardTransportHandler());
    }

    @Override
    protected void doExecute(Request request, ActionListener<Response> listener) {
        new AsyncSingleAction(this, (SingleCustomOperationRequest)request, listener).start();
    }

    protected abstract String executor();

    protected abstract ShardsIterator shards(ClusterState var1, InternalRequest var2);

    protected abstract Response shardOperation(Request var1, ShardId var2) throws ElasticsearchException;

    protected abstract Request newRequest();

    protected abstract Response newResponse();

    protected ClusterBlockException checkGlobalBlock(ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.READ);
    }

    protected ClusterBlockException checkRequestBlock(ClusterState state, InternalRequest request) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.READ, request.concreteIndex());
    }

    protected abstract boolean resolveIndex(Request var1);

    protected static class InternalRequest {
        final Request request;
        final String concreteIndex;
        final /* synthetic */ TransportSingleCustomOperationAction this$0;

        InternalRequest(Request request, String concreteIndex) {
            this.this$0 = var1_1;
            this.request = request;
            this.concreteIndex = concreteIndex;
        }

        public Request request() {
            return this.request;
        }

        public String concreteIndex() {
            return this.concreteIndex;
        }
    }

    protected class ShardSingleOperationRequest
    extends TransportRequest
    implements IndicesRequest {
        private Request request;
        private ShardId shardId;

        ShardSingleOperationRequest() {
        }

        public ShardSingleOperationRequest(Request request, ShardId shardId) {
            super((TransportRequest)request);
            this.request = request;
            this.shardId = shardId;
        }

        public Request request() {
            return this.request;
        }

        @Override
        public String[] indices() {
            return ((SingleCustomOperationRequest)this.request).indices();
        }

        @Override
        public IndicesOptions indicesOptions() {
            return ((SingleCustomOperationRequest)this.request).indicesOptions();
        }

        public ShardId shardId() {
            return this.shardId;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.request = TransportSingleCustomOperationAction.this.newRequest();
            ((SingleCustomOperationRequest)this.request).readFrom(in);
            this.shardId = in.getVersion().onOrAfter(Version.V_1_4_0_Beta1) ? ShardId.readShardId(in) : new ShardId(((SingleCustomOperationRequest)this.request).index(), in.readVInt());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (out.getVersion().before(Version.V_1_4_0_Beta1)) {
                ((SingleCustomOperationRequest)this.request).index(this.shardId.getIndex());
            }
            ((SingleCustomOperationRequest)this.request).writeTo(out);
            if (out.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
                this.shardId.writeTo(out);
            } else {
                out.writeVInt(this.shardId.id());
            }
        }
    }

    private class ShardTransportHandler
    extends BaseTransportRequestHandler<ShardSingleOperationRequest> {
        private ShardTransportHandler() {
        }

        @Override
        public ShardSingleOperationRequest newInstance() {
            return new ShardSingleOperationRequest();
        }

        @Override
        public String executor() {
            return TransportSingleCustomOperationAction.this.executor;
        }

        @Override
        public void messageReceived(ShardSingleOperationRequest request, TransportChannel channel) throws Exception {
            Object response = TransportSingleCustomOperationAction.this.shardOperation(request.request(), request.shardId());
            channel.sendResponse((TransportResponse)response);
        }
    }

    private static class AsyncSingleAction {
        private final ActionListener<Response> listener;
        private final ShardsIterator shardsIt;
        private final InternalRequest internalRequest;
        private final DiscoveryNodes nodes;
        final /* synthetic */ TransportSingleCustomOperationAction this$0;

        private AsyncSingleAction(Request request, ActionListener<Response> listener) {
            this.this$0 = var1_1;
            this.listener = listener;
            ClusterState clusterState = var1_1.clusterService.state();
            this.nodes = clusterState.nodes();
            ClusterBlockException blockException = var1_1.checkGlobalBlock(clusterState);
            if (blockException != null) {
                throw blockException;
            }
            String concreteSingleIndex = var1_1.resolveIndex(request) ? clusterState.metaData().concreteSingleIndex(((SingleCustomOperationRequest)request).index(), ((SingleCustomOperationRequest)request).indicesOptions()) : ((SingleCustomOperationRequest)request).index();
            this.internalRequest = new InternalRequest((TransportSingleCustomOperationAction)var1_1, request, concreteSingleIndex);
            blockException = var1_1.checkRequestBlock(clusterState, this.internalRequest);
            if (blockException != null) {
                throw blockException;
            }
            this.shardsIt = var1_1.shards(clusterState, this.internalRequest);
        }

        public void start() {
            this.performFirst();
        }

        private void onFailure(ShardRouting shardRouting, Throwable e) {
            if (this.this$0.logger.isTraceEnabled() && e != null) {
                this.this$0.logger.trace(shardRouting.shortSummary() + ": Failed to execute [" + this.internalRequest.request() + "]", e, new Object[0]);
            }
            this.perform(e);
        }

        private void performFirst() {
            if (this.shardsIt == null) {
                if (((SingleCustomOperationRequest)this.internalRequest.request()).operationThreaded()) {
                    ((SingleCustomOperationRequest)this.internalRequest.request()).beforeLocalFork();
                    this.this$0.threadPool.executor(this.this$0.executor()).execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Object response = AsyncSingleAction.this.this$0.shardOperation(AsyncSingleAction.this.internalRequest.request(), null);
                                AsyncSingleAction.this.listener.onResponse(response);
                            }
                            catch (Throwable e) {
                                AsyncSingleAction.this.onFailure(null, e);
                            }
                        }
                    });
                    return;
                }
                try {
                    Object response = this.this$0.shardOperation(this.internalRequest.request(), null);
                    this.listener.onResponse(response);
                    return;
                }
                catch (Throwable e) {
                    this.onFailure(null, e);
                    return;
                }
            }
            if (((SingleCustomOperationRequest)this.internalRequest.request()).preferLocalShard()) {
                ShardRouting shardX;
                boolean foundLocal = false;
                while ((shardX = this.shardsIt.nextOrNull()) != null) {
                    final ShardRouting shard = shardX;
                    if (!shard.currentNodeId().equals(this.nodes.localNodeId())) continue;
                    foundLocal = true;
                    if (((SingleCustomOperationRequest)this.internalRequest.request()).operationThreaded()) {
                        ((SingleCustomOperationRequest)this.internalRequest.request()).beforeLocalFork();
                        this.this$0.threadPool.executor(this.this$0.executor()).execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Object response = AsyncSingleAction.this.this$0.shardOperation(AsyncSingleAction.this.internalRequest.request(), shard.shardId());
                                    AsyncSingleAction.this.listener.onResponse(response);
                                }
                                catch (Throwable e) {
                                    AsyncSingleAction.this.shardsIt.reset();
                                    AsyncSingleAction.this.onFailure(shard, e);
                                }
                            }
                        });
                        return;
                    }
                    try {
                        Object response = this.this$0.shardOperation(this.internalRequest.request(), shard.shardId());
                        this.listener.onResponse(response);
                        return;
                    }
                    catch (Throwable e) {
                        this.shardsIt.reset();
                        this.onFailure(shard, e);
                    }
                }
                if (!foundLocal) {
                    this.shardsIt.reset();
                    this.perform(null);
                }
            } else {
                this.perform(null);
            }
        }

        private void perform(Throwable lastException) {
            block12: {
                ShardRouting shard;
                ShardRouting shardRouting = shard = this.shardsIt == null ? null : this.shardsIt.nextOrNull();
                if (shard == null) {
                    Throwable failure = lastException;
                    if (failure == null) {
                        failure = new NoShardAvailableActionException(null, "No shard available for [" + this.internalRequest.request() + "]");
                    } else if (this.this$0.logger.isDebugEnabled()) {
                        this.this$0.logger.debug("failed to execute [" + this.internalRequest.request() + "]", failure, new Object[0]);
                    }
                    this.listener.onFailure(failure);
                } else if (shard.currentNodeId().equals(this.nodes.localNodeId())) {
                    if (!((SingleCustomOperationRequest)this.internalRequest.request()).preferLocalShard()) {
                        try {
                            if (((SingleCustomOperationRequest)this.internalRequest.request()).operationThreaded()) {
                                ((SingleCustomOperationRequest)this.internalRequest.request()).beforeLocalFork();
                                this.this$0.threadPool.executor(this.this$0.executor).execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            Object response = AsyncSingleAction.this.this$0.shardOperation(AsyncSingleAction.this.internalRequest.request(), shard.shardId());
                                            AsyncSingleAction.this.listener.onResponse(response);
                                        }
                                        catch (Throwable e) {
                                            AsyncSingleAction.this.onFailure(shard, e);
                                        }
                                    }
                                });
                                break block12;
                            }
                            Object response = this.this$0.shardOperation(this.internalRequest.request(), shard.shardId());
                            this.listener.onResponse(response);
                        }
                        catch (Throwable e) {
                            this.onFailure(shard, e);
                        }
                    } else {
                        this.perform(lastException);
                    }
                } else {
                    DiscoveryNode node = this.nodes.get(shard.currentNodeId());
                    this.this$0.transportService.sendRequest(node, this.this$0.transportShardAction, new ShardSingleOperationRequest(this.this$0, this.internalRequest.request(), shard.shardId()), new BaseTransportResponseHandler<Response>(){

                        @Override
                        public Response newInstance() {
                            return AsyncSingleAction.this.this$0.newResponse();
                        }

                        @Override
                        public String executor() {
                            return "same";
                        }

                        @Override
                        public void handleResponse(Response response) {
                            AsyncSingleAction.this.listener.onResponse(response);
                        }

                        @Override
                        public void handleException(TransportException exp) {
                            AsyncSingleAction.this.onFailure(shard, exp);
                        }
                    });
                }
            }
        }
    }
}

