/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queryparser.classic.MapperQueryParser;
import org.apache.lucene.queryparser.classic.QueryParserSettings;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.Bits;
import org.elasticsearch.Version;
import org.elasticsearch.cache.recycler.CacheRecycler;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.lucene.search.NoCacheFilter;
import org.elasticsearch.common.lucene.search.NoCacheQuery;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.lucene.search.ResolvableFilter;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.cache.fixedbitset.FixedBitSetFilter;
import org.elasticsearch.index.cache.query.parser.QueryParserCache;
import org.elasticsearch.index.engine.IndexEngine;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.core.StringFieldMapper;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.NestedScope;
import org.elasticsearch.index.search.child.CustomQueryWrappingFilter;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.fetch.innerhits.InnerHitsContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.lookup.SearchLookup;

public class QueryParseContext {
    private static ThreadLocal<String[]> typesContext = new ThreadLocal();
    private final Index index;
    private boolean propagateNoCache = false;
    private boolean requireCustomQueryWrappingFilter = false;
    private final IndexQueryParserService indexQueryParser;
    private final Map<String, Filter> namedFilters = Maps.newHashMap();
    private final MapperQueryParser queryParser = new MapperQueryParser(this);
    private XContentParser parser;
    private EnumSet<ParseField.Flag> parseFlags = ParseField.EMPTY_FLAGS;
    private final boolean disableFilterCaching;
    private boolean allowUnmappedFields;
    private boolean mapUnmappedFieldAsString;
    private NestedScope nestedScope;
    private SearchLookup lookup = null;

    public static void setTypes(String[] types) {
        typesContext.set(types);
    }

    public static String[] getTypes() {
        return typesContext.get();
    }

    public static String[] setTypesWithPrevious(String[] types) {
        String[] old = typesContext.get();
        QueryParseContext.setTypes(types);
        return old;
    }

    public static void removeTypes() {
        typesContext.remove();
    }

    public QueryParseContext(Index index, IndexQueryParserService indexQueryParser) {
        this(index, indexQueryParser, false);
    }

    public QueryParseContext(Index index, IndexQueryParserService indexQueryParser, boolean disableFilterCaching) {
        this.index = index;
        this.indexQueryParser = indexQueryParser;
        this.propagateNoCache = disableFilterCaching;
        this.disableFilterCaching = disableFilterCaching;
    }

    public void parseFlags(EnumSet<ParseField.Flag> parseFlags) {
        this.parseFlags = parseFlags == null ? ParseField.EMPTY_FLAGS : parseFlags;
    }

    public EnumSet<ParseField.Flag> parseFlags() {
        return this.parseFlags;
    }

    public void reset(XContentParser jp) {
        this.allowUnmappedFields = this.indexQueryParser.defaultAllowUnmappedFields();
        this.parseFlags = ParseField.EMPTY_FLAGS;
        this.lookup = null;
        this.parser = jp;
        this.namedFilters.clear();
        this.requireCustomQueryWrappingFilter = false;
        this.propagateNoCache = false;
        this.nestedScope = new NestedScope();
    }

    public Index index() {
        return this.index;
    }

    public void parser(XContentParser parser) {
        this.parser = parser;
    }

    public XContentParser parser() {
        return this.parser;
    }

    public IndexQueryParserService indexQueryParserService() {
        return this.indexQueryParser;
    }

    public AnalysisService analysisService() {
        return this.indexQueryParser.analysisService;
    }

    public CacheRecycler cacheRecycler() {
        return this.indexQueryParser.cacheRecycler;
    }

    public ScriptService scriptService() {
        return this.indexQueryParser.scriptService;
    }

    public MapperService mapperService() {
        return this.indexQueryParser.mapperService;
    }

    public IndexEngine indexEngine() {
        return this.indexQueryParser.indexEngine;
    }

    @Nullable
    public SimilarityService similarityService() {
        return this.indexQueryParser.similarityService;
    }

    public Similarity searchSimilarity() {
        return this.indexQueryParser.similarityService != null ? this.indexQueryParser.similarityService.similarity() : null;
    }

    public QueryParserCache queryParserCache() {
        return this.indexQueryParser.indexCache.queryParserCache();
    }

    public String defaultField() {
        return this.indexQueryParser.defaultField();
    }

    public boolean queryStringLenient() {
        return this.indexQueryParser.queryStringLenient();
    }

    public MapperQueryParser queryParser(QueryParserSettings settings) {
        this.queryParser.reset(settings);
        return this.queryParser;
    }

    public FixedBitSetFilter fixedBitSetFilter(Filter filter) {
        return this.indexQueryParser.fixedBitSetFilterCache.getFixedBitSetFilter(filter);
    }

    public Filter cacheFilter(Filter filter, final @Nullable CacheKeyFilter.Key cacheKey) {
        if (filter == null) {
            return null;
        }
        if (this.disableFilterCaching || this.propagateNoCache || filter instanceof NoCacheFilter) {
            return filter;
        }
        if (filter instanceof ResolvableFilter) {
            final ResolvableFilter resolvableFilter = (ResolvableFilter)filter;
            return new Filter(){

                public DocIdSet getDocIdSet(AtomicReaderContext atomicReaderContext, Bits bits) throws IOException {
                    Filter filter = resolvableFilter.resolve();
                    if (filter == null) {
                        return null;
                    }
                    if (cacheKey != null) {
                        filter = new CacheKeyFilter.Wrapper(filter, cacheKey);
                    }
                    filter = ((QueryParseContext)QueryParseContext.this).indexQueryParser.indexCache.filter().cache(filter);
                    return filter.getDocIdSet(atomicReaderContext, bits);
                }
            };
        }
        if (cacheKey != null) {
            filter = new CacheKeyFilter.Wrapper(filter, cacheKey);
        }
        return this.indexQueryParser.indexCache.filter().cache(filter);
    }

    public <IFD extends IndexFieldData<?>> IFD getForField(FieldMapper<?> mapper) {
        return this.indexQueryParser.fieldDataService.getForField(mapper);
    }

    public void addNamedFilter(String name, Filter filter) {
        this.namedFilters.put(name, filter);
    }

    public void addNamedQuery(String name, Query query) {
        this.namedFilters.put(name, Queries.wrap(query, this));
    }

    public ImmutableMap<String, Filter> copyNamedFilters() {
        return ImmutableMap.copyOf(this.namedFilters);
    }

    public void combineNamedFilters(QueryParseContext context) {
        this.namedFilters.putAll(context.namedFilters);
    }

    public void addInnerHits(String name, InnerHitsContext.BaseInnerHits context) {
        InnerHitsContext innerHitsContext;
        SearchContext sc = SearchContext.current();
        if (sc == null) {
            throw new QueryParsingException(this.index(), "inner_hits unsupported");
        }
        if (sc.innerHits() == null) {
            innerHitsContext = new InnerHitsContext(new HashMap<String, InnerHitsContext.BaseInnerHits>());
            sc.innerHits(innerHitsContext);
        } else {
            innerHitsContext = sc.innerHits();
        }
        innerHitsContext.addInnerHitDefinition(name, context);
    }

    @Nullable
    public Query parseInnerQuery() throws IOException, QueryParsingException {
        XContentParser.Token token;
        if (this.parser.currentToken() != XContentParser.Token.START_OBJECT && (token = this.parser.nextToken()) != XContentParser.Token.START_OBJECT) {
            throw new QueryParsingException(this.index, "[_na] query malformed, must start with start_object");
        }
        token = this.parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new QueryParsingException(this.index, "[_na] query malformed, no field after start_object");
        }
        String queryName = this.parser.currentName();
        token = this.parser.nextToken();
        if (token != XContentParser.Token.START_OBJECT && token != XContentParser.Token.START_ARRAY) {
            throw new QueryParsingException(this.index, "[_na] query malformed, no field after start_object");
        }
        QueryParser queryParser = this.indexQueryParser.queryParser(queryName);
        if (queryParser == null) {
            throw new QueryParsingException(this.index, "No query registered for [" + queryName + "]");
        }
        Query result = queryParser.parse(this);
        if (this.parser.currentToken() == XContentParser.Token.END_OBJECT || this.parser.currentToken() == XContentParser.Token.END_ARRAY) {
            this.parser.nextToken();
        }
        if (result instanceof NoCacheQuery) {
            this.propagateNoCache = true;
        }
        if (CustomQueryWrappingFilter.shouldUseCustomQueryWrappingFilter(result)) {
            this.requireCustomQueryWrappingFilter = true;
        }
        return result;
    }

    @Nullable
    public Filter parseInnerFilter() throws IOException, QueryParsingException {
        XContentParser.Token token;
        if (this.parser.currentToken() != XContentParser.Token.START_OBJECT && (token = this.parser.nextToken()) != XContentParser.Token.START_OBJECT) {
            throw new QueryParsingException(this.index, "[_na] filter malformed, must start with start_object");
        }
        token = this.parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            if (token == XContentParser.Token.END_OBJECT || token == XContentParser.Token.VALUE_NULL) {
                return null;
            }
            throw new QueryParsingException(this.index, "[_na] filter malformed, no field after start_object");
        }
        String filterName = this.parser.currentName();
        token = this.parser.nextToken();
        if (token != XContentParser.Token.START_OBJECT && token != XContentParser.Token.START_ARRAY) {
            throw new QueryParsingException(this.index, "[_na] filter malformed, no field after start_object");
        }
        FilterParser filterParser = this.indexQueryParser.filterParser(filterName);
        if (filterParser == null) {
            throw new QueryParsingException(this.index, "No filter registered for [" + filterName + "]");
        }
        Filter result = this.executeFilterParser(filterParser);
        if (this.parser.currentToken() == XContentParser.Token.END_OBJECT || this.parser.currentToken() == XContentParser.Token.END_ARRAY) {
            this.parser.nextToken();
        }
        return result;
    }

    public Filter parseInnerFilter(String filterName) throws IOException, QueryParsingException {
        FilterParser filterParser = this.indexQueryParser.filterParser(filterName);
        if (filterParser == null) {
            throw new QueryParsingException(this.index, "No filter registered for [" + filterName + "]");
        }
        return this.executeFilterParser(filterParser);
    }

    private Filter executeFilterParser(FilterParser filterParser) throws IOException {
        boolean propagateNoCache = this.propagateNoCache;
        this.propagateNoCache = false;
        Filter result = filterParser.parse(this);
        this.propagateNoCache |= result instanceof NoCacheFilter || propagateNoCache;
        return result;
    }

    public FieldMapper fieldMapper(String name) {
        FieldMappers fieldMappers = this.indexQueryParser.mapperService.smartNameFieldMappers(name, QueryParseContext.getTypes());
        if (fieldMappers == null) {
            return null;
        }
        return fieldMappers.mapper();
    }

    public String indexName(String name) {
        FieldMapper smartMapper = this.fieldMapper(name);
        if (smartMapper == null) {
            return name;
        }
        return smartMapper.names().indexName();
    }

    public List<String> simpleMatchToIndexNames(String pattern) {
        return this.indexQueryParser.mapperService.simpleMatchToIndexNames(pattern, QueryParseContext.getTypes());
    }

    public MapperService.SmartNameFieldMappers smartFieldMappers(String name) {
        return this.failIfFieldMappingNotFound(name, this.indexQueryParser.mapperService.smartName(name, QueryParseContext.getTypes()));
    }

    public MapperService.SmartNameObjectMapper smartObjectMapper(String name) {
        return this.indexQueryParser.mapperService.smartNameObjectMapper(name, QueryParseContext.getTypes());
    }

    public void setAllowUnmappedFields(boolean allowUnmappedFields) {
        this.allowUnmappedFields = allowUnmappedFields;
    }

    public void setMapUnmappedFieldAsString(boolean mapUnmappedFieldAsString) {
        this.mapUnmappedFieldAsString = mapUnmappedFieldAsString;
    }

    private MapperService.SmartNameFieldMappers failIfFieldMappingNotFound(String name, MapperService.SmartNameFieldMappers fieldMapping) {
        if (this.allowUnmappedFields) {
            return fieldMapping;
        }
        if (this.mapUnmappedFieldAsString) {
            StringFieldMapper.Builder builder = MapperBuilders.stringField(name);
            StringFieldMapper stringFieldMapper = builder.build(new Mapper.BuilderContext(ImmutableSettings.EMPTY, new ContentPath(1)));
            return new MapperService.SmartNameFieldMappers(this.mapperService(), new FieldMappers(stringFieldMapper), null, false);
        }
        Version indexCreatedVersion = this.indexQueryParser.getIndexCreatedVersion();
        if (fieldMapping == null && indexCreatedVersion.onOrAfter(Version.V_1_4_0_Beta1)) {
            throw new QueryParsingException(this.index, "Strict field resolution and no field mapping can be found for the field with name [" + name + "]");
        }
        return fieldMapping;
    }

    public Collection<String> queryTypes() {
        String[] types = QueryParseContext.getTypes();
        if (types == null || types.length == 0) {
            return this.mapperService().types();
        }
        if (types.length == 1 && types[0].equals("_all")) {
            return this.mapperService().types();
        }
        return Arrays.asList(types);
    }

    public SearchLookup lookup() {
        SearchContext current = SearchContext.current();
        if (current != null) {
            return current.lookup();
        }
        if (this.lookup == null) {
            this.lookup = new SearchLookup(this.mapperService(), this.indexQueryParser.fieldDataService, null);
        }
        return this.lookup;
    }

    public long nowInMillis() {
        SearchContext current = SearchContext.current();
        if (current != null) {
            return current.nowInMillis();
        }
        return System.currentTimeMillis();
    }

    public boolean requireCustomQueryWrappingFilter() {
        return this.requireCustomQueryWrappingFilter;
    }

    public NestedScope nestedScope() {
        return this.nestedScope;
    }
}

