/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.innerhits;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.fielddata.FieldDataFieldsParseElement;
import org.elasticsearch.search.fetch.innerhits.InnerHitsContext;
import org.elasticsearch.search.fetch.innerhits.InnerHitsParseElement;
import org.elasticsearch.search.fetch.script.ScriptFieldsParseElement;
import org.elasticsearch.search.fetch.source.FetchSourceParseElement;
import org.elasticsearch.search.highlight.HighlighterParseElement;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.InternalSearchHits;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.sort.SortParseElement;

public class InnerHitsFetchSubPhase
implements FetchSubPhase {
    private final SortParseElement sortParseElement;
    private final FetchSourceParseElement sourceParseElement;
    private final HighlighterParseElement highlighterParseElement;
    private final FieldDataFieldsParseElement fieldDataFieldsParseElement;
    private final ScriptFieldsParseElement scriptFieldsParseElement;
    private FetchPhase fetchPhase;

    @Inject
    public InnerHitsFetchSubPhase(SortParseElement sortParseElement, FetchSourceParseElement sourceParseElement, HighlighterParseElement highlighterParseElement, FieldDataFieldsParseElement fieldDataFieldsParseElement, ScriptFieldsParseElement scriptFieldsParseElement) {
        this.sortParseElement = sortParseElement;
        this.sourceParseElement = sourceParseElement;
        this.highlighterParseElement = highlighterParseElement;
        this.fieldDataFieldsParseElement = fieldDataFieldsParseElement;
        this.scriptFieldsParseElement = scriptFieldsParseElement;
    }

    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        return ImmutableMap.of("inner_hits", new InnerHitsParseElement(this.sortParseElement, this.sourceParseElement, this.highlighterParseElement, this.fieldDataFieldsParseElement, this.scriptFieldsParseElement));
    }

    @Override
    public boolean hitExecutionNeeded(SearchContext context) {
        return context.innerHits() != null;
    }

    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) throws ElasticsearchException {
        HashMap<String, InternalSearchHits> results = new HashMap<String, InternalSearchHits>();
        for (Map.Entry<String, InnerHitsContext.BaseInnerHits> entry : context.innerHits().getInnerHits().entrySet()) {
            TopDocs topDocs;
            InnerHitsContext.BaseInnerHits innerHits = entry.getValue();
            try {
                topDocs = innerHits.topDocs(context, hitContext);
            }
            catch (IOException e) {
                throw ExceptionsHelper.convertToElastic(e);
            }
            innerHits.queryResult().topDocs(topDocs);
            int[] docIdsToLoad = new int[topDocs.scoreDocs.length];
            for (int i = 0; i < topDocs.scoreDocs.length; ++i) {
                docIdsToLoad[i] = topDocs.scoreDocs[i].doc;
            }
            innerHits.docIdsToLoad(docIdsToLoad, 0, docIdsToLoad.length);
            this.fetchPhase.execute(innerHits);
            FetchSearchResult fetchResult = innerHits.fetchResult();
            InternalSearchHit[] internalHits = fetchResult.fetchResult().hits().internalHits();
            for (int i = 0; i < internalHits.length; ++i) {
                ScoreDoc scoreDoc = topDocs.scoreDocs[i];
                InternalSearchHit searchHitFields = internalHits[i];
                searchHitFields.shard(innerHits.shardTarget());
                searchHitFields.score(scoreDoc.score);
                if (!(scoreDoc instanceof FieldDoc)) continue;
                FieldDoc fieldDoc = (FieldDoc)scoreDoc;
                searchHitFields.sortValues(fieldDoc.fields);
            }
            results.put(entry.getKey(), fetchResult.hits());
        }
        hitContext.hit().setInnerHits(results);
    }

    @Override
    public boolean hitsExecutionNeeded(SearchContext context) {
        return false;
    }

    @Override
    public void hitsExecute(SearchContext context, InternalSearchHit[] hits) throws ElasticsearchException {
    }

    public void setFetchPhase(FetchPhase fetchPhase) {
        this.fetchPhase = fetchPhase;
    }
}

