/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.nodes;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public abstract class BaseNodesResponse<TNodeResponse extends BaseNodeResponse>
extends ActionResponse
implements Iterable<TNodeResponse> {
    private ClusterName clusterName;
    protected TNodeResponse[] nodes;
    private Map<String, TNodeResponse> nodesMap;

    protected BaseNodesResponse() {
    }

    protected BaseNodesResponse(ClusterName clusterName, TNodeResponse[] nodes) {
        this.clusterName = clusterName;
        this.nodes = nodes;
    }

    @Nullable
    public FailedNodeException[] failures() {
        return null;
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public String getClusterNameAsString() {
        return this.clusterName.value();
    }

    public TNodeResponse[] getNodes() {
        return this.nodes;
    }

    public TNodeResponse getAt(int position) {
        return this.nodes[position];
    }

    @Override
    public Iterator<TNodeResponse> iterator() {
        return this.getNodesMap().values().iterator();
    }

    public Map<String, TNodeResponse> getNodesMap() {
        if (this.nodesMap == null) {
            this.nodesMap = Maps.newHashMap();
            for (TNodeResponse nodeResponse : this.nodes) {
                this.nodesMap.put(((BaseNodeResponse)nodeResponse).getNode().id(), nodeResponse);
            }
        }
        return this.nodesMap;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.clusterName = ClusterName.readClusterName(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.clusterName.writeTo(out);
    }
}

