/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject.internal;

import com.google.common.base.Preconditions;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.matcher.Matcher;
import org.elasticsearch.common.inject.spi.TypeConverter;

public final class MatcherAndConverter {
    private final Matcher<? super TypeLiteral<?>> typeMatcher;
    private final TypeConverter typeConverter;
    private final Object source;

    public MatcherAndConverter(Matcher<? super TypeLiteral<?>> typeMatcher, TypeConverter typeConverter, Object source) {
        this.typeMatcher = (Matcher)Preconditions.checkNotNull(typeMatcher, (Object)"type matcher");
        this.typeConverter = (TypeConverter)Preconditions.checkNotNull((Object)typeConverter, (Object)"converter");
        this.source = source;
    }

    public TypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    public Matcher<? super TypeLiteral<?>> getTypeMatcher() {
        return this.typeMatcher;
    }

    public Object getSource() {
        return this.source;
    }

    public String toString() {
        return this.typeConverter + " which matches " + this.typeMatcher + " (bound at " + this.source + ")";
    }
}

