/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cookies {
    static HashMap<String, String> cachedCookies = null;
    static String rawCookies;

    public static String getCookie(String name) {
        HashMap<String, String> cookiesMap = Cookies.ensureCookies();
        return (String)cookiesMap.get(name);
    }

    public static Collection<String> getCookieNames() {
        return Cookies.ensureCookies().keySet();
    }

    public static native void removeCookie(String var0);

    public static void setCookie(String name, String value) {
        Cookies.setCookieImpl(name, value, 0.0, null, null, false);
    }

    public static void setCookie(String name, String value, Date expires) {
        Cookies.setCookie(name, value, expires, null, null, false);
    }

    public static void setCookie(String name, String value, Date expires, String domain, String path, boolean secure) {
        Cookies.setCookieImpl(name, value, expires == null ? 0.0 : (double)expires.getTime(), domain, path, secure);
    }

    static native void loadCookies(HashMap<String, String> var0);

    private static HashMap<String, String> ensureCookies() {
        if (cachedCookies == null || Cookies.needsRefresh()) {
            cachedCookies = new HashMap();
            Cookies.loadCookies(cachedCookies);
        }
        return cachedCookies;
    }

    private static native boolean needsRefresh();

    private static native void setCookieImpl(String var0, String var1, double var2, String var4, String var5, boolean var6);

    private Cookies() {
    }
}

