/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.AbstractXmlConfigHelper;
import com.hazelcast.config.AsymmetricEncryptionConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigBuilder;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.Interfaces;
import com.hazelcast.config.Join;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.impl.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlConfigBuilder
extends AbstractXmlConfigHelper
implements ConfigBuilder {
    private final ILogger logger = Logger.getLogger(XmlConfigBuilder.class.getName());
    private boolean domLevel3 = true;
    private Config config;
    private InputStream in;
    private File configurationFile;
    private URL configurationUrl;
    boolean usingSystemConfig = false;

    public XmlConfigBuilder(String xmlFileName) throws FileNotFoundException {
        this(new FileInputStream(xmlFileName));
    }

    public XmlConfigBuilder(InputStream inputStream) {
        this.in = inputStream;
    }

    public XmlConfigBuilder() {
        String configFile = System.getProperty("hazelcast.config");
        try {
            String msg;
            if (configFile != null) {
                this.configurationFile = new File(configFile);
                this.logger.log(Level.INFO, "Using configuration file at " + this.configurationFile.getAbsolutePath());
                if (!this.configurationFile.exists()) {
                    msg = "Config file at '" + this.configurationFile.getAbsolutePath() + "' doesn't exist.";
                    msg = msg + "\nHazelcast will try to use the hazelcast.xml config file in the working directory.";
                    this.logger.log(Level.WARNING, msg);
                    this.configurationFile = null;
                }
            }
            if (this.configurationFile == null) {
                configFile = "hazelcast.xml";
                this.configurationFile = new File("hazelcast.xml");
                if (!this.configurationFile.exists()) {
                    this.configurationFile = null;
                }
            }
            if (this.configurationFile != null) {
                this.logger.log(Level.INFO, "Using configuration file at " + this.configurationFile.getAbsolutePath());
                try {
                    this.in = new FileInputStream(this.configurationFile);
                    this.configurationUrl = this.configurationFile.toURI().toURL();
                    this.usingSystemConfig = true;
                }
                catch (Exception e) {
                    String msg2 = "Having problem reading config file at '" + configFile + "'.";
                    msg2 = msg2 + "\nException message: " + e.getMessage();
                    msg2 = msg2 + "\nHazelcast will try to use the hazelcast.xml config file in classpath.";
                    this.logger.log(Level.WARNING, msg2);
                    this.in = null;
                }
            }
            if (this.in == null) {
                this.logger.log(Level.INFO, "Looking for hazelcast.xml config file in classpath.");
                this.configurationUrl = Config.class.getClassLoader().getResource("hazelcast.xml");
                if (this.configurationUrl == null) {
                    this.configurationUrl = Config.class.getClassLoader().getResource("hazelcast-default.xml");
                    this.logger.log(Level.WARNING, "Could not find hazelcast.xml in classpath.\nHazelcast will use hazelcast-default.xml config file in jar.");
                    if (this.configurationUrl == null) {
                        this.logger.log(Level.WARNING, "Could not find hazelcast-default.xml in the classpath!\nThis may be due to a wrong-packaged or corrupted jar file.");
                        return;
                    }
                }
                this.logger.log(Level.INFO, "Using configuration file " + this.configurationUrl.getFile() + " in the classpath.");
                this.in = this.configurationUrl.openStream();
                if (this.in == null) {
                    msg = "Having problem reading config file hazelcast-default.xml in the classpath.";
                    msg = msg + "\nHazelcast will start with default configuration.";
                    this.logger.log(Level.WARNING, msg);
                }
            }
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "Error while creating configuration:" + e.getMessage(), e);
            e.printStackTrace();
        }
    }

    public Config build() {
        return this.build(new Config());
    }

    public Config build(Config config) {
        return this.build(config, null);
    }

    public Config build(Element element) {
        return this.build(new Config(), element);
    }

    Config build(Config config, Element element) {
        try {
            this.parse(config, element);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        config.setConfigurationFile(this.configurationFile);
        config.setConfigurationUrl(this.configurationUrl);
        return config;
    }

    private void parse(Config config, Element element) throws Exception {
        this.config = config;
        if (element == null) {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = null;
            try {
                doc = builder.parse(this.in);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Util.streamXML(doc, baos);
                byte[] bytes = baos.toByteArray();
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                config.setXmlConfig(Util.inputStreamToString(bais));
                if ("true".equals(System.getProperty("hazelcast.config.print"))) {
                    this.logger.log(Level.INFO, "Hazelcast config URL : " + config.getConfigurationUrl());
                    this.logger.log(Level.INFO, "=== Hazelcast config xml ===");
                    this.logger.log(Level.INFO, config.getXmlConfig());
                    this.logger.log(Level.INFO, "==============================");
                    this.logger.log(Level.INFO, "");
                }
            }
            catch (Exception e) {
                String msgPart = "config file '" + config.getConfigurationFile() + "' set as a system property.";
                if (!this.usingSystemConfig) {
                    msgPart = "hazelcast-default.xml config file in the classpath.";
                }
                String msg = "Having problem parsing the " + msgPart;
                msg = msg + "\nException: " + e.getMessage();
                msg = msg + "\nHazelcast will start with default configuration.";
                this.logger.log(Level.WARNING, msg);
                return;
            }
            element = doc.getDocumentElement();
        }
        try {
            element.getTextContent();
        }
        catch (Throwable e) {
            this.domLevel3 = false;
        }
        this.handleConfig(element);
    }

    private boolean checkTrue(String value) {
        return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value);
    }

    private void handleConfig(Element docElement) throws Exception {
        for (Node node : new AbstractXmlConfigHelper.IterableNodeList(docElement.getChildNodes())) {
            String nodeName = this.cleanNodeName(node.getNodeName());
            if ("network".equals(nodeName)) {
                this.handleNetwork(node);
                continue;
            }
            if ("group".equals(nodeName)) {
                this.handleGroup(node);
                continue;
            }
            if ("properties".equals(nodeName)) {
                this.handleProperties(node, this.config.getProperties());
                continue;
            }
            if ("executor-service".equals(nodeName)) {
                this.handleExecutor(node);
                continue;
            }
            if ("queue".equals(nodeName)) {
                this.handleQueue(node);
                continue;
            }
            if ("map".equals(nodeName)) {
                this.handleMap(node);
                continue;
            }
            if ("topic".equals(nodeName)) {
                this.handleTopic(node);
                continue;
            }
            if (!"merge-policies".equals(nodeName)) continue;
            this.handleMergePolicies(node);
        }
    }

    public void handleNetwork(Node node) throws Exception {
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = this.cleanNodeName(child.getNodeName());
            if ("port".equals(nodeName)) {
                this.handlePort(child);
                continue;
            }
            if ("join".equals(nodeName)) {
                this.handleJoin(child);
                continue;
            }
            if ("interfaces".equals(nodeName)) {
                this.handleInterfaces(child);
                continue;
            }
            if ("symmetric-encryption".equals(nodeName)) {
                this.handleViaReflection(child, this.config.getNetworkConfig(), new SymmetricEncryptionConfig());
                continue;
            }
            if (!"asymmetric-encryption".equals(nodeName)) continue;
            this.handleViaReflection(child, this.config.getNetworkConfig(), new AsymmetricEncryptionConfig());
        }
    }

    private int getIntegerValue(String parameterName, String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            this.logger.log(Level.INFO, parameterName + " parameter value, [" + value + "], is not a proper integer. Default value, [" + defaultValue + "], will be used!");
            e.printStackTrace();
            return defaultValue;
        }
    }

    protected String getTextContent(Node node) {
        if (this.domLevel3) {
            return node.getTextContent();
        }
        return this.getTextContent2(node);
    }

    public void handleExecutor(Node node) throws Exception {
        ExecutorConfig executorConfig = new ExecutorConfig();
        this.handleViaReflection(node, this.config, executorConfig);
    }

    public void handleGroup(Node node) {
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String value = this.getTextContent(n).trim();
            String nodeName = this.cleanNodeName(n.getNodeName());
            if ("name".equals(nodeName)) {
                this.config.getGroupConfig().setName(value);
                continue;
            }
            if (!"password".equals(nodeName)) continue;
            this.config.getGroupConfig().setPassword(value);
        }
    }

    public void handleProperties(Node node, Properties properties) {
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String name = this.cleanNodeName(n.getNodeName());
            String propertyName = "property".equals(name) ? this.getTextContent(n.getAttributes().getNamedItem("name")).trim() : name;
            String value = this.getTextContent(n).trim();
            properties.setProperty(propertyName, value);
        }
    }

    private void handleInterfaces(Node node) {
        String value;
        NamedNodeMap atts = node.getAttributes();
        Interfaces interfaces = this.config.getNetworkConfig().getInterfaces();
        for (int a = 0; a < atts.getLength(); ++a) {
            Node att = atts.item(a);
            if (!"enabled".equals(att.getNodeName())) continue;
            value = att.getNodeValue();
            interfaces.setEnabled(this.checkTrue(value));
        }
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            if (!"interface".equalsIgnoreCase(this.cleanNodeName(n.getNodeName()))) continue;
            value = this.getTextContent(n).trim();
            interfaces.addInterface(value);
        }
    }

    private void handleViaReflection(Node node, Object parent, Object target) throws Exception {
        NamedNodeMap atts = node.getAttributes();
        if (atts != null) {
            for (int a = 0; a < atts.getLength(); ++a) {
                Node att = atts.item(a);
                String methodName = "set" + this.getMethodName(att.getNodeName());
                Method method = this.getMethod(target, methodName);
                String value = att.getNodeValue();
                this.invoke(target, method, value);
            }
        }
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String value = this.getTextContent(n).trim();
            String methodName = "set" + this.getMethodName(this.cleanNodeName(n.getNodeName()));
            Method method = this.getMethod(target, methodName);
            this.invoke(target, method, value);
        }
        String mName = "set" + target.getClass().getSimpleName();
        Method method = this.getMethod(parent, mName);
        if (method == null) {
            mName = "add" + target.getClass().getSimpleName();
            method = this.getMethod(parent, mName);
        }
        method.invoke(parent, target);
    }

    private void invoke(Object target, Method method, String value) {
        if (method == null) {
            return;
        }
        Class<?>[] args = method.getParameterTypes();
        if (args == null || args.length == 0) {
            return;
        }
        Class<?> arg = method.getParameterTypes()[0];
        try {
            if (arg == String.class) {
                method.invoke(target, value);
            } else if (arg == Integer.TYPE) {
                method.invoke(target, Integer.parseInt(value));
            } else if (arg == Long.TYPE) {
                method.invoke(target, Long.parseLong(value));
            } else if (arg == Boolean.TYPE) {
                method.invoke(target, Boolean.parseBoolean(value));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Method getMethod(Object target, String methodName) {
        Method[] methods;
        for (Method method : methods = target.getClass().getMethods()) {
            if (!method.getName().equalsIgnoreCase(methodName)) continue;
            return method;
        }
        return null;
    }

    private String getMethodName(String element) {
        StringBuilder sb = new StringBuilder();
        char[] chars = element.toCharArray();
        boolean upper = true;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '_' || c == '-' || c == '.') {
                upper = true;
                continue;
            }
            if (upper) {
                sb.append(Character.toUpperCase(c));
                upper = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private void handleJoin(Node node) {
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String name = this.cleanNodeName(child.getNodeName());
            if ("multicast".equals(name)) {
                this.handleMulticast(child);
                continue;
            }
            if (!"tcp-ip".equals(name)) continue;
            this.handleTcpIp(child);
        }
    }

    private void handleMulticast(Node node) {
        String value;
        NamedNodeMap atts = node.getAttributes();
        Join join = this.config.getNetworkConfig().getJoin();
        for (int a = 0; a < atts.getLength(); ++a) {
            Node att = atts.item(a);
            value = this.getTextContent(att).trim();
            if (!"enabled".equalsIgnoreCase(att.getNodeName())) continue;
            join.getMulticastConfig().setEnabled(this.checkTrue(value));
        }
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            value = this.getTextContent(n).trim();
            if ("multicast-group".equals(this.cleanNodeName(n.getNodeName()))) {
                join.getMulticastConfig().setMulticastGroup(value);
                continue;
            }
            if ("multicast-port".equals(this.cleanNodeName(n.getNodeName()))) {
                join.getMulticastConfig().setMulticastPort(Integer.parseInt(value));
                continue;
            }
            if (!"multicast-timeout-seconds".equals(this.cleanNodeName(n.getNodeName()))) continue;
            join.getMulticastConfig().setMulticastTimeoutSeconds(Integer.parseInt(value));
        }
    }

    private void handlePort(Node node) {
        String portStr = this.getTextContent(node).trim();
        if (portStr != null && portStr.length() > 0) {
            this.config.setPort(Integer.parseInt(portStr));
        }
        NamedNodeMap atts = node.getAttributes();
        for (int a = 0; a < atts.getLength(); ++a) {
            Node att = atts.item(a);
            String value = this.getTextContent(att).trim();
            if (!att.getNodeName().equals("auto-increment")) continue;
            this.config.setPortAutoIncrement(this.checkTrue(value));
        }
    }

    public void handleQueue(Node node) {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        QueueConfig qConfig = new QueueConfig();
        qConfig.setName(name);
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = this.cleanNodeName(n.getNodeName());
            String value = this.getTextContent(n).trim();
            if ("max-size-per-jvm".equals(nodeName)) {
                qConfig.setMaxSizePerJVM(this.getIntegerValue("max-size-per-jvm", value, 0));
                continue;
            }
            if (!"time-to-live-seconds".equals(nodeName)) continue;
            qConfig.setTimeToLiveSeconds(this.getIntegerValue("time-to-live-seconds", value, 0));
        }
        this.config.addQueueConfig(qConfig);
    }

    public void handleMap(Node node) throws Exception {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        MapConfig mapConfig = new MapConfig();
        mapConfig.setName(name);
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = this.cleanNodeName(n.getNodeName());
            String value = this.getTextContent(n).trim();
            if ("backup-count".equals(nodeName)) {
                mapConfig.setBackupCount(this.getIntegerValue("backup-count", value, 1));
                continue;
            }
            if ("eviction-policy".equals(nodeName)) {
                mapConfig.setEvictionPolicy(value);
                continue;
            }
            if ("max-size".equals(nodeName)) {
                mapConfig.setMaxSize(this.getIntegerValue("max-size", value, Integer.MAX_VALUE));
                continue;
            }
            if ("eviction-percentage".equals(nodeName)) {
                mapConfig.setEvictionPercentage(this.getIntegerValue("eviction-percentage", value, 25));
                continue;
            }
            if ("eviction-delay-seconds".equals(nodeName)) {
                mapConfig.setEvictionDelaySeconds(this.getIntegerValue("eviction-delay-seconds", value, 3));
                continue;
            }
            if ("time-to-live-seconds".equals(nodeName)) {
                mapConfig.setTimeToLiveSeconds(this.getIntegerValue("time-to-live-seconds", value, 0));
                continue;
            }
            if ("max-idle-seconds".equals(nodeName)) {
                mapConfig.setMaxIdleSeconds(this.getIntegerValue("max-idle-seconds", value, 0));
                continue;
            }
            if ("map-store".equals(nodeName)) {
                MapStoreConfig mapStoreConfig = this.createMapStoreConfig(n);
                mapConfig.setMapStoreConfig(mapStoreConfig);
                continue;
            }
            if ("near-cache".equals(nodeName)) {
                this.handleViaReflection(n, mapConfig, new NearCacheConfig());
                continue;
            }
            if ("merge-policy".equals(nodeName)) {
                mapConfig.setMergePolicy(value);
                continue;
            }
            if ("cache-value".equals(nodeName)) {
                mapConfig.setCacheValue(this.checkTrue(value));
                continue;
            }
            if (!"read-backup-data".equals(nodeName)) continue;
            mapConfig.setReadBackupData(this.checkTrue(value));
        }
        this.config.addMapConfig(mapConfig);
    }

    private MapStoreConfig createMapStoreConfig(Node node) {
        MapStoreConfig mapStoreConfig = new MapStoreConfig();
        NamedNodeMap atts = node.getAttributes();
        for (int a = 0; a < atts.getLength(); ++a) {
            Node att = atts.item(a);
            String value = this.getTextContent(att).trim();
            if (!att.getNodeName().equals("enabled")) continue;
            mapStoreConfig.setEnabled(this.checkTrue(value));
        }
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = this.cleanNodeName(n.getNodeName());
            String value = this.getTextContent(n).trim();
            if ("class-name".equals(nodeName)) {
                mapStoreConfig.setClassName(value);
                continue;
            }
            if (!"write-delay-seconds".equals(nodeName)) continue;
            mapStoreConfig.setWriteDelaySeconds(this.getIntegerValue("write-delay-seconds", value, 0));
        }
        this.handleProperties(node, mapStoreConfig.getProperties());
        return mapStoreConfig;
    }

    private void handleTcpIp(Node node) {
        NamedNodeMap atts = node.getAttributes();
        Join join = this.config.getNetworkConfig().getJoin();
        for (int a = 0; a < atts.getLength(); ++a) {
            Node att = atts.item(a);
            String value = this.getTextContent(att).trim();
            if (att.getNodeName().equals("enabled")) {
                join.getTcpIpConfig().setEnabled(this.checkTrue(value));
                continue;
            }
            if (!att.getNodeName().equals("conn-timeout-seconds")) continue;
            join.getTcpIpConfig().setConnectionTimeoutSeconds(this.getIntegerValue("conn-timeout-seconds", value, 5));
        }
        NodeList nodelist = node.getChildNodes();
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node n = nodelist.item(i);
            String value = this.getTextContent(n).trim();
            if (this.cleanNodeName(n.getNodeName()).equals("required-member")) {
                join.getTcpIpConfig().setRequiredMember(value);
                continue;
            }
            if (this.cleanNodeName(n.getNodeName()).equals("hostname")) {
                join.getTcpIpConfig().addMember(value);
                continue;
            }
            if (this.cleanNodeName(n.getNodeName()).equals("address")) {
                int colonIndex = value.indexOf(58);
                if (colonIndex == -1) {
                    this.logger.log(Level.WARNING, "Address should be in the form of ip:port. Address [" + value + "] is not valid.");
                    continue;
                }
                String hostStr = value.substring(0, colonIndex);
                String portStr = value.substring(colonIndex + 1);
                try {
                    join.getTcpIpConfig().addAddress(new Address(hostStr, Integer.parseInt(portStr), true));
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("interface".equals(this.cleanNodeName(n.getNodeName()))) {
                join.getTcpIpConfig().addMember(value);
                continue;
            }
            if ("member".equals(this.cleanNodeName(n.getNodeName()))) {
                join.getTcpIpConfig().addMember(value);
                continue;
            }
            if (!"members".equals(this.cleanNodeName(n.getNodeName()))) continue;
            join.getTcpIpConfig().addMember(value);
        }
    }

    public void handleTopic(Node node) {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        TopicConfig tConfig = new TopicConfig();
        tConfig.setName(name);
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String value = this.getTextContent(n).trim();
            if (!this.cleanNodeName(n.getNodeName()).equals("global-ordering-enabled")) continue;
            tConfig.setGlobalOrderingEnabled(this.checkTrue(value));
        }
        this.config.addTopicConfig(tConfig);
    }

    public void handleMergePolicies(Node node) throws Exception {
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = this.cleanNodeName(n.getNodeName());
            if (!nodeName.equals("map-merge-policy")) continue;
            this.handleViaReflection(n, this.config, new MergePolicyConfig());
        }
    }
}

