/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.impl.CallContext;
import com.hazelcast.impl.ThreadContext;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class AsyncCall
implements Future,
Runnable {
    private static final Object NULL = new Object();
    private final BlockingQueue responseQ = new LinkedBlockingQueue();
    private final CallContext callContext = ThreadContext.get().getCallContext();
    private volatile Object result = null;

    protected abstract void call();

    public void run() {
        try {
            ThreadContext.get().setCallContext(this.callContext);
            this.call();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setResult(Object obj) {
        if (obj == null) {
            obj = NULL;
        }
        this.result = obj;
        this.responseQ.offer(obj);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    public boolean isCancelled() {
        return false;
    }

    public boolean isDone() {
        return false;
    }

    public Object get() throws InterruptedException, ExecutionException {
        Object r = this.result;
        if (r == null) {
            r = this.responseQ.take();
        }
        return this.processResult(r);
    }

    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Object r = this.result;
        if (r == null) {
            r = this.responseQ.poll(timeout, unit);
        }
        if (r == null) {
            throw new TimeoutException();
        }
        return this.processResult(r);
    }

    private Object processResult(Object result) throws ExecutionException {
        if (result == NULL) {
            return null;
        }
        if (result instanceof Throwable) {
            throw new ExecutionException((Throwable)result);
        }
        return result;
    }
}

