/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.ascii.rest;

import com.hazelcast.impl.Node;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.ascii.TextCommandService;
import com.hazelcast.impl.ascii.rest.HttpCommandProcessor;
import com.hazelcast.impl.ascii.rest.HttpGetCommand;
import com.hazelcast.impl.ascii.rest.RestValue;
import com.hazelcast.nio.ConnectionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpGetCommandProcessor
extends HttpCommandProcessor<HttpGetCommand> {
    public HttpGetCommandProcessor(TextCommandService textCommandService) {
        super(textCommandService);
    }

    @Override
    public void handle(HttpGetCommand command) {
        String uri = command.getURI();
        if (uri.startsWith("/hazelcast/rest/maps/")) {
            String key;
            int indexEnd = uri.indexOf(47, "/hazelcast/rest/maps/".length());
            String mapName = uri.substring("/hazelcast/rest/maps/".length(), indexEnd);
            Object value = this.textCommandService.get(mapName, key = uri.substring(indexEnd + 1));
            if (value == null) {
                command.send204();
            } else if (value instanceof byte[]) {
                command.setResponse(null, (byte[])value);
            } else if (value instanceof RestValue) {
                RestValue restValue = (RestValue)value;
                command.setResponse(restValue.getContentType(), restValue.getValue());
            } else {
                command.setResponse(ThreadContext.get().toByteArray(value));
            }
        } else if (uri.startsWith("/hazelcast/rest/cluster")) {
            Node node = this.textCommandService.getNode();
            StringBuilder res = new StringBuilder(node.getClusterImpl().toString());
            res.append("\n");
            ConnectionManager connectionManager = node.getConnectionManager();
            res.append("ConnectionCount: " + connectionManager.getCurrentClientConnections());
            res.append("\n");
            res.append("AllConnectionCount: " + connectionManager.getAllTextConnections());
            res.append("\n");
            command.setResponse(null, res.toString().getBytes());
        } else {
            command.send400();
        }
        this.textCommandService.sendResponse(command);
    }

    @Override
    public void handleRejection(HttpGetCommand command) {
        this.handle(command);
    }
}

