/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.base;

import com.hazelcast.core.MapEntry;
import com.hazelcast.impl.Record;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DataRecordEntry
implements DataSerializable,
MapEntry {
    private long cost = 0L;
    private long expirationTime = 0L;
    private long lastAccessTime = 0L;
    private long lastUpdateTime = 0L;
    private long creationTime = 0L;
    private long version = 0L;
    private int hits = 0;
    private boolean valid = true;
    private String name = null;
    private Data keyData = null;
    private Data valueData = null;
    private Long[] indexes;
    private byte[] indexTypes;
    private Object key = null;
    private Object value = null;

    public DataRecordEntry() {
    }

    public DataRecordEntry(Record record) {
        this(record, record.getValueData());
    }

    public DataRecordEntry(Record record, Data value) {
        this.cost = record.getCost();
        this.expirationTime = record.getExpirationTime();
        this.lastAccessTime = record.getLastAccessTime();
        this.lastUpdateTime = record.getLastUpdateTime();
        this.creationTime = record.getCreationTime();
        this.version = record.getVersion();
        this.hits = record.getHits();
        this.valid = record.isValid();
        this.name = record.getName();
        this.keyData = record.getKeyData();
        this.valueData = value;
        this.indexes = record.getIndexes();
        this.indexTypes = record.getIndexTypes();
    }

    public void writeData(DataOutput out) throws IOException {
        long now = System.currentTimeMillis();
        out.writeLong(this.cost);
        out.writeLong(this.expirationTime - now);
        out.writeLong(this.lastAccessTime - now);
        out.writeLong(this.lastUpdateTime - now);
        out.writeLong(this.creationTime - now);
        out.writeLong(this.version);
        out.writeInt(this.hits);
        out.writeUTF(this.name);
        this.keyData.writeData(out);
        this.valueData.writeData(out);
        int indexCount = (byte)(this.indexes == null ? 0 : (byte)this.indexes.length);
        out.write(indexCount);
        for (int i = 0; i < indexCount; i = (int)((byte)(i + 1))) {
            out.writeLong(this.indexes[i]);
            out.write(this.indexTypes[i]);
        }
    }

    public void readData(DataInput in) throws IOException {
        long now = System.currentTimeMillis();
        this.cost = in.readLong();
        this.expirationTime = in.readLong() + now;
        this.lastAccessTime = in.readLong() + now;
        this.lastUpdateTime = in.readLong() + now;
        this.creationTime = in.readLong() + now;
        this.version = in.readLong();
        this.hits = in.readInt();
        this.name = in.readUTF();
        this.keyData = new Data();
        this.keyData.readData(in);
        this.valueData = new Data();
        this.valueData.readData(in);
        byte indexCount = in.readByte();
        if (indexCount > 0) {
            this.indexes = new Long[indexCount];
            this.indexTypes = new byte[indexCount];
            for (byte i = 0; i < indexCount; i = (byte)(i + 1)) {
                this.indexes[i] = in.readLong();
                this.indexTypes[i] = in.readByte();
            }
        }
    }

    public Object setValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public long getCost() {
        return this.cost;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public int getHits() {
        return this.hits;
    }

    public Object getKey() {
        if (this.key == null) {
            this.key = IOUtil.toObject(this.keyData);
        }
        return this.key;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public String getName() {
        return this.name;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean hasValue() {
        return this.valueData != null || this.value != null;
    }

    public Object getValue() {
        if (this.value == null) {
            this.value = IOUtil.toObject(this.valueData);
        }
        return this.value;
    }

    public long getVersion() {
        return this.version;
    }

    public Data getKeyData() {
        return this.keyData;
    }

    public Data getValueData() {
        return this.valueData;
    }
}

