/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.config.QueueConfig;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.IMap;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.MapEntry;
import com.hazelcast.impl.BaseManager;
import com.hazelcast.impl.CMap;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.Constants;
import com.hazelcast.impl.FallThroughRunnable;
import com.hazelcast.impl.Keys;
import com.hazelcast.impl.ListenerManager;
import com.hazelcast.impl.LocalQueueStatsImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.Request;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.TransactionImpl;
import com.hazelcast.impl.base.PacketProcessor;
import com.hazelcast.impl.base.RuntimeInterruptedException;
import com.hazelcast.impl.base.ScheduledAction;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class BlockingQueueManager
extends BaseManager {
    private static final long BILLION = 1000000000L;
    boolean addKeyAsync = false;
    final Map<String, BQ> mapBQ = new HashMap<String, BQ>();
    MasterState state = MasterState.NOT_INITIALIZED;

    BlockingQueueManager(Node node) {
        super(node);
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_ITERATE, new InitializationAwareOperationHandler(){

            void doOperation(BQ queue, Request request) {
                queue.iterate(request);
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_SIZE, new InitializationAwareOperationHandler(){

            void doOperation(BQ queue, Request request) {
                queue.size(request);
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_TAKE_KEY, new BaseManager.ResponsiveOperationHandler(){

            public void handle(Request request) {
                BlockingQueueManager.this.handleTakeKey(request);
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_PEEK_KEY, new BaseManager.ResponsiveOperationHandler(){

            public void handle(Request request) {
                BlockingQueueManager.this.handlePeekKey(request);
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_ADD_KEY, new BaseManager.ResponsiveOperationHandler(){

            public void handle(Request request) {
                BlockingQueueManager.this.handleAddKey(request);
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_REMOVE_KEY, new InitializationAwareOperationHandler(){

            void doOperation(BQ queue, Request request) {
                queue.removeKey(request);
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_GENERATE_KEY, new BaseManager.ResponsiveOperationHandler(){

            public void handle(Request request) {
                BlockingQueueManager.this.handleGenerateKey(request);
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_OFFER_KEY, new PacketProcessor(){

            public void process(Packet packet) {
                BlockingQueueManager.this.handleOfferKey(packet);
            }
        });
    }

    public void destroy(String name) {
        this.mapBQ.remove(name);
    }

    private void sendKeyToMaster(final String queueName, final Data key, final boolean last) {
        this.enqueueAndReturn(new Processable(){

            public void process() {
                if (BlockingQueueManager.this.isMaster()) {
                    BlockingQueueManager.this.doAddKey(queueName, key, last);
                } else {
                    Packet packet = BlockingQueueManager.this.obtainPacket();
                    packet.name = queueName;
                    packet.setKey(key);
                    packet.operation = ClusterOperation.BLOCKING_OFFER_KEY;
                    packet.longValue = last ? 0L : 1L;
                    boolean bl = BlockingQueueManager.this.send(packet, BlockingQueueManager.this.getMasterAddress());
                }
            }
        });
    }

    public int size(String name) {
        ThreadContext threadContext = ThreadContext.get();
        TransactionImpl txn = threadContext.getCallContext().getTransaction();
        int size = this.queueSize(name);
        if (txn != null && txn.getStatus() == 1) {
            size += txn.size(name);
        }
        return size;
    }

    public boolean offer(String name, Object obj, long timeout) throws InterruptedException {
        Long key = this.generateKey(name, timeout);
        ThreadContext threadContext = ThreadContext.get();
        TransactionImpl txn = threadContext.getCallContext().getTransaction();
        if (key != -1L) {
            if (txn != null && txn.getStatus() == 1) {
                txn.attachPutOp(name, key, obj, timeout, true);
            } else {
                this.storeQueueItem(name, key, obj, true);
            }
            return true;
        }
        return false;
    }

    public void offerCommit(String name, Object key, Object obj) {
        this.storeQueueItem(name, key, obj, true);
    }

    public void rollbackPoll(String name, Object key, Object obj) {
        this.storeQueueItem(name, key, obj, false);
    }

    private void storeQueueItem(String name, Object key, Object obj, boolean last) {
        IMap imap = this.getStorageMap(name);
        Data dataKey = IOUtil.toData(key);
        imap.put(dataKey, obj);
        if (this.addKeyAsync) {
            this.sendKeyToMaster(name, dataKey, last);
        } else {
            this.addKey(name, dataKey, last);
        }
    }

    public Object poll(String name, long timeout) throws InterruptedException {
        if (timeout == -1L) {
            timeout = Long.MAX_VALUE;
        }
        Object removedItem = null;
        long start = System.currentTimeMillis();
        while (removedItem == null && timeout >= 0L) {
            Data key = this.takeKey(name, timeout);
            if (key == null) {
                return null;
            }
            IMap imap = this.getStorageMap(name);
            try {
                ThreadContext threadContext;
                TransactionImpl txn;
                removedItem = imap.tryRemove(key, 0L, TimeUnit.MILLISECONDS);
                if (removedItem != null && (txn = (threadContext = ThreadContext.get()).getCallContext().getTransaction()) != null && txn.getStatus() == 1) {
                    txn.attachRemoveOp(name, key, removedItem, true);
                }
            }
            catch (TimeoutException e) {
                // empty catch block
            }
            long now = System.currentTimeMillis();
            timeout -= now - start;
            start = now;
        }
        return removedItem;
    }

    public Object peek(String name) {
        Data key = this.peekKey(name);
        if (key == null) {
            return null;
        }
        IMap imap = this.getStorageMap(name);
        return imap.get(key);
    }

    private Data takeKey(String name, long timeout) throws InterruptedException {
        try {
            MasterOp op = new MasterOp(ClusterOperation.BLOCKING_TAKE_KEY, name, timeout);
            op.initOp();
            return (Data)op.getResultAsIs();
        }
        catch (Exception e) {
            if (e instanceof RuntimeInterruptedException) {
                throw new InterruptedException();
            }
            return null;
        }
    }

    private Data peekKey(String name) {
        MasterOp op = new MasterOp(ClusterOperation.BLOCKING_PEEK_KEY, name, 0L);
        op.initOp();
        return (Data)op.getResultAsIs();
    }

    public IMap getStorageMap(String queueName) {
        return this.node.factory.getMap(queueName);
    }

    CMap getStorageCMap(String queueName) {
        return this.node.concurrentMapManager.getMap("c:" + queueName);
    }

    public Iterator iterate(final String name) {
        MasterOp op = new MasterOp(ClusterOperation.BLOCKING_ITERATE, name, 0L);
        op.initOp();
        Keys keys = (Keys)op.getResultAsObject();
        Collection<Data> dataKeys = keys.getKeys();
        ArrayList<Data> allKeys = new ArrayList<Data>(dataKeys);
        TransactionImpl txn = ThreadContext.get().getCallContext().getTransaction();
        Map txnOfferItems = null;
        if (txn != null && (txnOfferItems = txn.newKeys(name)) != null) {
            allKeys.addAll(txnOfferItems.keySet());
        }
        final Map txnMap = txnOfferItems;
        final Iterator it = allKeys.iterator();
        final IMap imap = this.getStorageMap(name);
        return new Iterator(){
            Object key = null;
            Object next = null;
            boolean hasNext = false;
            boolean set = false;

            public boolean hasNext() {
                if (!this.set) {
                    this.set();
                }
                boolean result = this.hasNext;
                this.hasNext = false;
                this.set = false;
                return result;
            }

            public Object next() {
                if (!this.set) {
                    this.set();
                }
                Object result = this.next;
                this.set = false;
                this.next = null;
                return result;
            }

            public void remove() {
                if (this.key != null) {
                    try {
                        Data dataKey = IOUtil.toData(this.key);
                        imap.tryRemove(dataKey, 0L, TimeUnit.MILLISECONDS);
                        BlockingQueueManager.this.removeKey(name, dataKey);
                    }
                    catch (TimeoutException timeoutException) {
                        // empty catch block
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void set() {
                try {
                    while (this.next == null) {
                        this.hasNext = it.hasNext();
                        if (this.hasNext) {
                            this.key = it.next();
                            if (txnMap != null) {
                                this.next = txnMap.get(this.key);
                            }
                            if (this.next != null) continue;
                            this.next = imap.get(this.key);
                            continue;
                        }
                        return;
                    }
                }
                finally {
                    this.set = true;
                }
            }
        };
    }

    public boolean addKey(String name, Data key, boolean last) {
        MasterOp op = new MasterOp(ClusterOperation.BLOCKING_ADD_KEY, name, 0L);
        op.request.key = key;
        op.request.setBooleanRequest();
        op.request.longValue = last ? 0L : 1L;
        op.initOp();
        return op.getResultAsBoolean();
    }

    public boolean removeKey(String name, Data key) {
        MasterOp op = new MasterOp(ClusterOperation.BLOCKING_REMOVE_KEY, name, 0L);
        op.request.key = key;
        op.request.setBooleanRequest();
        op.initOp();
        return op.getResultAsBoolean();
    }

    public long generateKey(String name, long timeout) throws InterruptedException {
        try {
            MasterOp op = new MasterOp(ClusterOperation.BLOCKING_GENERATE_KEY, name, timeout);
            op.request.setLongRequest();
            op.initOp();
            return (Long)op.getResultAsObject();
        }
        catch (Exception e) {
            if (e instanceof RuntimeInterruptedException) {
                throw new InterruptedException();
            }
            return -1L;
        }
    }

    public int queueSize(String name) {
        MasterOp op = new MasterOp(ClusterOperation.BLOCKING_SIZE, name, 0L);
        op.request.setLongRequest();
        op.initOp();
        return ((Long)op.getResultAsObject()).intValue();
    }

    long getKey(String queueName) {
        return this.node.factory.getIdGenerator(queueName).newId();
    }

    BQ getOrCreateBQ(String name) {
        BQ bq = this.mapBQ.get(name);
        if (bq == null) {
            bq = new BQ(name);
            this.mapBQ.put(name, bq);
        }
        return bq;
    }

    final void handleTakeKey(Request req) {
        if (this.isMaster() && this.ready()) {
            BQ bq = this.getOrCreateBQ(req.name);
            bq.doTakeKey(req);
        } else {
            this.returnRedoResponse(req);
        }
    }

    final void handlePeekKey(Request req) {
        if (this.isMaster() && this.ready()) {
            BQ bq = this.getOrCreateBQ(req.name);
            bq.doPeekKey(req);
        } else {
            this.returnRedoResponse(req);
        }
    }

    final void handleOfferKey(Packet packet) {
        if (this.isMaster()) {
            this.doAddKey(packet.name, packet.getKeyData(), packet.longValue == 0L);
        }
        this.releasePacket(packet);
    }

    final void doAddKey(String name, Data key, boolean last) {
        BQ bq = this.getOrCreateBQ(name);
        bq.doAddKey(key, last);
    }

    final void handleAddKey(Request req) {
        if (this.isMaster() && this.ready()) {
            BQ bq = this.getOrCreateBQ(req.name);
            bq.doAddKey(req.key, req.longValue == 0L);
            req.key = null;
            req.response = Boolean.TRUE;
            this.returnResponse(req);
        } else {
            this.returnRedoResponse(req);
        }
    }

    final void handleGenerateKey(Request req) {
        if (this.isMaster() && this.ready()) {
            BQ bq = this.getOrCreateBQ(req.name);
            bq.doGenerateKey(req);
        } else {
            this.returnRedoResponse(req);
        }
    }

    boolean ready() {
        if (this.state != MasterState.READY) {
            if (this.isVeryFirstMember()) {
                this.state = MasterState.READY;
                return true;
            }
            if (this.state == MasterState.NOT_INITIALIZED) {
                this.state = MasterState.INITIALIZING;
                this.initialize();
            }
            return false;
        }
        return true;
    }

    void initialize() {
        this.checkServiceThread();
        this.executeLocally(new FallThroughRunnable(){

            public void doRun() {
                Set<String> instanceNames = BlockingQueueManager.this.node.factory.getLongInstanceNames();
                final HashMap queueKeys = new HashMap();
                for (String instanceName : instanceNames) {
                    Set keys;
                    if (!instanceName.startsWith("q:") || (keys = BlockingQueueManager.this.getStorageMap(instanceName).keySet()).size() <= 0) continue;
                    queueKeys.put(instanceName, new TreeSet(keys));
                }
                BlockingQueueManager.this.enqueueAndReturn(new Processable(){

                    public void process() {
                        Set queueNames = queueKeys.keySet();
                        for (String queueName : queueNames) {
                            BQ q = BlockingQueueManager.this.getOrCreateBQ(queueName);
                            Set keys = (Set)queueKeys.get(queueName);
                            if (keys == null) continue;
                            for (Long key : keys) {
                                Data keyData = IOUtil.toData(key);
                                q.keys.add(keyData);
                                q.queue.add(new QData(keyData));
                                q.nextKey = Math.max(q.nextKey, key);
                            }
                            q.nextKey += 1000000000L;
                        }
                        BlockingQueueManager.this.state = MasterState.READY;
                    }
                });
            }
        });
    }

    public void addItemListener(String name, ItemListener listener, boolean includeValue) {
        IMap map = this.getStorageMap(name);
        map.addEntryListener(new QueueItemListener(listener, includeValue), includeValue);
    }

    public void removeItemListener(String name, ItemListener listener) {
        List<ListenerManager.ListenerItem> lsListenerItems = this.node.listenerManager.getListeners();
        for (ListenerManager.ListenerItem listenerItem : lsListenerItems) {
            if (!(listenerItem.listener instanceof QueueItemListener)) continue;
            QueueItemListener queueListener = (QueueItemListener)listenerItem.listener;
            if (queueListener.itemListener != listener) continue;
            this.node.listenerManager.getListeners().remove(listenerItem);
            return;
        }
    }

    class QData {
        final Data data;
        final long createDate;

        QData(Data data) {
            this.data = data;
            this.createDate = System.currentTimeMillis();
        }
    }

    class BQ {
        final List<ScheduledAction> offerWaitList = new ArrayList<ScheduledAction>(1000);
        final List<ScheduledAction> pollWaitList = new ArrayList<ScheduledAction>(1000);
        final List<Lease> leases = new ArrayList<Lease>(1000);
        final Set<Data> keys = new HashSet<Data>(1000);
        final LinkedList<QData> queue = new LinkedList();
        final int maxSizePerJVM;
        final long ttl;
        final String name;
        long nextKey = 0L;

        BQ(String name) {
            this.name = name;
            QueueConfig qConfig = BlockingQueueManager.this.node.getConfig().getQueueConfig(name.substring("q:".length()));
            this.maxSizePerJVM = qConfig.getMaxSizePerJVM() == 0 ? Integer.MAX_VALUE : qConfig.getMaxSizePerJVM();
            this.ttl = qConfig.getTimeToLiveSeconds() == 0 ? Integer.MAX_VALUE : TimeUnit.SECONDS.toMillis(qConfig.getTimeToLiveSeconds());
        }

        int maxSize() {
            return this.maxSizePerJVM == Integer.MAX_VALUE ? Integer.MAX_VALUE : this.maxSizePerJVM * BlockingQueueManager.this.lsMembers.size();
        }

        void doGenerateKey(Request req) {
            if (this.size() >= this.maxSize()) {
                if (req.hasEnoughTimeToSchedule()) {
                    this.addOfferAction(new OfferAction(req));
                } else {
                    req.response = -1L;
                    BlockingQueueManager.this.returnResponse(req);
                }
            } else {
                this.generateKeyAndLease(req);
                BlockingQueueManager.this.returnResponse(req);
            }
        }

        void size(Request req) {
            req.response = (long)this.queue.size();
            BlockingQueueManager.this.returnResponse(req);
        }

        void generateKeyAndLease(Request req) {
            this.leases.add(new Lease(req.caller));
            req.response = this.nextKey++;
        }

        void offerKey(Request req) {
            if (this.size() > this.maxSize()) {
                req.response = Constants.Objects.OBJECT_REDO;
            } else {
                this.leases.add(new Lease(req.caller));
                req.response = Boolean.TRUE;
            }
            BlockingQueueManager.this.returnResponse(req);
        }

        void doAddKey(Data key, boolean last) {
            if (this.keys.add(key)) {
                if (this.leases.size() > 0) {
                    this.leases.remove(0);
                }
                if (last) {
                    this.queue.offer(new QData(key));
                } else {
                    this.queue.addFirst(new QData(key));
                }
                this.takeOne();
            }
        }

        public void removeKey(Request request) {
            if (this.keys.remove(request.key)) {
                Iterator it = this.queue.iterator();
                while (it.hasNext()) {
                    QData qData = (QData)it.next();
                    if (!qData.data.equals(request.key)) continue;
                    it.remove();
                    request.response = Boolean.TRUE;
                    break;
                }
            }
            if (request.response == null) {
                request.response = Boolean.FALSE;
            }
            BlockingQueueManager.this.returnResponse(request);
        }

        void takeOne() {
            while (this.pollWaitList.size() > 0) {
                ScheduledAction scheduledActionPoll = this.pollWaitList.remove(0);
                if (scheduledActionPoll.expired() || !scheduledActionPoll.isValid()) continue;
                scheduledActionPoll.consume();
                return;
            }
        }

        void offerOne() {
            while (this.offerWaitList.size() > 0) {
                ScheduledAction scheduledActionOffer = this.offerWaitList.remove(0);
                if (scheduledActionOffer.expired() || !scheduledActionOffer.isValid()) continue;
                scheduledActionOffer.consume();
                return;
            }
        }

        QData pollValidItem() {
            QData qdata = this.queue.poll();
            if (qdata == null) {
                return null;
            }
            long now = System.currentTimeMillis();
            if (this.isValid(qdata, now)) {
                return qdata;
            }
            while (qdata != null) {
                qdata = this.queue.poll();
                if (!this.isValid(qdata, now)) continue;
                return qdata;
            }
            return qdata;
        }

        boolean isValid(QData qdata, long now) {
            return qdata != null && now - qdata.createDate < this.ttl;
        }

        void doTakeKey(Request req) {
            QData qdata = this.pollValidItem();
            if (qdata != null) {
                this.keys.remove(qdata.data);
                req.response = qdata.data;
                BlockingQueueManager.this.returnResponse(req);
                this.offerOne();
            } else if (req.hasEnoughTimeToSchedule()) {
                this.addPollAction(new PollAction(req));
            } else {
                req.response = null;
                BlockingQueueManager.this.returnResponse(req);
            }
        }

        void doPeekKey(Request req) {
            QData qdata = this.queue.peek();
            req.response = qdata == null ? null : qdata.data;
            BlockingQueueManager.this.returnResponse(req);
        }

        void addPollAction(PollAction pollAction) {
            this.pollWaitList.add(pollAction);
            BlockingQueueManager.this.node.clusterManager.registerScheduledAction(pollAction);
        }

        void addOfferAction(OfferAction offerAction) {
            this.offerWaitList.add(offerAction);
            BlockingQueueManager.this.node.clusterManager.registerScheduledAction(offerAction);
        }

        public int size() {
            return this.queue.size() + this.leases.size();
        }

        public void iterate(Request request) {
            Keys keys = new Keys();
            for (QData qData : this.queue) {
                keys.addKey(qData.data);
            }
            request.response = keys;
            BlockingQueueManager.this.returnResponse(request);
        }

        public int getMaxSizePerJVM() {
            return this.maxSizePerJVM;
        }

        public LocalQueueStatsImpl getQueueStats() {
            long now = System.currentTimeMillis();
            CMap cmap = BlockingQueueManager.this.getStorageCMap(this.name);
            IMap storageMap = BlockingQueueManager.this.getStorageMap(this.name);
            Set localKeys = storageMap.localKeySet();
            int total = cmap.mapRecords.size();
            int ownedCount = localKeys.size();
            int backupCount = Math.abs(total - ownedCount);
            long minAge = Long.MAX_VALUE;
            long maxAge = Long.MIN_VALUE;
            long totalAge = 0L;
            for (Object localKey : localKeys) {
                MapEntry entry = storageMap.getMapEntry(localKey);
                if (entry == null) continue;
                long age = now - entry.getCreationTime();
                minAge = Math.min(minAge, age);
                maxAge = Math.max(maxAge, age);
                totalAge += age;
            }
            long aveAge = ownedCount == 0 ? 0L : totalAge / (long)ownedCount;
            return new LocalQueueStatsImpl(ownedCount, backupCount, minAge, maxAge, aveAge);
        }

        public class PollAction
        extends ScheduledAction {
            public PollAction(Request request) {
                super(request);
            }

            public boolean consume() {
                BQ.this.doTakeKey(this.request);
                this.setValid(false);
                return true;
            }

            public void onExpire() {
                this.request.response = null;
                BlockingQueueManager.this.returnResponse(this.request);
                this.setValid(false);
            }
        }

        public class OfferAction
        extends ScheduledAction {
            public OfferAction(Request request) {
                super(request);
            }

            public boolean consume() {
                BQ.this.generateKeyAndLease(this.request);
                BlockingQueueManager.this.returnResponse(this.request);
                this.setValid(false);
                return true;
            }

            public void onExpire() {
                this.request.response = -1L;
                BlockingQueueManager.this.returnResponse(this.request);
                this.setValid(false);
            }
        }
    }

    class QueueItemListener
    implements EntryListener {
        final ItemListener itemListener;
        final boolean includeValue;

        QueueItemListener(ItemListener itemListener, boolean includeValue) {
            this.includeValue = includeValue;
            this.itemListener = itemListener;
        }

        public void entryAdded(EntryEvent entryEvent) {
            Object item = this.includeValue ? (Object)entryEvent.getValue() : null;
            this.itemListener.itemAdded(item);
        }

        public void entryRemoved(EntryEvent entryEvent) {
            Object item = this.includeValue ? (Object)entryEvent.getValue() : null;
            this.itemListener.itemRemoved(item);
        }

        public void entryUpdated(EntryEvent entryEvent) {
        }

        public void entryEvicted(EntryEvent entryEvent) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MasterState {
        NOT_INITIALIZED,
        INITIALIZING,
        READY;

    }

    class Lease {
        final long timeout;
        final Address address;

        Lease(Address address) {
            this.address = address;
            this.timeout = System.currentTimeMillis() + 10000L;
        }
    }

    class MasterOp
    extends BaseManager.TargetAwareOp {
        private final ClusterOperation op;
        private final String name;
        private final long timeout;

        MasterOp(ClusterOperation op, String name, long timeout) {
            this.op = op;
            this.name = name;
            this.timeout = timeout;
        }

        public void setTarget() {
            this.target = BlockingQueueManager.this.getMasterAddress();
        }

        void initOp() {
            this.request.operation = this.op;
            this.request.name = this.name;
            this.request.timeout = this.timeout;
            this.doOp();
        }
    }

    abstract class InitializationAwareOperationHandler
    extends BaseManager.ResponsiveOperationHandler {
        InitializationAwareOperationHandler() {
        }

        abstract void doOperation(BQ var1, Request var2);

        public void handle(Request request) {
            if (BlockingQueueManager.this.isMaster() && BlockingQueueManager.this.ready()) {
                BQ bq = BlockingQueueManager.this.getOrCreateBQ(request.name);
                this.doOperation(bq, request);
            } else {
                BlockingQueueManager.this.returnRedoResponse(request);
            }
        }
    }
}

