/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.impl.Node;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.SelectionHandler;
import com.hazelcast.nio.SelectorBase;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;

public final class InSelector
extends SelectorBase {
    final ServerSocketChannel serverSocketChannel;
    final SelectionKey key;

    public InSelector(Node node, ServerSocketChannel serverSocketChannel) {
        super(node, 64);
        this.serverSocketChannel = serverSocketChannel;
        SelectionKey sKey = null;
        try {
            sKey = serverSocketChannel.register(this.selector, 16, new Acceptor());
        }
        catch (ClosedChannelException e) {
            e.printStackTrace();
        }
        this.key = sKey;
        this.logger.log(Level.FINEST, "Started Selector at " + serverSocketChannel.socket().getLocalPort());
        this.selector.wakeup();
    }

    public void publishUtilization() {
        this.node.getCpuUtilization().inThread = this.threadWatcher.publish();
    }

    public void threadLocalShutdown() {
        try {
            if (this.serverSocketChannel != null) {
                this.serverSocketChannel.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class Acceptor
    implements SelectionHandler {
        private Acceptor() {
        }

        public void handle() {
            try {
                SocketChannel channel = InSelector.this.serverSocketChannel.accept();
                InSelector.this.logger.log(Level.INFO, channel.socket().getLocalPort() + " is accepting socket connection from " + channel.socket().getRemoteSocketAddress());
                InSelector.this.initSocket(channel.socket());
                channel.configureBlocking(false);
                Connection connection = InSelector.this.createConnection(channel, true);
                channel.register(InSelector.this.selector, 1, connection.getReadHandler());
                InSelector.this.serverSocketChannel.register(InSelector.this.selector, 16, this);
                InSelector.this.selector.wakeup();
                InSelector.this.logger.log(Level.INFO, channel.socket().getLocalPort() + " is accepted socket connection from " + channel.socket().getRemoteSocketAddress());
            }
            catch (Exception e) {
                InSelector.this.logger.log(Level.FINEST, e.getMessage(), e);
                try {
                    InSelector.this.serverSocketChannel.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                InSelector.this.node.shutdown();
            }
        }
    }
}

