/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.impl.CallContext;
import com.hazelcast.impl.ClientService;
import com.hazelcast.impl.FallThroughRunnable;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.nio.Packet;

public class ClientRequestHandler
extends FallThroughRunnable {
    private final Packet packet;
    private final CallContext callContext;
    private final Node node;
    private final ClientService.ClientOperationHandler clientOperationHandler;

    public ClientRequestHandler(Node node, Packet packet, CallContext callContext, ClientService.ClientOperationHandler clientOperationHandler) {
        this.packet = packet;
        this.callContext = callContext;
        this.node = node;
        this.clientOperationHandler = clientOperationHandler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doRun() {
        ThreadContext.get().setCallContext(this.callContext);
        if (this.clientOperationHandler != null) {
            try {
                this.clientOperationHandler.handle(this.node, this.packet);
                return;
            }
            catch (Throwable e) {
                if (!this.node.isActive()) return;
                throw (RuntimeException)e;
            }
        } else {
            if (!this.node.isActive()) return;
            throw new RuntimeException("Unknown Client Operation, can not handle " + (Object)((Object)this.packet.operation));
        }
    }
}

