/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ResponseQueueFactory {
    public static BlockingQueue newResponseQueue() {
        return new LockBasedResponseQueue();
    }

    private static final class ResponseQueue
    extends AbstractQueue
    implements BlockingQueue {
        volatile Object response;
        final Object lock = new Object();

        private ResponseQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object take() throws InterruptedException {
            while (this.response == null) {
                Object object = this.lock;
                synchronized (object) {
                    while (this.response == null) {
                        this.lock.wait();
                    }
                }
            }
            return this.response;
        }

        public boolean offer(Object o, long timeout, TimeUnit unit) throws InterruptedException {
            return this.offer(o);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
            if (timeout < 0L) {
                throw new IllegalArgumentException();
            }
            if (timeout == 0L) {
                return this.response;
            }
            long remaining = unit.toMillis(timeout);
            while (this.response == null && remaining > 0L) {
                Object object = this.lock;
                synchronized (object) {
                    while (this.response == null) {
                        long start = System.currentTimeMillis();
                        this.lock.wait(remaining);
                        remaining -= System.currentTimeMillis() - start;
                    }
                }
            }
            return this.response;
        }

        public void put(Object o) throws InterruptedException {
            this.offer(o);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean offer(Object obj) {
            if (this.response != null) {
                return false;
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.response != null) {
                    return false;
                }
                this.response = obj;
                this.lock.notify();
            }
            return true;
        }

        public Object poll() {
            return this.response;
        }

        public int remainingCapacity() {
            throw new UnsupportedOperationException();
        }

        public int drainTo(Collection c) {
            throw new UnsupportedOperationException();
        }

        public int drainTo(Collection c, int maxElements) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            this.response = null;
        }

        public Iterator iterator() {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.response == null ? 0 : 1;
        }

        public Object peek() {
            return this.response;
        }
    }

    private static final class LockBasedResponseQueue
    extends AbstractQueue
    implements BlockingQueue {
        private Object response = null;
        private final Lock lock = new ReentrantLock();
        private final Condition noValue = this.lock.newCondition();
        private static final Object NULL = new Object();

        private LockBasedResponseQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object take() throws InterruptedException {
            this.lock.lock();
            try {
                while (this.response == null) {
                    this.noValue.await();
                }
                Object object = this.getAndRemoveResponse();
                return object;
            }
            finally {
                this.lock.unlock();
            }
        }

        public boolean offer(Object o, long timeout, TimeUnit unit) throws InterruptedException {
            return this.offer(o);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
            if (timeout < 0L) {
                throw new IllegalArgumentException();
            }
            this.lock.lock();
            try {
                long start;
                if (timeout == 0L) {
                    Object object = this.response;
                    return object;
                }
                for (long remaining = unit.toMillis(timeout); this.response == null && remaining > 0L; remaining -= System.currentTimeMillis() - start) {
                    start = System.currentTimeMillis();
                    this.noValue.await(remaining, TimeUnit.MILLISECONDS);
                }
                Object object = this.getAndRemoveResponse();
                return object;
            }
            finally {
                this.lock.unlock();
            }
        }

        public void put(Object o) throws InterruptedException {
            this.offer(o);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean offer(Object obj) {
            if (obj == null) {
                obj = NULL;
            }
            this.lock.lock();
            try {
                if (this.response != null) {
                    boolean bl = false;
                    return bl;
                }
                this.response = obj;
                this.noValue.signal();
                boolean bl = true;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object poll() {
            this.lock.lock();
            try {
                Object object = this.getAndRemoveResponse();
                return object;
            }
            finally {
                this.lock.unlock();
            }
        }

        private Object getAndRemoveResponse() {
            Object value = this.response;
            this.response = null;
            return value == NULL ? null : value;
        }

        public int remainingCapacity() {
            throw new UnsupportedOperationException();
        }

        public int drainTo(Collection c) {
            throw new UnsupportedOperationException();
        }

        public int drainTo(Collection c, int maxElements) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            this.lock.lock();
            try {
                this.response = null;
            }
            finally {
                this.lock.unlock();
            }
        }

        public Iterator iterator() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            this.lock.lock();
            try {
                int n = this.response == null ? 0 : 1;
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object peek() {
            this.lock.lock();
            try {
                Object object = this.response;
                return object;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

