/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.NearCacheConfig;

public class MapConfig {
    public static final int MIN_BACKUP_COUNT = 0;
    public static final int DEFAULT_BACKUP_COUNT = 1;
    public static final int MAX_BACKUP_COUNT = 3;
    public static final int MIN_EVICTION_PERCENTAGE = 0;
    public static final int DEFAULT_EVICTION_PERCENTAGE = 25;
    public static final int MAX_EVICTION_PERCENTAGE = 100;
    public static final int DEFAULT_EVICTION_DELAY_SECONDS = 3;
    public static final int DEFAULT_TTL_SECONDS = 0;
    public static final int DEFAULT_MAX_IDLE_SECONDS = 0;
    public static final int DEFAULT_MAX_SIZE = Integer.MAX_VALUE;
    public static final String DEFAULT_EVICTION_POLICY = "NONE";
    public static final String DEFAULT_MERGE_POLICY = "hz.ADD_NEW_ENTRY";
    private String name = null;
    private int backupCount = 1;
    private int evictionPercentage = 25;
    private int timeToLiveSeconds = 0;
    private int maxIdleSeconds = 0;
    private int evictionDelaySeconds = 3;
    private int maxSize = Integer.MAX_VALUE;
    private String evictionPolicy = "NONE";
    private boolean valueIndexed = false;
    private MapStoreConfig mapStoreConfig = null;
    private NearCacheConfig nearCacheConfig = null;
    private String mergePolicy = "hz.ADD_NEW_ENTRY";

    public String getName() {
        return this.name;
    }

    public MapConfig setName(String name) {
        this.name = name;
        return this;
    }

    public boolean isValueIndexed() {
        return this.valueIndexed;
    }

    public void setValueIndexed(boolean valueIndexed) {
        this.valueIndexed = valueIndexed;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public MapConfig setBackupCount(int backupCount) {
        if (backupCount < 0 || backupCount > 3) {
            throw new IllegalArgumentException("map backup count must be 0, 1, 2 or 3");
        }
        this.backupCount = backupCount;
        return this;
    }

    public int getEvictionPercentage() {
        return this.evictionPercentage;
    }

    public MapConfig setEvictionPercentage(int evictionPercentage) {
        if (evictionPercentage < 0) {
            throw new IllegalArgumentException("eviction percentage must be greater or equal than 0");
        }
        if (evictionPercentage > 100) {
            throw new IllegalArgumentException("eviction percentage must be smaller or equal than 100");
        }
        this.evictionPercentage = evictionPercentage;
        return this;
    }

    public int getEvictionDelaySeconds() {
        return this.evictionDelaySeconds;
    }

    public MapConfig setEvictionDelaySeconds(int evictionDelaySeconds) {
        this.evictionDelaySeconds = evictionDelaySeconds;
        return this;
    }

    public int getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public MapConfig setTimeToLiveSeconds(int timeToLiveSeconds) {
        this.timeToLiveSeconds = timeToLiveSeconds;
        return this;
    }

    public int getMaxIdleSeconds() {
        return this.maxIdleSeconds;
    }

    public MapConfig setMaxIdleSeconds(int maxIdleSeconds) {
        this.maxIdleSeconds = maxIdleSeconds;
        return this;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public MapConfig setMaxSize(int maxSize) {
        if (maxSize < 0) {
            throw new IllegalArgumentException("map max size must be greater than 0");
        }
        this.maxSize = maxSize;
        return this;
    }

    public String getEvictionPolicy() {
        return this.evictionPolicy;
    }

    public MapConfig setEvictionPolicy(String evictionPolicy) {
        this.evictionPolicy = evictionPolicy;
        return this;
    }

    public MapStoreConfig getMapStoreConfig() {
        return this.mapStoreConfig;
    }

    public MapConfig setMapStoreConfig(MapStoreConfig mapStoreConfig) {
        this.mapStoreConfig = mapStoreConfig;
        return this;
    }

    public NearCacheConfig getNearCacheConfig() {
        return this.nearCacheConfig;
    }

    public MapConfig setNearCacheConfig(NearCacheConfig nearCacheConfig) {
        this.nearCacheConfig = nearCacheConfig;
        return this;
    }

    public String getMergePolicy() {
        return this.mergePolicy;
    }

    public MapConfig setMergePolicy(String mergePolicyName) {
        this.mergePolicy = mergePolicyName;
        return this;
    }

    public String toString() {
        return "MapConfig{name='" + this.name + '\'' + ", backupCount=" + this.backupCount + ", mergePolicy=" + this.mergePolicy + ", evictionPercentage=" + this.evictionPercentage + ", timeToLiveSeconds=" + this.timeToLiveSeconds + ", maxIdleSeconds=" + this.maxIdleSeconds + ", evictionDelaySeconds=" + this.evictionDelaySeconds + ", maxSize=" + this.maxSize + ", evictionPolicy='" + this.evictionPolicy + '\'' + ", mapStoreConfig=" + this.mapStoreConfig + ", nearCacheConfig=" + this.nearCacheConfig + '}';
    }
}

