/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.Member;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.impl.AsyncCall;
import com.hazelcast.impl.BaseManager;
import com.hazelcast.impl.CallContext;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.Constants;
import com.hazelcast.impl.ExecutionManagerCallback;
import com.hazelcast.impl.ExecutorThreadFactory;
import com.hazelcast.impl.GroupProperties;
import com.hazelcast.impl.InnerFutureTask;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.NamedExecutorService;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.Request;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.executor.ParallelExecutor;
import com.hazelcast.impl.executor.ParallelExecutorService;
import com.hazelcast.impl.monitor.ExecutorOperationsCounter;
import com.hazelcast.impl.monitor.LocalExecutorOperationStatsImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.partition.Partition;
import com.hazelcast.security.SecureCallable;
import com.hazelcast.util.Clock;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutorManager
extends BaseManager {
    private final ConcurrentMap<String, NamedExecutorService> mapExecutors = new ConcurrentHashMap<String, NamedExecutorService>(10);
    private final ConcurrentMap<Thread, CallContext> mapThreadCallContexts = new ConcurrentHashMap<Thread, CallContext>(100);
    private final ParallelExecutor mapLoaderExecutorService;
    private final ParallelExecutor asyncExecutorService;
    private final NamedExecutorService defaultExecutorService;
    private final NamedExecutorService queryExecutorService;
    private final NamedExecutorService eventExecutorService;
    private final NamedExecutorService mapStoreExecutorService;
    private volatile boolean started = false;
    private static final String DEFAULT_EXECUTOR_SERVICE = "x:default";
    private static final String QUERY_EXECUTOR_SERVICE = "x:hz.query";
    private static final String STORE_EXECUTOR_SERVICE = "x:hz.store";
    private static final String EVENT_EXECUTOR_SERVICE = "x:hz.events";
    private final Object CREATE_LOCK = new Object();
    private final ParallelExecutorService parallelExecutorService;
    private final ThreadPoolExecutor threadPoolExecutor;
    private final ConcurrentMap<ExecutionKey, RequestExecutor> executions = new ConcurrentHashMap<ExecutionKey, RequestExecutor>(100);
    private final ScheduledThreadPoolExecutor esScheduled;
    private final ConcurrentMap<String, ExecutorOperationsCounter> internalThroughputMap = new ConcurrentHashMap<String, ExecutorOperationsCounter>();
    private final ConcurrentMap<String, ExecutorOperationsCounter> throughputMap = new ConcurrentHashMap<String, ExecutorOperationsCounter>();
    final AtomicLong executionIdGen = new AtomicLong();
    private final int interval = 60000;

    ExecutorManager(Node node) {
        super(node);
        this.logger.log(Level.FINEST, "Starting ExecutorManager");
        GroupProperties gp = node.groupProperties;
        ClassLoader classLoader = node.getConfig().getClassLoader();
        ExecutorThreadFactory.ThreadCleanup cleanup = new ExecutorThreadFactory.ThreadCleanup(){

            public void cleanup(Thread t) {
                ExecutorManager.this.mapThreadCallContexts.remove(t);
            }
        };
        this.threadPoolExecutor = new ThreadPoolExecutor(5, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue(), new ExecutorThreadFactory(node.threadGroup, node.getThreadPoolNamePrefix("cached"), classLoader, cleanup), new RejectionHandler()){

            protected void beforeExecute(Thread t, Runnable r) {
                ExecutorManager.this.threadPoolBeforeExecute(t, r);
            }
        };
        this.esScheduled = new ScheduledThreadPoolExecutor(3, new ExecutorThreadFactory(node.threadGroup, node.getThreadPoolNamePrefix("scheduled"), classLoader, cleanup), new RejectionHandler()){

            protected void beforeExecute(Thread t, Runnable r) {
                ExecutorManager.this.threadPoolBeforeExecute(t, r);
            }
        };
        this.parallelExecutorService = new ParallelExecutorService(node.getLogger(ParallelExecutorService.class.getName()), this.threadPoolExecutor);
        this.defaultExecutorService = this.getOrCreateNamedExecutorService(DEFAULT_EXECUTOR_SERVICE);
        this.mapStoreExecutorService = this.getOrCreateNamedExecutorService(STORE_EXECUTOR_SERVICE);
        this.queryExecutorService = this.getOrCreateNamedExecutorService(QUERY_EXECUTOR_SERVICE, gp.EXECUTOR_QUERY_THREAD_COUNT, gp.EXECUTOR_QUERY_QUEUE_CAPACITY.getInteger(), gp.EXECUTOR_QUERY_QUEUE_TIMEOUT_MILLIS.getInteger());
        this.eventExecutorService = this.getOrCreateNamedExecutorService(EVENT_EXECUTOR_SERVICE, gp.EXECUTOR_EVENT_THREAD_COUNT, gp.EXECUTOR_EVENT_QUEUE_CAPACITY.getInteger(), gp.EXECUTOR_EVENT_QUEUE_TIMEOUT_MILLIS.getInteger());
        this.mapLoaderExecutorService = this.parallelExecutorService.newParallelExecutor(gp.MAP_LOAD_THREAD_COUNT.getInteger(), gp.MAP_LOAD_QUEUE_CAPACITY.getInteger(), gp.MAP_LOAD_QUEUE_TIMEOUT_MILLIS.getInteger());
        this.asyncExecutorService = this.parallelExecutorService.newBlockingParallelExecutor(gp.EXECUTOR_ASYNC_THREAD_COUNT.getInteger(), gp.EXECUTOR_ASYNC_QUEUE_CAPACITY.getInteger(), gp.EXECUTOR_ASYNC_QUEUE_TIMEOUT_MILLIS.getInteger());
        this.newNamedExecutorService("x:hz.initialization", new ExecutorConfig("hz.initialization", Integer.MAX_VALUE, Integer.MAX_VALUE, 60));
        this.registerPacketProcessor(ClusterOperation.EXECUTE, new ExecutionOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CANCEL_EXECUTION, new ExecutionCancelOperationHandler());
        this.started = true;
    }

    public Statistics getStatistics() {
        return new Statistics(this);
    }

    public NamedExecutorService getOrCreateNamedExecutorService(String name) {
        return this.getOrCreateNamedExecutorService(name, null);
    }

    public ScheduledThreadPoolExecutor getScheduledExecutorService() {
        return this.esScheduled;
    }

    public ParallelExecutor getMapLoaderExecutorService() {
        return this.mapLoaderExecutorService;
    }

    public NamedExecutorService getMapStoreExecutorService() {
        return this.mapStoreExecutorService;
    }

    private NamedExecutorService getOrCreateNamedExecutorService(String name, GroupProperties.GroupProperty groupProperty) {
        return this.getOrCreateNamedExecutorService(name, groupProperty, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NamedExecutorService getOrCreateNamedExecutorService(String name, GroupProperties.GroupProperty groupProperty, int capacity, int timeoutMillis) {
        NamedExecutorService namedExecutorService = (NamedExecutorService)this.mapExecutors.get(name);
        if (namedExecutorService == null) {
            Object object = this.CREATE_LOCK;
            synchronized (object) {
                namedExecutorService = (NamedExecutorService)this.mapExecutors.get(name);
                if (namedExecutorService == null) {
                    ExecutorConfig executorConfig = this.node.getConfig().getExecutorConfig(name.substring(2));
                    if (groupProperty != null) {
                        executorConfig.setCorePoolSize(groupProperty.getInteger());
                        executorConfig.setMaxPoolSize(groupProperty.getInteger());
                    }
                    namedExecutorService = this.newNamedExecutorService(name, executorConfig, capacity, timeoutMillis);
                }
            }
        }
        return namedExecutorService;
    }

    private NamedExecutorService newNamedExecutorService(String name, ExecutorConfig executorConfig) {
        return this.newNamedExecutorService(name, executorConfig, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    private NamedExecutorService newNamedExecutorService(String name, ExecutorConfig executorConfig, int capacity, int timeoutMillis) {
        this.logger.log(Level.FINEST, "creating new named executor service " + name);
        int concurrencyLevel = executorConfig.getMaxPoolSize();
        ParallelExecutor parallelExecutor = this.parallelExecutorService.newParallelExecutor(concurrencyLevel, capacity, timeoutMillis);
        NamedExecutorService es = new NamedExecutorService(name, parallelExecutor);
        this.mapExecutors.put(name, es);
        return es;
    }

    public ParallelExecutor newParallelExecutor(int concurrencyLevel) {
        return this.parallelExecutorService.newParallelExecutor(concurrencyLevel);
    }

    public void appendState(StringBuffer sbState) {
        Set names = this.mapExecutors.keySet();
        for (String name : names) {
            NamedExecutorService namedExecutorService = (NamedExecutorService)this.mapExecutors.get(name);
            namedExecutorService.appendState(sbState);
        }
    }

    public Set<String> getExecutorNames() {
        return this.mapExecutors.keySet();
    }

    public void appendFullState(StringBuffer sbState) {
        Set names = this.mapExecutors.keySet();
        for (String name : names) {
            NamedExecutorService namedExecutorService = (NamedExecutorService)this.mapExecutors.get(name);
            namedExecutorService.appendState(sbState);
        }
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        Collection executors = this.mapExecutors.values();
        for (NamedExecutorService namedExecutorService : executors) {
            namedExecutorService.stop();
        }
        this.parallelExecutorService.shutdown();
        this.esScheduled.shutdownNow();
        this.threadPoolExecutor.shutdownNow();
        try {
            this.esScheduled.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.threadPoolExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.started = false;
    }

    public NamedExecutorService getDefaultExecutorService() {
        return this.defaultExecutorService;
    }

    public NamedExecutorService getEventExecutorService() {
        return this.eventExecutorService;
    }

    public void executeLocally(Runnable runnable) {
        this.defaultExecutorService.execute(runnable);
    }

    public void executeAsync(Runnable runnable) {
        this.asyncExecutorService.execute(runnable);
    }

    public void executeNow(Runnable runnable) {
        this.threadPoolExecutor.execute(runnable);
    }

    public void executeQueryTask(Runnable runnable) {
        this.queryExecutorService.execute(runnable);
    }

    public void call(String name, DistributedTask dtask) {
        NamedExecutorService namedExecutorService = this.getOrCreateNamedExecutorService(name);
        InnerFutureTask inner = (InnerFutureTask)dtask.getInner();
        Data dataCallable = IOUtil.toData(inner.getCallable());
        if (inner.getMembers() != null) {
            Set<Member> members = inner.getMembers();
            if (members.size() == 1) {
                MemberCall memberCall = new MemberCall(name, (MemberImpl)members.iterator().next(), dataCallable, dtask);
                inner.setExecutionManagerCallback(memberCall);
                memberCall.call();
            } else {
                MembersCall membersCall = new MembersCall(name, members, dataCallable, dtask);
                inner.setExecutionManagerCallback(membersCall);
                membersCall.call();
            }
        } else if (inner.getMember() != null) {
            MemberCall memberCall = new MemberCall(name, (MemberImpl)inner.getMember(), dataCallable, dtask);
            inner.setExecutionManagerCallback(memberCall);
            memberCall.call();
        } else if (inner.getKey() != null) {
            Partition partition = this.node.factory.getPartitionService().getPartition(inner.getKey());
            Member target = partition.getOwner();
            if (target == null) {
                target = this.node.factory.getCluster().getMembers().iterator().next();
            }
            MemberCall memberCall = new MemberCall(name, (MemberImpl)target, dataCallable, dtask);
            inner.setExecutionManagerCallback(memberCall);
            memberCall.call();
        } else {
            MemberImpl target = (MemberImpl)namedExecutorService.getExecutionLoadBalancer().getTarget(this.node.factory);
            MemberCall memberCall = new MemberCall(name, target, dataCallable, dtask);
            inner.setExecutionManagerCallback(memberCall);
            memberCall.call();
        }
    }

    void notifyCompletion(final DistributedTask dtask) {
        final InnerFutureTask innerFutureTask = (InnerFutureTask)dtask.getInner();
        this.getEventExecutorService().execute(new Runnable(){

            public void run() {
                innerFutureTask.innerDone();
                if (innerFutureTask.getExecutionCallback() != null) {
                    innerFutureTask.getExecutionCallback().done(dtask);
                }
            }
        });
    }

    private void threadPoolBeforeExecute(Thread t, Runnable r) {
        ThreadContext threadContext = ThreadContext.get();
        threadContext.setCurrentFactory(this.node.factory);
        CallContext callContext = (CallContext)this.mapThreadCallContexts.get(t);
        if (callContext == null) {
            callContext = new CallContext(threadContext.createNewThreadId(), false);
            this.mapThreadCallContexts.put(t, callContext);
        }
        threadContext.setCallContext(callContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object toObjectWithConfigClassLoader(Data data) {
        ClassLoader actualContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.node.getConfig().getClassLoader());
            Object object = IOUtil.toObject(data);
            Object var5_4 = null;
            Thread.currentThread().setContextClassLoader(actualContextClassLoader);
            return object;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Thread.currentThread().setContextClassLoader(actualContextClassLoader);
            throw throwable;
        }
    }

    public Map<String, LocalExecutorOperationStatsImpl> getThroughputMap() {
        ConcurrentHashMap<String, LocalExecutorOperationStatsImpl> map = new ConcurrentHashMap<String, LocalExecutorOperationStatsImpl>();
        for (String s : this.throughputMap.keySet()) {
            map.put(s, (LocalExecutorOperationStatsImpl)((ExecutorOperationsCounter)this.throughputMap.get(s)).getPublishedStats());
        }
        return map;
    }

    public Map<String, LocalExecutorOperationStatsImpl> getInternalThroughputMap() {
        ConcurrentHashMap<String, LocalExecutorOperationStatsImpl> map = new ConcurrentHashMap<String, LocalExecutorOperationStatsImpl>();
        for (String s : this.internalThroughputMap.keySet()) {
            map.put(s, (LocalExecutorOperationStatsImpl)((ExecutorOperationsCounter)this.internalThroughputMap.get(s)).getPublishedStats());
        }
        return map;
    }

    class MemberCall
    extends BaseManager.TargetAwareOp
    implements ExecutionManagerCallback {
        final String name;
        final MemberImpl member;
        final Data callable;
        final DistributedTask dtask;
        final InnerFutureTask innerFutureTask;
        final boolean singleTask;
        final ExecutionListener executionListener;
        volatile long executionId;
        long startTime;

        MemberCall(String name, MemberImpl member, Data callable, DistributedTask dtask) {
            this(name, member, callable, dtask, true, null);
        }

        MemberCall(String name, MemberImpl member, Data callable, DistributedTask dtask, boolean singleTask, ExecutionListener executionListener) {
            this.name = name;
            this.member = member;
            this.callable = callable;
            this.dtask = dtask;
            this.innerFutureTask = (InnerFutureTask)dtask.getInner();
            this.singleTask = singleTask;
            this.target = member.getAddress();
            this.executionListener = executionListener;
        }

        public void call() {
            ExecutorManager.this.throughputMap.putIfAbsent(this.name, new ExecutorOperationsCounter(60000L, this.name));
            ((ExecutorOperationsCounter)ExecutorManager.this.throughputMap.get(this.name)).startExecution(0L);
            this.startTime = Clock.currentTimeMillis();
            this.executionId = ExecutorManager.this.executionIdGen.incrementAndGet();
            this.request.setLocal(ClusterOperation.EXECUTE, this.name, null, this.callable, -1, -1L, -1L, ExecutorManager.this.thisAddress);
            this.request.longValue = this.executionId;
            if (!this.member.localMember()) {
                for (int i = 0; i < 10 && ExecutorManager.this.node.isActive() && ExecutorManager.this.node.getClusterImpl().getMembers().contains(this.member) && ExecutorManager.this.node.connectionManager.getOrConnect(this.member.getAddress()) == null; ++i) {
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
            this.doOp();
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            ((ExecutorOperationsCounter)ExecutorManager.this.throughputMap.get(this.name)).finishExecution(Clock.currentTimeMillis() - this.startTime);
            TaskCancellationCall call = new TaskCancellationCall(this.name, this.member, this.executionId, mayInterruptIfRunning);
            return call.cancel();
        }

        public void get() throws InterruptedException {
            this.get(-1L, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void get(long time, TimeUnit unit) throws InterruptedException {
            Object result = null;
            boolean done = true;
            try {
                block12: {
                    try {
                        result = this.doGetResult(time == -1L ? -1L : unit.toMillis(time));
                        if (result == Constants.Objects.OBJECT_NO_RESPONSE || result == Constants.Objects.OBJECT_REDO) {
                            done = false;
                            this.innerFutureTask.innerSetException(new TimeoutException(), false);
                            break block12;
                        }
                        if (result instanceof CancellationException) {
                            this.innerFutureTask.innerSetCancelled();
                            break block12;
                        }
                        if (result == Constants.Objects.OBJECT_MEMBER_LEFT) {
                            this.innerFutureTask.innerSetMemberLeft(this.member);
                            break block12;
                        }
                        if (result instanceof Throwable) {
                            this.innerFutureTask.innerSetException((Throwable)result, true);
                            break block12;
                        }
                        this.innerFutureTask.innerSet(result);
                    }
                    catch (Exception e2) {
                        TimeoutException e2;
                        if (time > 0L && e2 instanceof OperationTimeoutException) {
                            e2 = new TimeoutException();
                        }
                        this.innerFutureTask.innerSetException(e2, done);
                        Object var8_6 = null;
                        if (this.singleTask && done) {
                            this.innerFutureTask.innerDone();
                        }
                    }
                }
                Object var8_5 = null;
                if (this.singleTask && done) {
                    this.innerFutureTask.innerDone();
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                if (this.singleTask && done) {
                    this.innerFutureTask.innerDone();
                }
                throw throwable;
            }
        }

        public Object doGetResult(long timeoutMillis) throws InterruptedException {
            Object result;
            Object object = result = timeoutMillis == -1L ? this.getResult() : this.getResult(timeoutMillis, TimeUnit.MILLISECONDS);
            if (result == null) {
                result = Constants.Objects.OBJECT_NO_RESPONSE;
            }
            if (result == Constants.Objects.OBJECT_NULL) {
                result = null;
            } else if (result instanceof Data) {
                Data data = (Data)result;
                result = data.size() == 0 ? null : ExecutorManager.this.toObjectWithConfigClassLoader(data);
            }
            this.afterGettingResult(this.request);
            return result;
        }

        public void onDisconnect(Address dead) {
            if (dead.equals(this.target)) {
                this.setResult(Constants.Objects.OBJECT_MEMBER_LEFT);
            }
        }

        public void packetNotSent() {
            this.setResult(Constants.Objects.OBJECT_MEMBER_LEFT);
        }

        protected void memberDoesNotExist() {
            this.setResult(Constants.Objects.OBJECT_MEMBER_LEFT);
        }

        public void onResponse(Object response) {
            ((ExecutorOperationsCounter)ExecutorManager.this.throughputMap.get(this.name)).finishExecution(Clock.currentTimeMillis() - this.startTime);
            if (this.singleTask) {
                ExecutorManager.this.notifyCompletion(this.dtask);
            }
        }

        public void setResult(Object result) {
            super.setResult(result);
            if (this.executionListener != null) {
                this.executionListener.onResponse(result);
            }
            this.onResponse(result);
        }

        public void setTarget() {
            this.target = this.member.getAddress();
        }

        protected boolean canTimeout() {
            return false;
        }
    }

    class TaskCancellationCall
    extends BaseManager.TargetAwareOp {
        final String name;
        final MemberImpl member;
        final long executionId;
        final boolean mayInterruptIfRunning;

        TaskCancellationCall(String name, MemberImpl member, long executionId, boolean mayInterruptIfRunning) {
            this.name = name;
            this.member = member;
            this.executionId = executionId;
            this.mayInterruptIfRunning = mayInterruptIfRunning;
        }

        public boolean cancel() {
            this.request.setLocal(ClusterOperation.CANCEL_EXECUTION, this.name, null, null, -1, 0L, -1L, ExecutorManager.this.thisAddress);
            this.request.longValue = this.executionId;
            this.request.blockId = this.mayInterruptIfRunning ? 1 : 0;
            this.doOp();
            return this.getResultAsBoolean();
        }

        public void setTarget() {
            this.target = this.member.getAddress();
        }

        protected boolean canTimeout() {
            return false;
        }
    }

    static interface ExecutionListener {
        public void onResponse(Object var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MembersCall
    implements ExecutionManagerCallback,
    ExecutionListener {
        final DistributedTask dtask;
        final String name;
        final Set<Member> members;
        final Data callable;
        final InnerFutureTask innerFutureTask;
        final List<MemberCall> lsMemberCalls = new ArrayList<MemberCall>();
        int responseCount = 0;
        long startTime;

        MembersCall(String name, Set<Member> members, Data callable, DistributedTask dtask) {
            this.name = name;
            this.members = members;
            this.callable = callable;
            this.dtask = dtask;
            this.innerFutureTask = (InnerFutureTask)dtask.getInner();
        }

        void call() {
            ExecutorManager.this.throughputMap.putIfAbsent(this.name, new ExecutorOperationsCounter(60000L, this.name));
            ((ExecutorOperationsCounter)ExecutorManager.this.throughputMap.get(this.name)).startExecution(0L);
            this.startTime = Clock.currentTimeMillis();
            for (Member member : this.members) {
                MemberCall memberCall = new MemberCall(this.name, (MemberImpl)member, this.callable, this.dtask, false, this);
                this.lsMemberCalls.add(memberCall);
                memberCall.call();
            }
        }

        @Override
        public void onResponse(Object result) {
            ((ExecutorOperationsCounter)ExecutorManager.this.throughputMap.get(this.name)).finishExecution(Clock.currentTimeMillis() - this.startTime);
            ++this.responseCount;
            if (result == Constants.Objects.OBJECT_MEMBER_LEFT || this.responseCount >= this.lsMemberCalls.size()) {
                ExecutorManager.this.notifyCompletion(this.dtask);
            }
        }

        @Override
        public boolean cancel(final boolean mayInterruptIfRunning) {
            ((ExecutorOperationsCounter)ExecutorManager.this.throughputMap.get(this.name)).finishExecution(Clock.currentTimeMillis() - this.startTime);
            ArrayList<1> lsCancellationCalls = new ArrayList<1>(this.lsMemberCalls.size());
            for (final MemberCall memberCall : this.lsMemberCalls) {
                AsyncCall asyncCall = new AsyncCall(){

                    protected void call() {
                        this.setResult(memberCall.cancel(mayInterruptIfRunning));
                    }
                };
                lsCancellationCalls.add(asyncCall);
                ExecutorManager.this.executeAsync(asyncCall);
            }
            for (AsyncCall asyncCall : lsCancellationCalls) {
                try {
                    if (asyncCall.get(5L, TimeUnit.SECONDS) != Boolean.TRUE) continue;
                    return true;
                }
                catch (Exception ignored) {
                    return false;
                }
            }
            return false;
        }

        @Override
        public void get() throws InterruptedException, ExecutionException {
            this.doGet(-1L);
        }

        @Override
        public void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
            this.doGet(unit.toMillis(timeout));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void doGet(long timeoutMillis) {
            boolean done = true;
            long remainingMillis = timeoutMillis;
            try {
                try {
                    for (MemberCall memberCall : this.lsMemberCalls) {
                        long now = Clock.currentTimeMillis();
                        if (timeoutMillis == -1L) {
                            memberCall.get();
                        } else {
                            if (remainingMillis < 0L) {
                                done = false;
                                this.innerFutureTask.innerSetException(new TimeoutException(), done);
                                Object var11_8 = null;
                                if (!done) return;
                                this.innerFutureTask.innerDone();
                                return;
                            }
                            memberCall.get(remainingMillis, TimeUnit.MILLISECONDS);
                        }
                        remainingMillis -= Clock.currentTimeMillis() - now;
                    }
                }
                catch (Exception e) {
                    this.innerFutureTask.innerSetException(e, done);
                    Object var11_10 = null;
                    if (!done) return;
                    this.innerFutureTask.innerDone();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (!done) throw throwable;
                this.innerFutureTask.innerDone();
                throw throwable;
            }
            Object var11_9 = null;
            if (!done) return;
            this.innerFutureTask.innerDone();
        }
    }

    class RejectionHandler
    implements RejectedExecutionHandler {
        RejectionHandler() {
        }

        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            ExecutorManager.this.logger.log(Level.WARNING, "ExecutorService is rejecting an execution. " + runnable);
        }
    }

    class RequestExecutor
    implements Runnable {
        final Request request;
        private final ExecutionKey executionKey;
        volatile boolean done = false;
        volatile boolean cancelled = false;
        volatile boolean running = false;
        volatile Thread runningThread = null;
        final long creationTime;

        RequestExecutor(Request request, ExecutionKey executionKey) {
            this.request = request;
            this.executionKey = executionKey;
            this.creationTime = Clock.currentTimeMillis();
            ExecutorManager.this.internalThroughputMap.putIfAbsent(request.name, new ExecutorOperationsCounter(60000L, request.name));
            ((ExecutorOperationsCounter)ExecutorManager.this.internalThroughputMap.get(request.name)).startPending();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            ExecutorOperationsCounter operationsCounter;
            Data result;
            long startTime;
            block9: {
                startTime = Clock.currentTimeMillis();
                result = null;
                operationsCounter = (ExecutorOperationsCounter)ExecutorManager.this.internalThroughputMap.get(this.request.name);
                try {
                    try {
                        this.runningThread = Thread.currentThread();
                        operationsCounter.startExecution(startTime - this.creationTime);
                        this.running = true;
                        if (!this.cancelled) {
                            Callable callable = (Callable)IOUtil.toObject(this.request.value);
                            if (callable instanceof SecureCallable) {
                                SecureCallable secureCallable = (SecureCallable)callable;
                                secureCallable.setNode(ExecutorManager.this.node);
                            }
                            result = callable.call();
                            result = IOUtil.toData(result);
                        }
                    }
                    catch (Throwable e) {
                        result = IOUtil.toData(e);
                        Object var8_8 = null;
                        if (this.cancelled) {
                            result = IOUtil.toData(new CancellationException());
                        }
                        operationsCounter.finishExecution(Clock.currentTimeMillis() - startTime);
                        this.running = false;
                        this.done = true;
                        ExecutorManager.this.executions.remove(this.executionKey);
                        this.request.clearForResponse();
                        this.request.response = result;
                        ExecutorManager.this.enqueueAndReturn(new BaseManager.ReturnResponseProcess(this.request));
                        return;
                    }
                    Object var8_7 = null;
                    if (!this.cancelled) break block9;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    if (this.cancelled) {
                        result = IOUtil.toData(new CancellationException());
                    }
                    operationsCounter.finishExecution(Clock.currentTimeMillis() - startTime);
                    this.running = false;
                    this.done = true;
                    ExecutorManager.this.executions.remove(this.executionKey);
                    this.request.clearForResponse();
                    this.request.response = result;
                    ExecutorManager.this.enqueueAndReturn(new BaseManager.ReturnResponseProcess(this.request));
                    throw throwable;
                }
                result = IOUtil.toData(new CancellationException());
            }
            operationsCounter.finishExecution(Clock.currentTimeMillis() - startTime);
            this.running = false;
            this.done = true;
            ExecutorManager.this.executions.remove(this.executionKey);
            this.request.clearForResponse();
            this.request.response = result;
            ExecutorManager.this.enqueueAndReturn(new BaseManager.ReturnResponseProcess(this.request));
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.done || this.cancelled) {
                return false;
            }
            this.cancelled = true;
            if (this.running && mayInterruptIfRunning && this.runningThread != null) {
                this.runningThread.interrupt();
            }
            return true;
        }
    }

    class ExecutionKey {
        final Address from;
        final long executionId;

        ExecutionKey(Address from, long executionId) {
            this.executionId = executionId;
            this.from = from;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExecutionKey that = (ExecutionKey)o;
            if (this.executionId != that.executionId) {
                return false;
            }
            return this.from.equals(that.from);
        }

        public int hashCode() {
            int result = this.from.hashCode();
            result = 31 * result + (int)(this.executionId ^ this.executionId >>> 32);
            return result;
        }
    }

    class ExecutionOperationHandler
    extends BaseManager.AbstractOperationHandler {
        ExecutionOperationHandler() {
        }

        void doOperation(Request request) {
            if (this.isCallerKnownMember(request)) {
                NamedExecutorService namedExecutorService = ExecutorManager.this.getOrCreateNamedExecutorService(request.name);
                ExecutionKey executionKey = new ExecutionKey(request.caller, request.longValue);
                RequestExecutor requestExecutor = new RequestExecutor(request, executionKey);
                ExecutorManager.this.executions.put(executionKey, requestExecutor);
                namedExecutorService.execute(requestExecutor);
            } else {
                ExecutorManager.this.returnRedoResponse(request, Constants.RedoType.REDO_MEMBER_UNKNOWN);
            }
        }

        public void handle(Request request) {
            this.doOperation(request);
        }

        boolean isCallerKnownMember(Request request) {
            return request.local || ExecutorManager.this.getMember(request.caller) != null;
        }
    }

    class ExecutionCancelOperationHandler
    extends BaseManager.AbstractOperationHandler {
        ExecutionCancelOperationHandler() {
        }

        void doOperation(Request request) {
            ExecutionKey executionKey = new ExecutionKey(request.caller, request.longValue);
            RequestExecutor requestExecutor = (RequestExecutor)ExecutorManager.this.executions.get(executionKey);
            if (requestExecutor != null) {
                request.response = requestExecutor.cancel(request.blockId == 1);
            }
            ExecutorManager.this.returnResponse(request);
        }

        public void handle(Request request) {
            this.doOperation(request);
        }
    }

    public static class Statistics
    implements Serializable {
        public final int queryQueueSize;
        public final int mapLoaderExecutorQueueSize;
        public final int defaultExecutorQueueSize;
        public final int asyncExecutorQueueSize;
        public final int eventExecutorQueueSize;
        public final int mapStoreExecutorQueueSize;

        public Statistics(ExecutorManager executorManager) {
            this.mapLoaderExecutorQueueSize = executorManager.mapLoaderExecutorService.getQueueSize();
            this.asyncExecutorQueueSize = executorManager.asyncExecutorService.getQueueSize();
            this.defaultExecutorQueueSize = executorManager.defaultExecutorService.getQueueSize();
            this.queryQueueSize = executorManager.queryExecutorService.getQueueSize();
            this.eventExecutorQueueSize = executorManager.eventExecutorService.getQueueSize();
            this.mapStoreExecutorQueueSize = executorManager.mapStoreExecutorService.getQueueSize();
        }

        public String toString() {
            return "Statistics{queryQueueSize=" + this.queryQueueSize + ", mapLoaderExecutorQueueSize=" + this.mapLoaderExecutorQueueSize + ", defaultExecutorQueueSize=" + this.defaultExecutorQueueSize + ", asyncExecutorQueueSize=" + this.asyncExecutorQueueSize + ", eventExecutorQueueSize=" + this.eventExecutorQueueSize + ", mapStoreExecutorQueueSize=" + this.mapStoreExecutorQueueSize + '}';
        }
    }
}

