/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.map.impl.SizeEstimator;
import com.hazelcast.map.impl.SizeEstimators;
import com.hazelcast.map.impl.iterator.MapEntriesWithCursor;
import com.hazelcast.map.impl.iterator.MapKeysWithCursor;
import com.hazelcast.map.impl.record.AbstractRecord;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordFactory;
import com.hazelcast.map.impl.recordstore.LazyEntryViewFromRecord;
import com.hazelcast.map.impl.recordstore.Storage;
import com.hazelcast.map.impl.recordstore.StorageSCHM;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.serialization.SerializationService;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class StorageImpl<R extends Record>
implements Storage<Data, R> {
    private final RecordFactory<R> recordFactory;
    private final StorageSCHM<R> records;
    private SizeEstimator sizeEstimator;

    StorageImpl(RecordFactory<R> recordFactory, InMemoryFormat inMemoryFormat, SerializationService serializationService) {
        this.recordFactory = recordFactory;
        this.sizeEstimator = SizeEstimators.createMapSizeEstimator(inMemoryFormat);
        this.records = new StorageSCHM(serializationService);
    }

    @Override
    public void clear(boolean isDuringShutdown) {
        this.records.clear();
        this.sizeEstimator.reset();
    }

    @Override
    public Collection<R> values() {
        return this.records.values();
    }

    @Override
    public void put(Data key, R record) {
        ((AbstractRecord)record).setKey(key);
        Record previousRecord = (Record)this.records.put(key, record);
        if (previousRecord == null) {
            this.updateSizeEstimator(this.calculateHeapCost(key));
        }
        this.updateSizeEstimator(-this.calculateHeapCost(previousRecord));
        this.updateSizeEstimator(this.calculateHeapCost(record));
    }

    @Override
    public void updateRecordValue(Data key, R record, Object value) {
        this.updateSizeEstimator(-this.calculateHeapCost(record));
        this.recordFactory.setValue((Record<R>)record, value);
        this.updateSizeEstimator(this.calculateHeapCost(record));
    }

    @Override
    public R get(Data key) {
        return (R)((Record)this.records.get(key));
    }

    @Override
    public R getIfSameKey(Data key) {
        throw new UnsupportedOperationException("StorageImpl#getIfSameKey");
    }

    @Override
    public int size() {
        return this.records.size();
    }

    @Override
    public boolean isEmpty() {
        return this.records.isEmpty();
    }

    @Override
    public void destroy(boolean isDuringShutdown) {
        this.clear(isDuringShutdown);
    }

    @Override
    public SizeEstimator getSizeEstimator() {
        return this.sizeEstimator;
    }

    @Override
    public boolean containsKey(Data key) {
        return this.records.containsKey(key);
    }

    @Override
    public void removeRecord(R record) {
        if (record == null) {
            return;
        }
        Data key = record.getKey();
        this.records.remove(key);
        this.updateSizeEstimator(-this.calculateHeapCost(record));
        this.updateSizeEstimator(-this.calculateHeapCost(key));
    }

    protected void updateSizeEstimator(long recordSize) {
        this.sizeEstimator.add(recordSize);
    }

    protected long calculateHeapCost(Object obj) {
        return this.sizeEstimator.calculateSize(obj);
    }

    @Override
    public void setSizeEstimator(SizeEstimator sizeEstimator) {
        this.sizeEstimator = sizeEstimator;
    }

    @Override
    public void disposeDeferredBlocks() {
    }

    @Override
    public Iterable<LazyEntryViewFromRecord> getRandomSamples(int sampleCount) {
        return this.records.getRandomSamples(sampleCount);
    }

    @Override
    public MapKeysWithCursor fetchKeys(int tableIndex, int size) {
        ArrayList<Data> keys = new ArrayList<Data>(size);
        int newTableIndex = this.records.fetchKeys(tableIndex, size, keys);
        return new MapKeysWithCursor(keys, newTableIndex);
    }

    @Override
    public MapEntriesWithCursor fetchEntries(int tableIndex, int size, SerializationService serializationService) {
        ArrayList entries = new ArrayList(size);
        int newTableIndex = this.records.fetchEntries(tableIndex, size, entries);
        ArrayList<Map.Entry<Data, Data>> entriesData = new ArrayList<Map.Entry<Data, Data>>(entries.size());
        for (Map.Entry entry : entries) {
            Record record = (Record)entry.getValue();
            Object dataValue = serializationService.toData(record.getValue());
            entriesData.add(new AbstractMap.SimpleEntry(entry.getKey(), dataValue));
        }
        return new MapEntriesWithCursor(entriesData, newTableIndex);
    }
}

