/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.impl;

import java.io.File;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.impl.DefaultVfsComponentContext;
import org.apache.commons.vfs.impl.FileTypeMap;
import org.apache.commons.vfs.impl.URLStreamHandlerProxy;
import org.apache.commons.vfs.impl.VirtualFileProvider;
import org.apache.commons.vfs.provider.DefaultURLStreamHandler;
import org.apache.commons.vfs.provider.FileProvider;
import org.apache.commons.vfs.provider.FileReplicator;
import org.apache.commons.vfs.provider.LocalFileProvider;
import org.apache.commons.vfs.provider.TemporaryFileStore;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.VfsComponent;

public class DefaultFileSystemManager
implements FileSystemManager {
    private LocalFileProvider localFileProvider;
    private FileProvider defaultProvider;
    private FileReplicator fileReplicator;
    private final Map providers = new HashMap();
    private final ArrayList components = new ArrayList();
    private FileObject baseFile;
    private Log log = LogFactory.getLog((Class)(class$org$apache$commons$vfs$impl$DefaultFileSystemManager == null ? (class$org$apache$commons$vfs$impl$DefaultFileSystemManager = DefaultFileSystemManager.class$("org.apache.commons.vfs.impl.DefaultFileSystemManager")) : class$org$apache$commons$vfs$impl$DefaultFileSystemManager));
    private final DefaultVfsComponentContext context = new DefaultVfsComponentContext(this);
    private TemporaryFileStore tempFileStore;
    private final FileTypeMap map = new FileTypeMap();
    private final VirtualFileProvider vfsProvider = new VirtualFileProvider();
    private boolean init;
    static /* synthetic */ Class class$org$apache$commons$vfs$impl$DefaultFileSystemManager;

    protected Log getLog() {
        if (this.log == null) {
            this.log = LogFactory.getLog(this.getClass());
        }
        return this.log;
    }

    public void addProvider(String urlScheme, FileProvider provider) throws FileSystemException {
        this.addProvider(new String[]{urlScheme}, provider);
    }

    public void addProvider(String[] urlSchemes, FileProvider provider) throws FileSystemException {
        int i = 0;
        while (i < urlSchemes.length) {
            String scheme = urlSchemes[i];
            if (this.providers.containsKey(scheme)) {
                throw new FileSystemException("vfs.impl/multiple-providers-for-scheme.error", scheme);
            }
            ++i;
        }
        this.setupComponent(provider);
        int i2 = 0;
        while (i2 < urlSchemes.length) {
            String scheme = urlSchemes[i2];
            this.providers.put(scheme, provider);
            ++i2;
        }
        if (provider instanceof LocalFileProvider) {
            this.localFileProvider = (LocalFileProvider)provider;
        }
    }

    public boolean hasProvider(String scheme) {
        return this.providers.containsKey(scheme);
    }

    public void addExtensionMap(String extension, String scheme) {
        this.map.addExtension(extension, scheme);
    }

    public void addMimeTypeMap(String mimeType, String scheme) {
        this.map.addMimeType(mimeType, scheme);
    }

    public void setDefaultProvider(FileProvider provider) throws FileSystemException {
        this.setupComponent(provider);
        this.defaultProvider = provider;
    }

    public void setReplicator(FileReplicator replicator) throws FileSystemException {
        this.setupComponent(replicator);
        this.fileReplicator = replicator;
    }

    public void setTemporaryFileStore(TemporaryFileStore tempFileStore) throws FileSystemException {
        this.setupComponent(tempFileStore);
        this.tempFileStore = tempFileStore;
    }

    public void setLogger(Log log) {
        this.log = log;
    }

    private void setupComponent(Object component) throws FileSystemException {
        if (!this.components.contains(component)) {
            if (component instanceof VfsComponent) {
                VfsComponent vfsComponent = (VfsComponent)component;
                vfsComponent.setLogger(this.getLog());
                vfsComponent.setContext(this.context);
                vfsComponent.init();
            }
            this.components.add(component);
        }
    }

    private void closeComponent(Object component) {
        if (component != null && this.components.contains(component)) {
            if (component instanceof VfsComponent) {
                VfsComponent vfsComponent = (VfsComponent)component;
                vfsComponent.close();
            }
            this.components.remove(component);
        }
    }

    public FileReplicator getReplicator() throws FileSystemException {
        if (this.fileReplicator == null) {
            throw new FileSystemException("vfs.impl/no-replicator.error");
        }
        return this.fileReplicator;
    }

    public TemporaryFileStore getTemporaryFileStore() throws FileSystemException {
        if (this.tempFileStore == null) {
            throw new FileSystemException("vfs.impl/no-temp-file-store.error");
        }
        return this.tempFileStore;
    }

    public void init() throws FileSystemException {
        this.setupComponent(this.vfsProvider);
        this.init = true;
    }

    public void close() {
        if (!this.init) {
            return;
        }
        Iterator iterator = this.providers.values().iterator();
        while (iterator.hasNext()) {
            Object provider = iterator.next();
            this.closeComponent(provider);
        }
        this.closeComponent(this.defaultProvider);
        this.closeComponent(this.fileReplicator);
        this.closeComponent(this.tempFileStore);
        this.components.clear();
        this.providers.clear();
        this.localFileProvider = null;
        this.defaultProvider = null;
        this.fileReplicator = null;
        this.tempFileStore = null;
        this.init = false;
    }

    public void setBaseFile(FileObject baseFile) throws FileSystemException {
        this.baseFile = baseFile;
    }

    public void setBaseFile(File baseFile) throws FileSystemException {
        this.baseFile = this.getLocalFileProvider().findLocalFile(baseFile);
    }

    public FileObject getBaseFile() {
        return this.baseFile;
    }

    public FileObject resolveFile(String uri) throws FileSystemException {
        return this.resolveFile(this.baseFile, uri);
    }

    public FileObject resolveFile(File baseFile, String uri) throws FileSystemException {
        FileObject baseFileObj = this.getLocalFileProvider().findLocalFile(baseFile);
        return this.resolveFile(baseFileObj, uri);
    }

    public FileObject resolveFile(FileObject baseFile, String uri) throws FileSystemException {
        FileProvider provider;
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        String scheme = UriParser.extractScheme(uri);
        if (scheme != null && (provider = (FileProvider)this.providers.get(scheme)) != null) {
            return provider.findFile(baseFile, uri);
        }
        String decodedUri = UriParser.decode(uri);
        if (this.localFileProvider != null && this.localFileProvider.isAbsoluteLocalName(decodedUri)) {
            return this.localFileProvider.findLocalFile(decodedUri);
        }
        if (scheme != null) {
            if (this.defaultProvider == null) {
                throw new FileSystemException("vfs.impl/unknown-scheme.error", new Object[]{scheme, uri});
            }
            return this.defaultProvider.findFile(baseFile, uri);
        }
        if (baseFile == null) {
            throw new FileSystemException("vfs.impl/find-rel-file.error", uri);
        }
        return baseFile.resolveFile(decodedUri);
    }

    public FileObject toFileObject(File file) throws FileSystemException {
        return this.getLocalFileProvider().findLocalFile(file);
    }

    public FileObject createFileSystem(String scheme, FileObject file) throws FileSystemException {
        FileProvider provider = (FileProvider)this.providers.get(scheme);
        if (provider == null) {
            throw new FileSystemException("vfs.impl/unknown-provider.error", new Object[]{scheme, file});
        }
        return provider.createFileSystem(scheme, file);
    }

    public FileObject createFileSystem(FileObject file) throws FileSystemException {
        String scheme = this.map.getScheme(file);
        if (scheme == null) {
            throw new FileSystemException("vfs.impl/no-provider-for-file.error", file);
        }
        return this.createFileSystem(scheme, file);
    }

    public boolean canCreateFileSystem(FileObject file) throws FileSystemException {
        return this.map.getScheme(file) != null;
    }

    public FileObject createVirtualFileSystem(FileObject rootFile) throws FileSystemException {
        return this.vfsProvider.createFileSystem(rootFile);
    }

    public FileObject createVirtualFileSystem(String rootUri) throws FileSystemException {
        return this.vfsProvider.createFileSystem(rootUri);
    }

    private LocalFileProvider getLocalFileProvider() throws FileSystemException {
        if (this.localFileProvider == null) {
            throw new FileSystemException("vfs.impl/no-local-file-provider.error");
        }
        return this.localFileProvider;
    }

    public URLStreamHandlerFactory getURLStreamHandlerFactory() {
        return new VfsStreamHandlerFactory();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    final class VfsStreamHandlerFactory
    implements URLStreamHandlerFactory {
        VfsStreamHandlerFactory() {
        }

        public URLStreamHandler createURLStreamHandler(String protocol) {
            FileProvider provider = (FileProvider)DefaultFileSystemManager.this.providers.get(protocol);
            if (provider != null) {
                return new DefaultURLStreamHandler(DefaultFileSystemManager.this.context);
            }
            return new URLStreamHandlerProxy();
        }
    }
}

