/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.NameScope;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.DelegateFileObject;

public class VirtualFileSystem
extends AbstractFileSystem {
    private final Map junctions = new HashMap();

    public VirtualFileSystem(FileName rootName) {
        super(rootName, null);
    }

    protected void addCapabilities(Collection caps) {
        caps.add(Capability.ATTRIBUTES);
        caps.add(Capability.CREATE);
        caps.add(Capability.DELETE);
        caps.add(Capability.GET_TYPE);
        caps.add(Capability.JUNCTIONS);
        caps.add(Capability.GET_LAST_MODIFIED);
        caps.add(Capability.SET_LAST_MODIFIED);
        caps.add(Capability.LIST_CHILDREN);
        caps.add(Capability.READ_CONTENT);
        caps.add(Capability.SIGNING);
        caps.add(Capability.WRITE_CONTENT);
    }

    protected FileObject createFile(FileName name) throws Exception {
        FileObject file;
        FileName junctionPoint = this.getJunctionForFile(name);
        if (junctionPoint != null) {
            FileObject junctionFile = (FileObject)this.junctions.get(junctionPoint);
            String relName = junctionPoint.getRelativeName(name);
            file = junctionFile.resolveFile(relName, NameScope.DESCENDENT_OR_SELF);
        } else {
            file = null;
        }
        return new DelegateFileObject(name, this, file);
    }

    public void addJunction(String junctionPoint, FileObject targetFile) throws FileSystemException {
        FileName junctionName = this.getRootName().resolveName(junctionPoint);
        if (this.getJunctionForFile(junctionName) != null) {
            throw new FileSystemException("vfs.impl/nested-junction.error", junctionName);
        }
        try {
            this.junctions.put(junctionName, targetFile);
            DelegateFileObject junctionFile = (DelegateFileObject)this.getFile(junctionName);
            if (junctionFile != null) {
                junctionFile.setFile(targetFile);
            }
            FileName childName = junctionName;
            boolean done = false;
            FileName parentName = childName.getParent();
            while (!done && parentName != null) {
                DelegateFileObject file = (DelegateFileObject)this.getFile(parentName);
                if (file == null) {
                    file = new DelegateFileObject(parentName, this, null);
                    this.putFile(file);
                } else {
                    done = file.exists();
                }
                file.attachChild(childName.getBaseName());
                childName = parentName;
                parentName = parentName.getParent();
            }
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.impl/create-junction.error", junctionName);
        }
    }

    public void removeJunction(String junctionPoint) throws FileSystemException {
        FileName junctionName = this.getRootName().resolveName(junctionPoint);
        this.junctions.remove(junctionName);
    }

    private FileName getJunctionForFile(FileName name) {
        if (this.junctions.containsKey(name)) {
            return name;
        }
        Iterator iterator = this.junctions.keySet().iterator();
        while (iterator.hasNext()) {
            FileName junctionPoint = (FileName)iterator.next();
            if (!junctionPoint.isDescendent(name)) continue;
            return junctionPoint;
        }
        return null;
    }
}

