/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileChangeEvent;
import org.apache.commons.vfs.FileListener;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.AbstractVfsComponent;
import org.apache.commons.vfs.util.Messages;

public abstract class AbstractFileSystem
extends AbstractVfsComponent
implements FileSystem {
    private final FileName rootName;
    private FileObject parentLayer;
    private FileObject root;
    private final Collection caps = new HashSet();
    private final Map files = new HashMap();
    private final Map listenerMap = new HashMap();

    protected AbstractFileSystem(FileName rootName, FileObject parentLayer) {
        this.parentLayer = parentLayer;
        this.rootName = rootName;
    }

    public void init() throws FileSystemException {
        this.addCapabilities(this.caps);
    }

    public void close() {
        this.files.clear();
    }

    protected abstract FileObject createFile(FileName var1) throws Exception;

    protected abstract void addCapabilities(Collection var1);

    protected FileName getRootName() {
        return this.rootName;
    }

    protected void putFile(FileObject file) {
        this.files.put(file.getName(), file);
    }

    protected FileObject getFile(FileName name) {
        return (FileObject)this.files.get(name);
    }

    public boolean hasCapability(Capability capability) {
        return this.caps.contains(capability);
    }

    public Object getAttribute(String attrName) throws FileSystemException {
        throw new FileSystemException("vfs.provider/get-attribute-not-supported.error");
    }

    public void setAttribute(String attrName, Object value) throws FileSystemException {
        throw new FileSystemException("vfs.provider/set-attribute-not-supported.error");
    }

    public FileObject getParentLayer() throws FileSystemException {
        return this.parentLayer;
    }

    public FileObject getRoot() throws FileSystemException {
        if (this.root == null) {
            this.root = this.resolveFile(this.rootName);
        }
        return this.root;
    }

    public FileObject resolveFile(String nameStr) throws FileSystemException {
        FileName name = this.rootName.resolveName(nameStr);
        return this.resolveFile(name);
    }

    public FileObject resolveFile(FileName name) throws FileSystemException {
        if (!this.rootName.getRootURI().equals(name.getRootURI())) {
            throw new FileSystemException("vfs.provider/mismatched-fs-for-name.error", new Object[]{name, this.rootName});
        }
        FileObject file = (FileObject)this.files.get(name);
        if (file == null) {
            try {
                file = this.createFile(name);
            }
            catch (Exception e) {
                throw new FileSystemException("vfs.provider/create-file.error", name);
            }
            this.files.put(name, file);
        }
        return file;
    }

    public File replicateFile(FileObject file, FileSelector selector) throws FileSystemException {
        if (!file.exists()) {
            throw new FileSystemException("vfs.provider/replicate-missing-file.error", file.getName());
        }
        try {
            return this.doReplicateFile(file, selector);
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/replicate-file.error", file.getName(), (Throwable)e);
        }
    }

    protected File doReplicateFile(FileObject file, FileSelector selector) throws Exception {
        return this.getContext().getReplicator().replicateFile(file, selector);
    }

    public void addJunction(String junctionPoint, FileObject targetFile) throws FileSystemException {
        throw new FileSystemException("vfs.provider/junctions-not-supported.error", this.rootName);
    }

    public void removeJunction(String junctionPoint) throws FileSystemException {
        throw new FileSystemException("vfs.provider/junctions-not-supported.error", this.rootName);
    }

    public void addListener(FileObject file, FileListener listener) {
        ArrayList<FileListener> listeners = (ArrayList<FileListener>)this.listenerMap.get(file.getName());
        if (listeners == null) {
            listeners = new ArrayList<FileListener>();
            this.listenerMap.put(file.getName(), listeners);
        }
        listeners.add(listener);
    }

    public void removeListener(FileObject file, FileListener listener) {
        ArrayList listeners = (ArrayList)this.listenerMap.get(file.getName());
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    protected void fireFileCreated(FileObject file) {
        this.fireEvent(new CreateEvent(file));
    }

    protected void fireFileDeleted(FileObject file) {
        this.fireEvent(new DeleteEvent(file));
    }

    private void fireEvent(ChangeEvent event) {
        FileObject file = event.getFile();
        ArrayList listeners = (ArrayList)this.listenerMap.get(file.getName());
        if (listeners != null) {
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                FileListener listener = (FileListener)listeners.get(i);
                try {
                    event.notify(listener);
                }
                catch (Exception e) {
                    String message = Messages.getString("vfs.provider/notify-listener.warn", file);
                    this.getLogger().warn((Object)message, (Throwable)e);
                }
                ++i;
            }
        }
    }

    private static class DeleteEvent
    extends ChangeEvent {
        public DeleteEvent(FileObject file) {
            super(file);
        }

        public void notify(FileListener listener) throws Exception {
            listener.fileDeleted(this);
        }
    }

    private static class CreateEvent
    extends ChangeEvent {
        public CreateEvent(FileObject file) {
            super(file);
        }

        public void notify(FileListener listener) throws Exception {
            listener.fileCreated(this);
        }
    }

    private static abstract class ChangeEvent
    extends FileChangeEvent {
        public ChangeEvent(FileObject file) {
            super(file);
        }

        public abstract void notify(FileListener var1) throws Exception;
    }
}

