/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileSystemException;

public final class DefaultURLConnection
extends URLConnection {
    private final FileContent content;

    public DefaultURLConnection(URL url, FileContent content) {
        super(url);
        this.content = content;
    }

    public void connect() {
        this.connected = true;
    }

    public InputStream getInputStream() throws IOException {
        return this.content.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.content.getOutputStream();
    }

    public int getContentLength() {
        try {
            return (int)this.content.getSize();
        }
        catch (FileSystemException fse) {
            return -1;
        }
    }
}

