/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.ftp;

import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.commons.vfs.provider.ftp.FtpFileObject;

final class FtpFileSystem
extends AbstractFileSystem {
    private final String hostname;
    private final int port;
    private final String username;
    private final String password;
    private FTPClient idleClient;
    private Hashtable attributes = new Hashtable();
    public static String ATTRIBUTE_ABSOLUTE = "ABSOLUTE";

    public Object getAttribute(String attrName) throws FileSystemException {
        if (attrName.equals(ATTRIBUTE_ABSOLUTE)) {
            return this.attributes.get(ATTRIBUTE_ABSOLUTE);
        }
        return super.getAttribute(attrName);
    }

    public void setAttribute(String attrName, Object value) throws FileSystemException {
        if (attrName.equals(ATTRIBUTE_ABSOLUTE)) {
            this.attributes.put(ATTRIBUTE_ABSOLUTE, value);
        } else {
            super.setAttribute(attrName, value);
        }
    }

    public FtpFileSystem(GenericFileName rootName) {
        super(rootName, null);
        this.hostname = rootName.getHostName();
        this.port = rootName.getPort();
        this.username = rootName.getUserName() == null ? "anonymous" : rootName.getUserName();
        this.password = rootName.getPassword() == null ? "anonymous" : rootName.getPassword();
    }

    public void close() {
        if (this.idleClient != null) {
            this.closeConnection(this.idleClient);
        }
        super.close();
    }

    protected void addCapabilities(Collection caps) {
        caps.add(Capability.CREATE);
        caps.add(Capability.DELETE);
        caps.add(Capability.GET_TYPE);
        caps.add(Capability.LIST_CHILDREN);
        caps.add(Capability.READ_CONTENT);
        caps.add(Capability.SET_LAST_MODIFIED);
        caps.add(Capability.GET_LAST_MODIFIED);
        caps.add(Capability.URI);
        caps.add(Capability.WRITE_CONTENT);
    }

    private void closeConnection(FTPClient client) {
        try {
            if (client.isConnected()) {
                client.disconnect();
            }
        }
        catch (IOException e) {
            this.getLogger().warn((Object)"vfs.provider.ftp/close-connection.error", (Throwable)e);
        }
    }

    public FTPClient getClient() throws FileSystemException {
        FTPClient returnClient = null;
        if (this.idleClient == null) {
            returnClient = this.createConnection();
        } else {
            FTPClient client = this.idleClient;
            this.idleClient = null;
            returnClient = client;
        }
        try {
            if (this.attributes.get(ATTRIBUTE_ABSOLUTE) != null && this.attributes.get(ATTRIBUTE_ABSOLUTE).equals(Boolean.TRUE)) {
                returnClient.changeWorkingDirectory("/");
            }
        }
        catch (IOException ioe) {
            throw new FileSystemException(ioe);
        }
        return returnClient;
    }

    public void putClient(FTPClient client) {
        if (this.idleClient == null) {
            this.idleClient = client;
        } else {
            this.closeConnection(client);
        }
    }

    protected FileObject createFile(FileName name) throws FileSystemException {
        return new FtpFileObject(name, this, this.getRootName());
    }

    private FTPClient createConnection() throws FileSystemException {
        try {
            FTPClient client = new FTPClient();
            try {
                client.connect(this.hostname, this.port);
                int reply = client.getReplyCode();
                if (!FTPReply.isPositiveCompletion((int)reply)) {
                    throw new FileSystemException("vfs.provider.ftp/connect-rejected.error", this.hostname);
                }
                if (!client.login(this.username, this.password)) {
                    throw new FileSystemException("vfs.provider.ftp/login.error", new Object[]{this.hostname, this.username}, null);
                }
                if (!client.setFileType(2)) {
                    throw new FileSystemException("vfs.provider.ftp/set-binary.error", this.hostname);
                }
            }
            catch (IOException e) {
                this.closeConnection(client);
                throw e;
            }
            return client;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider.ftp/connect.error", new Object[]{this.hostname}, (Throwable)exc);
        }
    }
}

