/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.http;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.util.DateParser;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.http.HttpFileSystem;
import org.apache.commons.vfs.util.MonitorInputStream;

public class HttpFileObject
extends AbstractFileObject {
    private final HttpFileSystem fileSystem;
    private HeadMethod method;

    public HttpFileObject(FileName name, HttpFileSystem fileSystem) {
        super(name, fileSystem);
        this.fileSystem = fileSystem;
    }

    protected void doDetach() throws Exception {
        this.method = null;
    }

    protected FileType doGetType() throws Exception {
        this.method = new HeadMethod();
        this.setupMethod((HttpMethod)this.method);
        HttpClient client = this.fileSystem.getClient();
        int status = client.executeMethod((HttpMethod)this.method);
        this.method.releaseConnection();
        if (status == 200) {
            return FileType.FILE;
        }
        if (status == 404 || status == 410) {
            return FileType.IMAGINARY;
        }
        throw new FileSystemException("vfs.provider.http/head.error", this.getName());
    }

    protected String[] doListChildren() throws Exception {
        throw new Exception("Not implemented.");
    }

    protected long doGetContentSize() throws Exception {
        Header header = this.method.getResponseHeader("content-length");
        if (header == null) {
            return 0L;
        }
        return Integer.parseInt(header.getValue());
    }

    protected long doGetLastModifiedTime() throws Exception {
        Header header = this.method.getResponseHeader("last-modified");
        if (header == null) {
            throw new FileSystemException("vfs.provider.http/last-modified.error", this.getName());
        }
        return DateParser.parseDate((String)header.getValue()).getTime();
    }

    protected InputStream doGetInputStream() throws Exception {
        GetMethod getMethod = new GetMethod();
        this.setupMethod((HttpMethod)getMethod);
        int status = this.fileSystem.getClient().executeMethod((HttpMethod)getMethod);
        if (status != 200) {
            throw new FileSystemException("vfs.provider.http/get.error", this.getName());
        }
        return new HttpInputStream(getMethod);
    }

    private void setupMethod(HttpMethod method) {
        method.setPath(this.getName().getPath());
        method.setFollowRedirects(true);
        method.setRequestHeader("User-Agent", "Jakarta-Commons-VFS");
    }

    private static class HttpInputStream
    extends MonitorInputStream {
        private final GetMethod method;

        public HttpInputStream(GetMethod method) throws IOException {
            super(method.getResponseBodyAsStream());
            this.method = method;
        }

        protected void onClose() throws IOException {
            this.method.releaseConnection();
        }
    }
}

