/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.tasks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.NameScope;
import org.apache.commons.vfs.Selectors;
import org.apache.commons.vfs.tasks.VfsTask;
import org.apache.commons.vfs.util.Messages;
import org.apache.tools.ant.BuildException;

public abstract class AbstractSyncTask
extends VfsTask {
    private final ArrayList srcFiles = new ArrayList();
    private String destFileUrl;
    private String destDirUrl;

    public void setDestFile(String destFile) {
        this.destFileUrl = destFile;
    }

    public void setDestDir(String destDir) {
        this.destDirUrl = destDir;
    }

    public void setSrc(String srcFile) {
        SourceInfo src = new SourceInfo();
        src.setFile(srcFile);
        this.addConfiguredSrc(src);
    }

    public void addConfiguredSrc(SourceInfo srcInfo) throws BuildException {
        if (srcInfo.file == null) {
            String message = Messages.getString("vfs.tasks/sync.no-source-file.error");
            throw new BuildException(message);
        }
        this.srcFiles.add(srcInfo);
    }

    public void execute() throws BuildException {
        if (this.destFileUrl == null && this.destDirUrl == null) {
            String message = Messages.getString("vfs.tasks/sync.no-destination.error");
            throw new BuildException(message);
        }
        if (this.destFileUrl != null && this.destDirUrl != null) {
            String message = Messages.getString("vfs.tasks/sync.too-many-destinations.error");
            throw new BuildException(message);
        }
        if (this.srcFiles.size() == 0) {
            String message = Messages.getString("vfs.tasks/sync.no-source-files.warn");
            this.log(message, 1);
            return;
        }
        try {
            if (this.destFileUrl != null) {
                this.handleSingleFile();
            } else {
                this.handleFiles();
            }
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    private void handleFiles() throws Exception {
        FileObject destFile;
        FileObject destFolder = this.resolveFile(this.destDirUrl);
        destFolder.createFolder();
        ArrayList<FileObject> srcs = new ArrayList<FileObject>();
        int i = 0;
        while (i < this.srcFiles.size()) {
            SourceInfo src = (SourceInfo)this.srcFiles.get(i);
            FileObject srcFile = this.resolveFile(src.file);
            if (!srcFile.exists()) {
                String message = Messages.getString("vfs.tasks/sync.src-file-no-exist.warn", srcFile);
                this.log(message, 1);
            } else {
                srcs.add(srcFile);
            }
            ++i;
        }
        HashSet destFiles = new HashSet();
        int i2 = 0;
        while (i2 < srcs.size()) {
            FileObject rootFile = (FileObject)srcs.get(i2);
            FileName rootName = rootFile.getName();
            if (rootFile.getType() == FileType.FILE) {
                destFile = destFolder.resolveFile(rootName.getBaseName(), NameScope.DESCENDENT);
                this.handleFile(destFiles, rootFile, destFile);
            } else {
                FileObject[] files = rootFile.findFiles(Selectors.SELECT_FILES);
                int j = 0;
                while (j < files.length) {
                    FileObject srcFile = files[j];
                    String relName = rootName.getRelativeName(srcFile.getName());
                    FileObject destFile2 = destFolder.resolveFile(relName, NameScope.DESCENDENT);
                    this.handleFile(destFiles, srcFile, destFile2);
                    ++j;
                }
            }
            ++i2;
        }
        if (this.detectMissingSourceFiles()) {
            FileObject[] allDestFiles = destFolder.findFiles(Selectors.SELECT_FILES);
            int i3 = 0;
            while (i3 < allDestFiles.length) {
                destFile = allDestFiles[i3];
                if (!destFiles.contains(destFile)) {
                    this.handleMissingSourceFile(destFile);
                }
                ++i3;
            }
        }
    }

    private void handleFile(Set destFiles, FileObject srcFile, FileObject destFile) throws Exception {
        if (destFiles.contains(destFile)) {
            String message = Messages.getString("vfs.tasks/sync.duplicate-source-files.warn", destFile);
            this.log(message, 1);
        } else {
            destFiles.add(destFile);
        }
        this.handleFile(srcFile, destFile);
    }

    private void handleSingleFile() throws Exception {
        if (this.srcFiles.size() > 1) {
            String message = Messages.getString("vfs.tasks/sync.too-many-source-files.error");
            throw new BuildException(message);
        }
        SourceInfo src = (SourceInfo)this.srcFiles.get(0);
        FileObject srcFile = this.resolveFile(src.file);
        if (srcFile.getType() != FileType.FILE) {
            String message = Messages.getString("vfs.tasks/sync.source-not-file.error", srcFile);
            throw new BuildException(message);
        }
        FileObject destFile = this.resolveFile(this.destFileUrl);
        this.handleFile(srcFile, destFile);
    }

    private void handleFile(FileObject srcFile, FileObject destFile) throws Exception {
        if (!destFile.exists() || srcFile.getContent().getLastModifiedTime() > destFile.getContent().getLastModifiedTime()) {
            this.handleOutOfDateFile(srcFile, destFile);
        } else {
            this.handleUpToDateFile(srcFile, destFile);
        }
    }

    protected void handleOutOfDateFile(FileObject srcFile, FileObject destFile) throws Exception {
    }

    protected void handleUpToDateFile(FileObject srcFile, FileObject destFile) throws Exception {
    }

    protected void handleMissingSourceFile(FileObject destFile) throws Exception {
    }

    protected boolean detectMissingSourceFiles() {
        return false;
    }

    public static class SourceInfo {
        private String file;

        public void setFile(String file) {
            this.file = file;
        }
    }
}

