/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.exe;

import java.util.Stack;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.module.def.ModuleDefinition;
import org.jbpm.module.exe.ModuleInstance;
import org.jbpm.scheduler.exe.Timer;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.jbpm.taskmgmt.exe.TaskMgmtInstance;

public class ExecutionContext {
    protected Token token = null;
    protected Event event = null;
    protected GraphElement eventSource = null;
    protected Action action = null;
    protected Throwable exception = null;
    protected Transition transition = null;
    protected Node transitionSource = null;
    protected Task task = null;
    protected Timer timer = null;
    protected TaskInstance taskInstance = null;
    protected ProcessInstance subProcessInstance = null;
    static ThreadLocal threadLocalContextStack = new ThreadLocal();

    public ExecutionContext(Token token) {
        this.token = token;
    }

    public ExecutionContext(ExecutionContext other) {
        this.token = other.token;
        this.event = other.event;
        this.action = other.action;
    }

    public Node getNode() {
        return this.token.getNode();
    }

    public ProcessDefinition getProcessDefinition() {
        ProcessInstance processInstance = this.getProcessInstance();
        return processInstance != null ? processInstance.getProcessDefinition() : null;
    }

    public void setAction(Action action) {
        this.action = action;
        if (action != null) {
            this.event = action.getEvent();
        }
    }

    public ProcessInstance getProcessInstance() {
        return this.token.getProcessInstance();
    }

    public String toString() {
        return "ExecutionContext[" + this.token + "]";
    }

    public void setVariable(String name, Object value) {
        if (this.taskInstance != null) {
            this.taskInstance.setVariable(name, value);
        } else {
            this.getContextInstance().setVariable(name, value, this.token);
        }
    }

    public Object getVariable(String name) {
        if (this.taskInstance != null) {
            return this.taskInstance.getVariable(name);
        }
        return this.getContextInstance().getVariable(name, this.token);
    }

    public void leaveNode() {
        this.getNode().leave(this);
    }

    public void leaveNode(String transitionName) {
        this.getNode().leave(this, transitionName);
    }

    public void leaveNode(Transition transition) {
        this.getNode().leave(this, transition);
    }

    public ModuleDefinition getDefinition(Class clazz) {
        return this.getProcessDefinition().getDefinition(clazz);
    }

    public ModuleInstance getInstance(Class clazz) {
        ProcessInstance processInstance = this.token != null ? this.token.getProcessInstance() : null;
        return processInstance != null ? processInstance.getInstance(clazz) : null;
    }

    public ContextInstance getContextInstance() {
        return (ContextInstance)this.getInstance(ContextInstance.class);
    }

    public TaskMgmtInstance getTaskMgmtInstance() {
        return (TaskMgmtInstance)this.getInstance(TaskMgmtInstance.class);
    }

    public JbpmContext getJbpmContext() {
        return JbpmContext.getCurrentJbpmContext();
    }

    public void setTaskInstance(TaskInstance taskInstance) {
        this.taskInstance = taskInstance;
        this.task = taskInstance != null ? taskInstance.getTask() : null;
    }

    public Token getToken() {
        return this.token;
    }

    public Action getAction() {
        return this.action;
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public Transition getTransition() {
        return this.transition;
    }

    public void setTransition(Transition transition) {
        this.transition = transition;
    }

    public Node getTransitionSource() {
        return this.transitionSource;
    }

    public void setTransitionSource(Node transitionSource) {
        this.transitionSource = transitionSource;
    }

    public GraphElement getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(GraphElement eventSource) {
        this.eventSource = eventSource;
    }

    public Task getTask() {
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public TaskInstance getTaskInstance() {
        return this.taskInstance;
    }

    public ProcessInstance getSubProcessInstance() {
        return this.subProcessInstance;
    }

    public void setSubProcessInstance(ProcessInstance subProcessInstance) {
        this.subProcessInstance = subProcessInstance;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    static Stack getContextStack() {
        Stack stack = (Stack)threadLocalContextStack.get();
        if (stack == null) {
            stack = new Stack();
            threadLocalContextStack.set(stack);
        }
        return stack;
    }

    public static void pushCurrentContext(ExecutionContext executionContext) {
        ExecutionContext.getContextStack().push(executionContext);
    }

    public static void popCurrentContext(ExecutionContext executionContext) {
        if (ExecutionContext.getContextStack().pop() != executionContext) {
            throw new JbpmException("current execution context mismatch.  make sure that every pushed context gets popped");
        }
    }

    public static ExecutionContext currentExecutionContext() {
        ExecutionContext executionContext = null;
        Stack stack = ExecutionContext.getContextStack();
        if (!stack.isEmpty()) {
            executionContext = (ExecutionContext)stack.peek();
        }
        return executionContext;
    }
}

