/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.standard;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.Library;
import org.java.plugin.registry.PluginAttribute;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginElement;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.registry.UniqueIdentity;
import org.java.plugin.standard.CombinedFileFilter;
import org.java.plugin.standard.RegexpFileFilter;
import org.java.plugin.standard.ShadowDataController;
import org.java.plugin.standard.StandardPathResolver;
import org.java.plugin.util.ExtendedProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShadingPathResolver
extends StandardPathResolver {
    private static final String UNPACK_MODE_ALWAIS = "always";
    private static final String UNPACK_MODE_NEVER = "never";
    private static final String UNPACK_MODE_SMART = "smart";
    private File shadowFolder;
    private String unpackMode;
    private Map<String, URL> shadowUrlMap = new HashMap<String, URL>();
    private Map<String, Boolean> unpackModeMap = new HashMap<String, Boolean>();
    private ShadowDataController controller;

    @Override
    public synchronized void configure(ExtendedProperties extendedProperties) throws Exception {
        super.configure(extendedProperties);
        String string = extendedProperties.getProperty("shadowFolder");
        if (string != null && string.length() > 0) {
            try {
                this.shadowFolder = new File(string).getCanonicalFile();
            }
            catch (IOException iOException) {
                this.log.warn((Object)("failed initializing shadow folder " + string + ", falling back to the default folder"), (Throwable)iOException);
            }
        }
        if (this.shadowFolder == null) {
            this.shadowFolder = new File(System.getProperty("java.io.tmpdir"), ".jpf-shadow");
        }
        this.log.debug((Object)("shadow folder is " + this.shadowFolder));
        if (!this.shadowFolder.exists()) {
            this.shadowFolder.mkdirs();
        }
        this.unpackMode = extendedProperties.getProperty("unpackMode", UNPACK_MODE_SMART);
        this.log.debug((Object)("unpack mode parameter value is " + this.unpackMode));
        this.controller = ShadowDataController.init(this.shadowFolder, this.buildFileFilter(extendedProperties));
        this.log.info((Object)("configured, shadow folder is " + this.shadowFolder));
    }

    private FileFilter buildFileFilter(ExtendedProperties extendedProperties) {
        String string = extendedProperties.getProperty("includes");
        RegexpFileFilter regexpFileFilter = string != null && string.trim().length() > 0 ? new RegexpFileFilter(string) : null;
        string = extendedProperties.getProperty("excludes");
        RegexpFileFilter regexpFileFilter2 = string != null && string.trim().length() > 0 ? new RegexpFileFilter(string) : null;
        if (regexpFileFilter2 == null && regexpFileFilter == null) {
            return null;
        }
        return new CombinedFileFilter(regexpFileFilter, regexpFileFilter2);
    }

    @Override
    public void registerContext(Identity identity, URL uRL) {
        Boolean bl;
        super.registerContext(identity, uRL);
        if (UNPACK_MODE_ALWAIS.equalsIgnoreCase(this.unpackMode)) {
            bl = Boolean.TRUE;
        } else if (UNPACK_MODE_NEVER.equalsIgnoreCase(this.unpackMode)) {
            bl = Boolean.FALSE;
        } else {
            PluginDescriptor pluginDescriptor = null;
            PluginFragment pluginFragment = null;
            if (identity instanceof PluginDescriptor) {
                pluginDescriptor = (PluginDescriptor)identity;
            } else if (identity instanceof PluginFragment) {
                pluginFragment = (PluginFragment)identity;
                pluginDescriptor = pluginFragment.getRegistry().getPluginDescriptor(pluginFragment.getPluginId());
            } else if (identity instanceof PluginElement) {
                PluginElement pluginElement = (PluginElement)identity;
                pluginDescriptor = pluginElement.getDeclaringPluginDescriptor();
                pluginFragment = pluginElement.getDeclaringPluginFragment();
            } else {
                throw new IllegalArgumentException("unknown identity class " + identity.getClass().getName());
            }
            bl = this.getUnpackMode(pluginDescriptor, pluginFragment);
        }
        this.log.debug((Object)("unpack mode for " + identity + " is " + bl));
        this.unpackModeMap.put(identity.getId(), bl);
    }

    private Boolean getUnpackMode(PluginDescriptor pluginDescriptor, PluginFragment pluginFragment) {
        Iterator<PluginElement<PluginAttribute>> iterator = this.filterCollection(pluginDescriptor.getAttributes("unpack"), pluginFragment).iterator();
        if (iterator.hasNext()) {
            PluginAttribute pluginAttribute = iterator.next();
            return "false".equalsIgnoreCase(pluginAttribute.getValue());
        }
        for (Library library : this.filterCollection(pluginDescriptor.getLibraries(), pluginFragment)) {
            if (!library.isCodeLibrary() || !library.getPath().toLowerCase(Locale.getDefault()).endsWith(".jar") && !library.getPath().toLowerCase(Locale.getDefault()).endsWith(".zip")) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private <T extends PluginElement<?>> Collection<T> filterCollection(Collection<T> collection, PluginFragment pluginFragment) {
        if (pluginFragment == null) {
            return collection;
        }
        LinkedList<PluginElement> linkedList = new LinkedList<PluginElement>();
        for (PluginElement pluginElement : collection) {
            if (!pluginFragment.equals(pluginElement.getDeclaringPluginFragment())) continue;
            linkedList.add(pluginElement);
        }
        return linkedList;
    }

    @Override
    public void unregisterContext(String string) {
        this.shadowUrlMap.remove(string);
        this.unpackModeMap.remove(string);
        super.unregisterContext(string);
    }

    @Override
    public URL resolvePath(Identity identity, String string) {
        URL uRL;
        if (identity instanceof PluginDescriptor) {
            uRL = this.getBaseUrl((PluginDescriptor)identity);
        } else if (identity instanceof PluginFragment) {
            uRL = this.getBaseUrl((PluginFragment)identity);
        } else if (identity instanceof PluginElement) {
            PluginElement pluginElement = (PluginElement)identity;
            uRL = pluginElement.getDeclaringPluginFragment() != null ? this.getBaseUrl(pluginElement.getDeclaringPluginFragment()) : this.getBaseUrl(pluginElement.getDeclaringPluginDescriptor());
        } else {
            throw new IllegalArgumentException("unknown identity class " + identity.getClass().getName());
        }
        return this.resolvePath(uRL, string);
    }

    protected synchronized URL getBaseUrl(UniqueIdentity uniqueIdentity) {
        URL uRL = this.shadowUrlMap.get(uniqueIdentity.getId());
        if (uRL != null) {
            return uRL;
        }
        uRL = this.controller.shadowResource(this.getRegisteredContext(uniqueIdentity.getId()), uniqueIdentity.getUniqueId(), this.unpackModeMap.get(uniqueIdentity.getId()));
        this.shadowUrlMap.put(uniqueIdentity.getId(), uRL);
        return uRL;
    }
}

