/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl;

import java.util.Properties;
import java.util.logging.Logger;
import net.xeoh.plugins.base.PluginConfiguration;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import net.xeoh.plugins.base.annotations.meta.Author;
import net.xeoh.plugins.base.annotations.meta.Version;

@Author(name="Ralf Biedert")
@PluginImplementation
@Version(version=10000)
public class PluginConfigurationImpl
implements PluginConfiguration {
    final Properties configuration;
    final Logger logger = Logger.getLogger(this.getClass().getName());

    protected PluginConfigurationImpl(Properties initialProperties) {
        this.configuration = initialProperties;
    }

    @Override
    public synchronized String getConfiguration(Class<?> root, String subkey) {
        return this.configuration.getProperty(this.getKey(root, subkey));
    }

    @Override
    public synchronized void setConfiguration(Class<?> root, String subkey, String value) {
        this.configuration.setProperty(this.getKey(root, subkey), value);
    }

    private String getKey(Class<?> root, String subkey) {
        String prefix = "";
        if (root != null) {
            prefix = root.getName() + ".";
        }
        this.logger.finer("Assembled key '" + prefix + subkey + "'");
        return prefix + subkey;
    }
}

