/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import net.xeoh.plugins.base.Option;
import net.xeoh.plugins.base.Plugin;
import net.xeoh.plugins.base.PluginConfiguration;
import net.xeoh.plugins.base.PluginInformation;
import net.xeoh.plugins.base.PluginManager;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import net.xeoh.plugins.base.annotations.meta.Author;
import net.xeoh.plugins.base.annotations.meta.Version;
import net.xeoh.plugins.base.impl.PluginConfigurationImpl;
import net.xeoh.plugins.base.impl.PluginInformationImpl;
import net.xeoh.plugins.base.impl.PluginSupervisorImpl;
import net.xeoh.plugins.base.impl.SpawnResult;
import net.xeoh.plugins.base.impl.Spawner;
import net.xeoh.plugins.base.impl.classpath.ClassPathManager;
import net.xeoh.plugins.base.impl.classpath.cache.JARCache;
import net.xeoh.plugins.base.impl.classpath.locator.ClassPathLocator;
import net.xeoh.plugins.base.impl.loader.AbstractLoader;
import net.xeoh.plugins.base.impl.loader.FileLoader;
import net.xeoh.plugins.base.impl.loader.HTTPLoader;
import net.xeoh.plugins.base.impl.loader.InternalClasspathLoader;
import net.xeoh.plugins.base.impl.metahandling.PluginMetaHandler;
import net.xeoh.plugins.base.impl.metahandling.PluginWrapper;
import net.xeoh.plugins.base.impl.registry.PluggableMetaInformation;
import net.xeoh.plugins.base.impl.registry.PluginRegistry;
import net.xeoh.plugins.base.options.AddPluginsFromOption;
import net.xeoh.plugins.base.options.GetPluginOption;
import net.xeoh.plugins.base.options.addpluginsfrom.OptionLoadAsynchronously;
import net.xeoh.plugins.base.options.getplugin.OptionCapabilities;
import net.xeoh.plugins.base.options.getplugin.OptionPluginSelector;
import net.xeoh.plugins.base.options.getplugin.PluginSelector;
import net.xeoh.plugins.base.util.OptionUtils;
import net.xeoh.plugins.base.util.PluginConfigurationUtil;
import net.xeoh.plugins.base.util.PluginManagerUtil;
import net.xeoh.plugins.bus.impl.BusImpl;
import net.xeoh.plugins.informationbroker.impl.InformationBrokerImpl;

@PluginImplementation
@Version(version=10000)
@Author(name="Ralf Biedert")
public class PluginManagerImpl
implements PluginManager {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Random random = new Random();
    private final String cachePath;
    private final PluginConfiguration configuration;
    private final PluginSupervisorImpl pluginSupervisor;
    private final Lock pluginListLock = new ReentrantLock();
    private final Lock addPluginLock = new ReentrantLock();
    private final PluginManagerUtil pluginManagerUtil;
    PluginInformation information;
    private final Collection<AbstractLoader> pluginLoader = new ArrayList<AbstractLoader>();
    private final JARCache jarCache = new JARCache();
    private final PluginRegistry pluginRegistry = new PluginRegistry();
    private final Spawner spawner;
    private final ClassPathLocator classPathLocator;
    private final ClassPathManager classPathManager;
    int pluginManagerID = this.random.nextInt();
    private boolean shutdownPerformed = false;
    private boolean wrapPluginsInMetaProxy = false;

    protected PluginManagerImpl(Properties initialProperties) {
        this.classPathLocator = new ClassPathLocator(this.jarCache);
        this.classPathManager = new ClassPathManager();
        this.pluginManagerUtil = new PluginManagerUtil(this);
        this.spawner = new Spawner(this);
        this.configuration = new PluginConfigurationImpl(initialProperties);
        this.pluginSupervisor = new PluginSupervisorImpl();
        this.setupMetaHandling();
        this.hookPlugin(new SpawnResult(this, SpawnResult.SpawnType.PLUGIN));
        this.hookPlugin(new SpawnResult(this.configuration, SpawnResult.SpawnType.PLUGIN));
        this.hookPlugin(new SpawnResult(this.pluginSupervisor, SpawnResult.SpawnType.PLUGIN));
        this.cachePath = this.configuration.getConfiguration(PluginManager.class, "cache.file");
        this.pluginLoader.add(new InternalClasspathLoader(this));
        this.pluginLoader.add(new FileLoader(this));
        this.pluginLoader.add(new HTTPLoader(this));
        this.loadAdditionalPlugins();
        this.applyConfig();
    }

    @Override
    public void addPluginsFrom(final URI url, final AddPluginsFromOption ... options) {
        this.logger.fine("Adding plugins from " + url);
        OptionUtils ou = new OptionUtils((Option[])options);
        if (ou.contains(OptionLoadAsynchronously.class)) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    PluginManagerImpl.this.doAddPluginsFrom(url, options);
                }
            });
            t.setDaemon(true);
            t.start();
            return;
        }
        this.doAddPluginsFrom(url, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doAddPluginsFrom(URI url, AddPluginsFromOption ... options) {
        this.addPluginLock.lock();
        try {
            this.jarCache.loadCache(this.cachePath);
            for (AbstractLoader loader : this.pluginLoader) {
                if (!loader.handlesURI(url)) continue;
                loader.loadFrom(url);
                return;
            }
        }
        finally {
            this.jarCache.saveCache(this.cachePath);
            this.addPluginLock.unlock();
        }
        this.logger.severe("Unable to add elements, as method is unimplemented for that target : " + url);
    }

    @Override
    public <P extends Plugin> P getPlugin(Class<P> requestedPlugin, GetPluginOption ... options) {
        OptionUtils ou = new OptionUtils((Option[])options);
        PluginSelector pluginSelector = null;
        if (ou.contains(OptionPluginSelector.class)) {
            pluginSelector = ((OptionPluginSelector)ou.get(OptionPluginSelector.class, new OptionPluginSelector[0])).getSelector();
        } else {
            String[] capabilites = ((OptionCapabilities)ou.get(OptionCapabilities.class, new OptionCapabilities[]{new OptionCapabilities(new String[0])})).getCapabilities();
            final List<String> caps = Arrays.asList(capabilites);
            pluginSelector = new PluginSelector<P>(){

                @Override
                public boolean selectPlugin(Plugin plugin) {
                    if (caps.size() > 0) {
                        Collection<String> pcaps = PluginManagerImpl.this.information.getInformation(PluginInformation.Information.CAPABILITIES, plugin);
                        return pcaps.containsAll(caps);
                    }
                    return true;
                }
            };
        }
        P plugin = this.getPlugin(requestedPlugin, pluginSelector);
        return plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <P extends Plugin> P getPlugin(Class<P> requestedPlugin, PluginSelector<P> selector) {
        try {
            this.pluginListLock.lock();
            for (Plugin plugin : this.pluginRegistry.getAllPlugins()) {
                PluggableMetaInformation metaInformation = this.pluginRegistry.getMetaInformationFor(plugin);
                if (metaInformation.pluginStatus != PluggableMetaInformation.PluginStatus.ACTIVE) continue;
                if (!requestedPlugin.isAssignableFrom(plugin.getClass()) || !selector.selectPlugin(plugin)) continue;
                Plugin plugin2 = plugin;
                return (P)plugin2;
            }
            P p = null;
            return p;
        }
        finally {
            this.pluginListLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.logger.fine("Dumping shutdown cause.");
        try {
            StackTraceElement[] stackTrace;
            for (StackTraceElement se : stackTrace = Thread.currentThread().getStackTrace()) {
                this.logger.finer(se.getClassName() + "." + se.getMethodName() + ":" + se.getLineNumber());
            }
        }
        catch (Exception e) {
            this.logger.fine("Error generating shutdown strack trace");
        }
        boolean lockA = false;
        boolean lockB = false;
        try {
            this.pluginListLock.tryLock(500L, TimeUnit.MILLISECONDS);
            this.addPluginLock.tryLock(500L, TimeUnit.MILLISECONDS);
            if (this.shutdownPerformed) {
                return;
            }
            for (Plugin p : this.pluginRegistry.getAllPlugins()) {
                this.spawner.destroyPluggable(p, this.pluginRegistry.getMetaInformationFor(p));
            }
            this.pluginRegistry.clear();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.shutdownPerformed = true;
            if (lockA) {
                this.pluginListLock.unlock();
            }
            if (lockB) {
                this.addPluginLock.unlock();
            }
        }
    }

    private void applyConfig() {
        PluginConfigurationUtil pcu = new PluginConfigurationUtil(this.configuration);
        this.jarCache.setEnabled(pcu.getBoolean(PluginManager.class, "cache.enabled", false));
        String mode = pcu.getString(PluginManager.class, "cache.mode", "strong");
        if (mode.equals("weak")) {
            this.jarCache.setWeakMode(true);
        }
    }

    private void loadAdditionalPlugins() {
        this.hookPlugin(this.spawner.spawnPlugin(BusImpl.class));
        this.hookPlugin(this.spawner.spawnPlugin(InformationBrokerImpl.class));
        this.information = (PluginInformation)this.spawner.spawnPlugin(PluginInformationImpl.class).pluggable;
        ((PluginInformationImpl)this.information).pluginManager = this;
        this.hookPlugin(new SpawnResult(this.information, SpawnResult.SpawnType.PLUGIN));
        Collection<Plugin> allPlugins = this.pluginRegistry.getAllPlugins();
        for (Plugin plugin : allPlugins) {
            this.pluginRegistry.getMetaInformationFor((Plugin)plugin).pluginStatus = PluggableMetaInformation.PluginStatus.ACTIVE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hookPlugin(SpawnResult p) {
        if (p.spawnType != SpawnResult.SpawnType.PLUGIN) {
            throw new IllegalStateException("May only hook plugins!");
        }
        this.pluginListLock.lock();
        try {
            Plugin plugin = (Plugin)p.pluggable;
            if (plugin != this && plugin != this.pluginSupervisor && this.wrapPluginsInMetaProxy) {
                Class<?>[] internalInterfaces = plugin.getClass().getInterfaces();
                Class[] interfaces = new Class[internalInterfaces.length + 1];
                System.arraycopy(internalInterfaces, 0, interfaces, 0, internalInterfaces.length);
                interfaces[interfaces.length - 1] = PluginWrapper.class;
                plugin = (Plugin)Proxy.newProxyInstance(plugin.getClass().getClassLoader(), interfaces, (InvocationHandler)new PluginMetaHandler(this.pluginSupervisor, plugin));
            }
            this.processPluginLoadedAnnotationForThisPlugin(p);
            this.pluginRegistry.registerPlugin(plugin, p.metaInformation);
            this.processPluginLoadedAnnotationForOtherPlugins(p);
        }
        finally {
            this.pluginListLock.unlock();
        }
    }

    private void processPluginLoadedAnnotationForThisPlugin(SpawnResult spawnResult) {
        if (spawnResult.spawnType != SpawnResult.SpawnType.PLUGIN) {
            throw new IllegalStateException("May only process annotations for plugins!");
        }
        for (PluggableMetaInformation.PluginLoadedInformation pli : spawnResult.metaInformation.pluginLoadedInformation) {
            Collection<? extends Plugin> plins = this.pluginManagerUtil.getPlugins(pli.baseType);
            for (Plugin plugin : plins) {
                try {
                    pli.method.invoke((Object)spawnResult.pluggable, plugin);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            pli.calledWith.addAll(plins);
        }
    }

    private void processPluginLoadedAnnotationForOtherPlugins(SpawnResult spawnResult) {
        for (Plugin plugin : this.pluginRegistry.getAllPlugins()) {
            PluggableMetaInformation pmi = this.pluginRegistry.getMetaInformationFor(plugin);
            for (PluggableMetaInformation.PluginLoadedInformation pli : pmi.pluginLoadedInformation) {
                Collection<? extends Plugin> plins = this.pluginManagerUtil.getPlugins(pli.baseType);
                if (!plins.contains(spawnResult.pluggable)) continue;
                try {
                    pli.method.invoke((Object)plugin, spawnResult.pluggable);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                pli.calledWith.add((Plugin)spawnResult.pluggable);
            }
        }
    }

    private void setupMetaHandling() {
        String cfg = this.configuration.getConfiguration(PluginManager.class, "supervision.enabled");
        if (cfg != null && cfg.equals("true")) {
            this.wrapPluginsInMetaProxy = true;
        }
    }

    public JARCache getJARCache() {
        return this.jarCache;
    }

    public ClassPathManager getClassPathManager() {
        return this.classPathManager;
    }

    public PluginRegistry getPluginRegistry() {
        return this.pluginRegistry;
    }

    public PluginConfiguration getPluginConfiguration() {
        return this.configuration;
    }

    public Spawner getSpawner() {
        return this.spawner;
    }

    public ClassPathLocator getClassPathLocator() {
        return this.classPathLocator;
    }
}

